/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

public class SeashellItem
extends BlockItem {
    public SeashellItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResultHolder resultHolder = super.use(world, player, hand);
        ItemStack stack = (ItemStack)resultHolder.getObject();
        player.swing(hand);
        if (!world.isClientSide) {
            Level level;
            world.playSound(player, player.blockPosition().above(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.PLAYERS, 1.0f, 1.0f);
            MinecraftServer minecraftServer = player.level().getServer();
            if (minecraftServer != null && (level = player.level()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                LootParams lootContext = new LootParams.Builder(server).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.GIFT);
                LootTable treasure = minecraftServer.reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BeachpartyIdentifier.identifier("gameplay/seashell")));
                treasure.getRandomItems(lootContext).forEach(arg_0 -> ((Player)player).addItem(arg_0));
            }
        }
        stack.shrink(1);
        return resultHolder;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.canbeplaced").withStyle(style -> style.withColor(TextColor.fromRgb((int)13939843))));
    }
}

