/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.world.placers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.satisfy.beachparty.core.registry.PlacerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class CrookedTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CrookedTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(placer -> CrookedTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)placer).apply((Applicative)placer, CrookedTrunkPlacer::new));

    public CrookedTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)PlacerTypeRegistry.CROOKED_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(pRandom);
        BlockPos.MutableBlockPos mutableBlockPos = pPos.mutable();
        this.placeLog(pLevel, pBlockSetter, pRandom, mutableBlockPos.relative(direction.getOpposite()), pConfig, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
        this.placeLog(pLevel, pBlockSetter, pRandom, mutableBlockPos.relative(pRandom.nextInt(2) == 0 ? direction.getClockWise() : direction.getCounterClockWise()), pConfig);
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            if (pRandom.nextFloat() < 0.4f && i > 2) {
                mutableBlockPos.move(direction);
            }
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)mutableBlockPos, pConfig);
            mutableBlockPos.move(Direction.UP);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment((BlockPos)mutableBlockPos, 0, false));
    }
}

