/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.world.placers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.beachparty.core.block.HangingCoconutBlock;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.PlacerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(placer -> PalmFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)placer).apply((Applicative)placer, PalmFoliagePlacer::new));

    public PalmFoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        super(pRadius, pOffset);
    }

    private static void createQuadrant(Direction direction, BlockPos startingPos, LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource pRandom, TreeConfiguration pConfig) {
        int i;
        BlockPos.MutableBlockPos pos = startingPos.mutable();
        pos.move(direction);
        PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        if (pRandom.nextInt(2) == 0 && pLevel.isStateAtPosition(pos.below(), BlockBehaviour.BlockStateBase::isAir)) {
            foliageSetter.set(pos.below(), (BlockState)((Block)ObjectRegistry.HANGING_COCONUT.get()).defaultBlockState().setValue((Property)HangingCoconutBlock.AGE, (Comparable)Integer.valueOf(pRandom.nextInt(3))));
        }
        if (pRandom.nextInt(2) == 0 && pLevel.isStateAtPosition(pos.below().relative(direction.getCounterClockWise()), BlockBehaviour.BlockStateBase::isAir)) {
            foliageSetter.set(pos.below().relative(direction.getCounterClockWise()), (BlockState)((Block)ObjectRegistry.HANGING_COCONUT.get()).defaultBlockState().setValue((Property)HangingCoconutBlock.AGE, (Comparable)Integer.valueOf(pRandom.nextInt(3))));
        }
        for (i = 0; i < 2; ++i) {
            pos.move(direction);
            PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
            pos.move(Direction.DOWN);
            PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        }
        pos.set((Vec3i)startingPos);
        pos.move(direction).move(direction.getCounterClockWise());
        PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        pos.move(Direction.DOWN).move(direction.getCounterClockWise());
        PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        pos.move(direction);
        PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.relative(direction.getClockWise()));
        for (i = 0; i < 3; ++i) {
            PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
            pos.move(Direction.DOWN);
        }
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)PlacerTypeRegistry.PALM_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource pRandom, TreeConfiguration pConfig, int i, FoliagePlacer.FoliageAttachment pAttachment, int j, int k, int l) {
        BlockPos startingPos = pAttachment.pos();
        PalmFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)startingPos);
        PalmFoliagePlacer.createQuadrant(Direction.NORTH, startingPos, pLevel, foliageSetter, pRandom, pConfig);
        PalmFoliagePlacer.createQuadrant(Direction.EAST, startingPos, pLevel, foliageSetter, pRandom, pConfig);
        PalmFoliagePlacer.createQuadrant(Direction.SOUTH, startingPos, pLevel, foliageSetter, pRandom, pConfig);
        PalmFoliagePlacer.createQuadrant(Direction.WEST, startingPos, pLevel, foliageSetter, pRandom, pConfig);
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }
}

