/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.neoforge.client.extensions;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.satisfy.beachparty.core.item.DyeableBeachpartyArmorItem;
import net.satisfy.beachparty.core.registry.ArmorRegistry;
import org.jetbrains.annotations.NotNull;

public class DyeableBeachpartyArmorExtensions
implements IClientItemExtensions {
    @NotNull
    public Model getGenericArmorModel(@NotNull LivingEntity entity, @NotNull ItemStack stack, @NotNull EquipmentSlot slot, @NotNull HumanoidModel<?> original) {
        Item item = stack.getItem();
        if (!(item instanceof DyeableBeachpartyArmorItem)) {
            return original;
        }
        DyeableBeachpartyArmorItem item2 = (DyeableBeachpartyArmorItem)item;
        if (slot != item2.getEquipmentSlot()) {
            return original;
        }
        if (slot == EquipmentSlot.CHEST) {
            return ArmorRegistry.chestplateModel(stack.getItem(), original.body, original.leftArm, original.rightArm);
        }
        if (slot == EquipmentSlot.LEGS) {
            return ArmorRegistry.LeggingsModel(stack.getItem(), original.body, original.leftLeg, original.rightLeg);
        }
        if (slot == EquipmentSlot.FEET) {
            return ArmorRegistry.LeggingsModel(stack.getItem(), original.body, original.leftLeg, original.rightLeg);
        }
        return original;
    }

    public int getArmorLayerTintColor(@NotNull ItemStack stack, @NotNull LivingEntity entity, @NotNull ArmorMaterial.Layer layer, int layerIdx, int fallbackColor) {
        Item item = stack.getItem();
        if (!(item instanceof DyeableBeachpartyArmorItem)) {
            return fallbackColor;
        }
        DyeableBeachpartyArmorItem item2 = (DyeableBeachpartyArmorItem)item;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains("Visible") && !tag.getBoolean("Visible")) {
            return 0xFFFFFF;
        }
        if (layer.dyeable()) {
            return 0xFF000000 | item2.getColor(stack);
        }
        return -1;
    }
}

