/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.neoforge.client.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.model.RubberRingPelicanModel;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CuriosRubberRingPelicanRenderer
implements ICurioRenderer {
    private final RubberRingPelicanModel<LivingEntity> model = new RubberRingPelicanModel(Minecraft.getInstance().getEntityModels().bakeLayer(RubberRingPelicanModel.LAYER_LOCATION));
    private final ResourceLocation texture = BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_pelican.png");

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!slotContext.identifier().equals("belt")) {
            return;
        }
        if (stack.isEmpty() || !CuriosRubberRingPelicanRenderer.isRubberRing(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity == null) {
            return;
        }
        this.model.setupAnim((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        matrixStack.pushPose();
        if (livingEntity.isCrouching()) {
            matrixStack.translate(-0.4f, -1.4f, -0.5f);
            matrixStack.mulPose(new Quaternionf().rotationX((float)Math.toRadians(20.0)));
        } else {
            matrixStack.translate(-0.4f, -1.5f, 0.4f);
        }
        this.model.renderToBuffer(matrixStack, renderTypeBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.texture)), light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    private static boolean isRubberRing(ItemStack stack) {
        return stack.is((Item)ObjectRegistry.RUBBER_RING_PELICAN.get());
    }
}

