/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.block.ModBlocks;
import net.lyof.sortilege.block.custom.PotionCauldronBlock;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.item.ModItems;
import net.lyof.sortilege.item.custom.AntidotePotionItem;
import net.lyof.sortilege.item.custom.LapisShieldItem;
import net.lyof.sortilege.item.custom.potion.CustomPotionData;
import net.lyof.sortilege.item.custom.rendering.custom.WitchHatRenderer;
import net.lyof.sortilege.particle.ModParticles;
import net.lyof.sortilege.particle.custom.WispParticle;
import net.lyof.sortilege.recipe.crafting.RecipeLock;
import net.lyof.sortilege.recipe.enchanting.EnchantingCatalyst;
import net.lyof.sortilege.setup.ModPackets;
import net.lyof.sortilege.setup.ReloadListener;
import net.lyof.sortilege.setup.datagen.config.ConfiguredData;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_5272;

public class SortilegeClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ConfiguredData.registerClient();
        SortilegeClient.registerPackets();
        ColorProviderRegistry.ITEM.register(AntidotePotionItem::getItemColor, (Object[])new class_1935[]{ModItems.ANTIDOTE});
        ColorProviderRegistry.BLOCK.register(PotionCauldronBlock::getBlockColor, (Object[])new class_2248[]{ModBlocks.POTION_CAULDRON});
        ParticleFactoryRegistry.getInstance().register((class_2396)ModParticles.WISP_PIXEL, WispParticle.Factory::new);
        if (ConfigEntries.witchHatEnabled) {
            ArmorRenderer.register((ArmorRenderer)new WitchHatRenderer(), (class_1935[])new class_1935[]{ModItems.WITCH_HAT});
        }
        if (ConfigEntries.lapisShieldEnabled) {
            class_5272.method_27879((class_1792)ModItems.LAPIS_SHIELD, (class_2960)Sortilege.makeID("cooldown"), (stack, world, entity, seed) -> {
                stack.method_7948();
                return LapisShieldItem.isOnCooldown(stack) ? 1.0f : 0.0f;
            });
        }
    }

    private static void registerPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.WISP_PARTICLE_DISPLAY, (client, handler, buf, responseSender) -> {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float r = buf.readFloat();
            float g = buf.readFloat();
            float b = buf.readFloat();
            int amount = buf.readInt();
            int spread = amount == 1 ? 0 : 2;
            client.execute(() -> {
                for (int i = 0; i < amount; ++i) {
                    client.field_1687.method_8406((class_2394)ModParticles.WISP_PIXEL, x + (0.5 - Math.random()) * (double)spread, y + (0.5 - Math.random()) * (double)spread, z + (0.5 - Math.random()) * (double)spread, (double)r, (double)g, (double)b);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.LAPIS_SHIELD_COOLDOWN, (client, handler, buf, responseSender) -> {
            int id = buf.readInt();
            int cooldown = buf.readInt();
            client.execute(() -> {
                class_1297 e = handler.method_2890().method_8469(id);
                if (!(e instanceof class_1309)) {
                    Sortilege.log("Something went wrong while receiving a packet", 2);
                    return;
                }
                class_1309 entity = (class_1309)e;
                class_1799 stack = entity.method_6079();
                if (!ConfigEntries.lapisShieldEnabled || !stack.method_31574(ModItems.LAPIS_SHIELD)) {
                    return;
                }
                if (cooldown == 0) {
                    LapisShieldItem.removeCooldown(stack);
                } else {
                    LapisShieldItem.addCooldown(stack, cooldown);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.INITIALIZE, (client, handler, buf, responseSender) -> {
            int eventType = buf.readInt();
            if (eventType == 0) {
                ReloadListener.INSTANCE.reloadClient();
            } else if (eventType == 1) {
                EnchantingCatalyst.read(buf);
            } else if (eventType == 2) {
                CustomPotionData.read(buf);
            } else if (eventType == 3) {
                RecipeLock.read(buf);
            }
        });
    }
}

