/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.recipe.enchanting.EnchantingCatalyst;
import net.lyof.sortilege.util.MathHelper;
import net.lyof.sortilege.util.MixinAccess;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1718.class})
public abstract class EnchantmentScreenHandlerMixin
extends class_1703
implements MixinAccess {
    @Shadow
    @Final
    private class_1263 field_7809;
    @Shadow
    @Final
    private class_3914 field_7813;
    @Shadow
    @Final
    private class_5819 field_7811;
    @Shadow
    @Final
    public int[] field_7808;
    @Unique
    private final class_1263 catalyst = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            EnchantmentScreenHandlerMixin.this.method_7609(EnchantmentScreenHandlerMixin.this.field_7809);
        }
    };
    @Unique
    public final int[] catalyzed = new int[3];

    protected EnchantmentScreenHandlerMixin(@Nullable class_3917<?> type, int syncId) {
        super(type, syncId);
    }

    @Override
    public int getProperty(int i) {
        if (i == 3) {
            class_1799 stack = this.field_7809.method_5438(0);
            return stack.method_7960() || !stack.method_7923() || !ConfigEntries.bookCatalysts && EnchantingCatalyst.isEmpty() ? 0 : 1;
        }
        if (i >= 4) {
            return this.catalyst.method_5438(0).method_7960() ? 0 : 1;
        }
        return this.catalyzed[i];
    }

    @Inject(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at={@At(value="TAIL")})
    public void addCatalystSlot(int syncId, class_1661 playerInventory, class_3914 context, CallbackInfo ci) {
        if (!ConfigEntries.bookCatalysts && EnchantingCatalyst.isEmpty()) {
            return;
        }
        this.method_7621(new class_1735(this.catalyst, 0, 25, 20){

            public boolean method_7680(class_1799 stack) {
                return EnchantingCatalyst.isCatalyst(stack);
            }

            public boolean method_7682() {
                class_1799 stack = EnchantmentScreenHandlerMixin.this.field_7809.method_5438(0);
                return !stack.method_7960() && stack.method_7923();
            }
        });
        this.method_17362(class_3915.method_17406((int[])this.catalyzed, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.catalyzed, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.catalyzed, (int)2));
    }

    @Inject(method={"onClosed"}, at={@At(value="HEAD")})
    public void dropCatalyst(class_1657 player, CallbackInfo ci) {
        this.field_7813.method_17393((world, pos) -> this.method_7607(player, this.catalyst));
    }

    @WrapOperation(method={"generateEnchantments"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;generateEnchantments(Lnet/minecraft/util/math/random/Random;Lnet/minecraft/item/ItemStack;IZ)Ljava/util/List;")})
    public List<class_1889> overrideDefaultEnchanting(class_5819 random, class_1799 stack, int level, boolean treasureAllowed, Operation<List<class_1889>> original) {
        if (ConfigEntries.overrideDefaultEnchanting) {
            return new ArrayList<class_1889>();
        }
        return (List)original.call(new Object[]{random, stack, level, treasureAllowed});
    }

    @ModifyReturnValue(method={"generateEnchantments"}, at={@At(value="RETURN")})
    public List<class_1889> applyCatalyst(List<class_1889> original, class_1799 stack, int slot, int level) {
        int power = this.field_7808[slot];
        if (original.isEmpty()) {
            this.field_7808[slot] = 0;
        }
        this.catalyzed[slot] = 0;
        if (!ConfigEntries.bookCatalysts && EnchantingCatalyst.isEmpty()) {
            return original;
        }
        Map<class_1887, Integer> enchants = EnchantingCatalyst.getEnchantments(this.catalyst.method_5438(0));
        if (enchants.isEmpty()) {
            return original;
        }
        for (int i = 0; i < slot; ++i) {
            this.field_7811.method_43058();
        }
        class_1887 chosen = MathHelper.randi(enchants.keySet().stream().filter(enchant -> enchant.method_8192(stack) || stack.method_31574(class_1802.field_8529)).toList(), this.field_7811);
        if (chosen == null) {
            return original;
        }
        for (int i = 0; i < class_7923.field_41176.method_10206((Object)chosen) % 8; ++i) {
            this.field_7811.method_43058();
        }
        if (this.field_7811.method_43058() > ConfigEntries.catalystChance) {
            return original;
        }
        int lvl = chosen.method_8183();
        for (int i = 0; i < 3 - slot; ++i) {
            lvl = Math.min(lvl, this.field_7811.method_43048(chosen.method_8183()));
        }
        ++lvl;
        if (this.catalyst.method_5438(0).method_7909() instanceof class_1772) {
            lvl = Math.min(lvl, enchants.get(chosen));
        }
        ArrayList<class_1889> result = new ArrayList<class_1889>();
        for (class_1889 entry : original) {
            if (entry.field_9093 == chosen && entry.field_9094 > lvl) {
                lvl = entry.field_9094;
                continue;
            }
            if (!entry.field_9093.method_8188(chosen)) continue;
            result.add(entry);
        }
        result.add(0, new class_1889(chosen, lvl));
        this.catalyzed[slot] = 1;
        this.field_7808[slot] = power;
        return result;
    }

    @WrapMethod(method={"onButtonClick"})
    public boolean useCatalyst(class_1657 player, int id, Operation<Boolean> original) {
        boolean result = (Boolean)original.call(new Object[]{player, id});
        if (!ConfigEntries.bookCatalysts && EnchantingCatalyst.isEmpty()) {
            return result;
        }
        if (result) {
            if (!(this.catalyst.method_5438(0).method_7909() instanceof class_1772)) {
                this.catalyst.method_5438(0).method_7934(1);
            }
            this.catalyzed[0] = 0;
            this.catalyzed[1] = 0;
            this.catalyzed[2] = 0;
        }
        return result;
    }

    @Inject(method={"quickMove"}, at={@At(value="HEAD")}, cancellable=true)
    public void moveCatalyst(class_1657 player, int slotid, CallbackInfoReturnable<class_1799> cir) {
        if (!ConfigEntries.bookCatalysts && EnchantingCatalyst.isEmpty()) {
            return;
        }
        class_1735 slot = this.method_7611(slotid);
        class_1799 stack = this.field_7809.method_5438(0);
        if (slot.field_7871 == this.catalyst && !this.method_7616(slot.method_7677(), 2, 38, true)) {
            slot.method_7667(player, slot.method_7677());
            this.catalyst.method_5431();
            cir.setReturnValue((Object)class_1799.field_8037);
        } else if (EnchantingCatalyst.isCatalyst(slot.method_7677()) && !stack.method_7960() && stack.method_7923() && !this.method_7616(slot.method_7677(), 38, 39, true)) {
            slot.method_7667(player, slot.method_7677());
            cir.setReturnValue((Object)class_1799.field_8037);
        }
    }

    @Inject(method={"onContentChanged"}, at={@At(value="HEAD")})
    public void updateCatalystOverlay(class_1263 inventory, CallbackInfo ci) {
        class_1799 stack = this.field_7809.method_5438(0);
        if (stack.method_7960() || !stack.method_7923()) {
            this.catalyzed[0] = 0;
            this.catalyzed[1] = 0;
            this.catalyzed[2] = 0;
        }
    }
}

