/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.config.ModConfig;
import net.lyof.sortilege.setup.ReloadListener;
import net.lyof.sortilege.setup.datagen.config.ConfiguredData;
import net.lyof.sortilege.setup.datagen.config.ConfiguredDataResourcePack;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6861;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_6861.class})
public class LifecycledResourceManagerImplMixin {
    @Unique
    private static class_3298 readAndApply(Optional<class_3298> resource, ConfiguredData data) {
        Sortilege.log("Applying configured data: " + data.target);
        String result = "";
        if (resource.isEmpty()) {
            result = data.apply(null);
        } else {
            try {
                result = data.apply(new String(resource.get().method_14482().readAllBytes()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String finalResult = result;
        return new class_3298((class_3262)ConfiguredDataResourcePack.INSTANCE, () -> new CharSequenceInputStream((CharSequence)finalResult, Charset.defaultCharset()));
    }

    @Unique
    private static class_3298 readAndApply(class_3298 resource, ConfiguredData data) {
        if (resource.method_45304() instanceof ConfiguredDataResourcePack) {
            return resource;
        }
        return LifecycledResourceManagerImplMixin.readAndApply(Optional.of(resource), data);
    }

    @ModifyReturnValue(method={"getResource"}, at={@At(value="RETURN")})
    public Optional<class_3298> getConfiguredResource(Optional<class_3298> original, class_2960 id) {
        ConfiguredData data = ConfiguredData.get(id);
        if (data == null || !data.enabled.get().booleanValue() || original.isPresent() && original.get().method_45304() instanceof ConfiguredDataResourcePack) {
            return original;
        }
        return Optional.of(LifecycledResourceManagerImplMixin.readAndApply(original, data));
    }

    @ModifyReturnValue(method={"getAllResources"}, at={@At(value="RETURN")})
    public List<class_3298> getAllConfiguredResource(List<class_3298> original, class_2960 id) {
        ConfiguredData data = ConfiguredData.get(id);
        if (data == null || !data.enabled.get().booleanValue()) {
            return original;
        }
        return original.stream().map(resource -> LifecycledResourceManagerImplMixin.readAndApply(resource, data)).toList();
    }

    @ModifyReturnValue(method={"findResources"}, at={@At(value="RETURN")})
    public Map<class_2960, class_3298> findConfiguredResources(Map<class_2960, class_3298> original, String startingPath, Predicate<class_2960> allowedPathPredicate) {
        for (ConfiguredData configuredData : ConfiguredData.INSTANCES) {
            if (!configuredData.enabled.get().booleanValue() || !configuredData.target.method_12832().startsWith(startingPath + "/") || !allowedPathPredicate.test(configuredData.target) || original.containsKey(configuredData.target)) continue;
            original.put(configuredData.target, LifecycledResourceManagerImplMixin.readAndApply(Optional.empty(), configuredData));
        }
        List ids = original.keySet().stream().toList();
        for (class_2960 id2 : ids) {
            ConfiguredData data = ConfiguredData.get(id2);
            if (data == null || !data.enabled.get().booleanValue()) continue;
            original.replace(id2, LifecycledResourceManagerImplMixin.readAndApply(original.get(id2), data));
        }
        if (startingPath.startsWith("recipes")) {
            List<class_2960> list = original.keySet().stream().filter(id -> {
                if (!id.toString().startsWith("sortilege:recipes/compat/")) {
                    return false;
                }
                return ModConfig.STAFFS.stream().anyMatch(p -> id.equals((Object)Sortilege.makeID("recipes/compat/" + (String)p.getFirst() + ".json")) && !FabricLoader.getInstance().isModLoaded(((ModConfig.StaffInfo)p.getSecond()).dependency));
            }).toList();
            for (class_2960 id3 : list) {
                original.remove(id3);
            }
            Sortilege.log("Neutralized recipes " + list + ", as their corresponding staffs are not loaded.");
        }
        return original;
    }

    @ModifyReturnValue(method={"findAllResources"}, at={@At(value="RETURN")})
    public Map<class_2960, List<class_3298>> findAllConfiguredResources(Map<class_2960, List<class_3298>> original, String startingPath, Predicate<class_2960> allowedPathPredicate) {
        for (ConfiguredData data : ConfiguredData.INSTANCES) {
            if (!data.enabled.get().booleanValue() || !data.target.method_12832().startsWith(startingPath) || !allowedPathPredicate.test(data.target) || original.containsKey(data.target)) continue;
            original.put(data.target, List.of(LifecycledResourceManagerImplMixin.readAndApply(Optional.empty(), data)));
        }
        List ids = original.keySet().stream().toList();
        for (class_2960 id : ids) {
            ConfiguredData data = ConfiguredData.get(id);
            if (data == null || !data.enabled.get().booleanValue()) continue;
            original.replace(id, original.get(id).stream().map(resource -> LifecycledResourceManagerImplMixin.readAndApply(resource, data)).toList());
        }
        return original;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void preload(class_3264 type, List<class_3262> packs, CallbackInfo ci) {
        ReloadListener.INSTANCE.preload((class_3300)this);
    }
}

