/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.setup;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.impl.resource.loader.FabricLifecycledResourceManager;
import net.fabricmc.loader.api.FabricLoader;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.config.ModConfig;
import net.lyof.sortilege.item.custom.potion.CustomPotionData;
import net.lyof.sortilege.item.custom.potion.PotionCooldownManager;
import net.lyof.sortilege.recipe.brewing.BetterBrewingRegistry;
import net.lyof.sortilege.recipe.crafting.RecipeLock;
import net.lyof.sortilege.recipe.emi.SpecialSmithingEmiRecipe;
import net.lyof.sortilege.recipe.enchanting.EnchantingCatalyst;
import net.lyof.sortilege.setup.EarlyReloadListener;
import net.lyof.sortilege.util.ItemHelper;
import net.lyof.sortilege.util.PotionHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7654;

public class ReloadListener
implements SimpleSynchronousResourceReloadListener,
EarlyReloadListener {
    public static final ReloadListener INSTANCE = new ReloadListener();

    public class_2960 getFabricId() {
        return Sortilege.makeID("reload_listener");
    }

    public void method_14491(class_3300 manager) {
        for (Map.Entry<String, Object> entry : ConfigEntries.xpRequirements.entrySet()) {
            RecipeLock recipeLock;
            Object object = entry.getValue();
            if (object instanceof Double) {
                Double d = (Double)object;
                recipeLock = new RecipeLock.LevelLock(d.intValue());
            } else {
                recipeLock = new RecipeLock.AdvancementLock(String.valueOf(entry.getValue()));
            }
            RecipeLock.register(entry.getKey(), recipeLock);
        }
        PotionHelper.load();
        for (Map.Entry<String, Object> entry : manager.method_14488("recipes", path -> path.toString().endsWith(".json")).entrySet()) {
            try {
                JsonObject jsono;
                class_3298 resource = (class_3298)entry.getValue();
                String content = new String(resource.method_14482().readAllBytes());
                JsonElement json = (JsonElement)new Gson().fromJson(content, JsonElement.class);
                if (json == null || !json.isJsonObject() || !(jsono = json.getAsJsonObject()).has("type") || !jsono.get("type").getAsString().equals("sortilege:enchanting_catalyst")) continue;
                EnchantingCatalyst.read(jsono);
            }
            catch (Throwable e) {
                Sortilege.log("Could not read data file " + entry.getKey(), 2);
            }
        }
        if (FabricLoader.getInstance().isModLoaded("emi")) {
            SpecialSmithingEmiRecipe.INSTANCES.forEach(SpecialSmithingEmiRecipe::generateInputs);
        }
    }

    @Override
    public void preload(class_3300 manager) {
        FabricLifecycledResourceManager fabricManager;
        ModConfig.register();
        ItemHelper.ENCHLIMIT_CACHE.clear();
        RecipeLock.clear();
        PotionHelper.clear();
        BetterBrewingRegistry.clear();
        CustomPotionData.clear();
        PotionCooldownManager.clear();
        EnchantingCatalyst.clear();
        if (ConfigEntries.potionTextures && manager instanceof FabricLifecycledResourceManager && (fabricManager = (FabricLifecycledResourceManager)manager).fabric_getResourceType() == class_3264.field_14188) {
            CustomPotionData.MODELS.clear();
            for (class_2960 model : class_7654.method_45114((String)"models/item/potions").method_45113(manager).keySet()) {
                CustomPotionData.MODELS.add(class_7654.method_45114((String)"models/item").method_45115(model));
            }
        }
        for (Map.Entry entry : manager.method_14488("potions", path -> path.toString().endsWith(".json")).entrySet()) {
            try {
                class_3298 resource = (class_3298)entry.getValue();
                String content = new String(resource.method_14482().readAllBytes());
                JsonElement json = (JsonElement)new Gson().fromJson(content, JsonElement.class);
                if (json == null || !json.isJsonObject()) continue;
                CustomPotionData.read(json.getAsJsonObject());
            }
            catch (Throwable e) {
                Sortilege.log("Could not read data file " + entry.getKey(), 2);
            }
        }
    }

    public void reloadClient() {
        ItemHelper.ENCHLIMIT_CACHE.clear();
        RecipeLock.clear();
        for (Map.Entry<String, Object> entry : ConfigEntries.xpRequirements.entrySet()) {
            RecipeLock recipeLock;
            Object object = entry.getValue();
            if (object instanceof Double) {
                Double d = (Double)object;
                recipeLock = new RecipeLock.LevelLock(d.intValue());
            } else {
                recipeLock = new RecipeLock.AdvancementLock(String.valueOf(entry.getValue()));
            }
            RecipeLock.register(entry.getKey(), recipeLock);
        }
        EnchantingCatalyst.clear();
        CustomPotionData.clear();
        PotionHelper.clear();
        PotionHelper.load();
        if (FabricLoader.getInstance().isModLoaded("emi")) {
            SpecialSmithingEmiRecipe.INSTANCES.forEach(SpecialSmithingEmiRecipe::generateInputs);
        }
    }
}

