/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.setup.datagen.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.config.ModConfig;
import net.lyof.sortilege.enchant.ModEnchants;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ConfiguredData {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public final class_2960 target;
    public Function<JsonElement, String> provider;
    public final Supplier<Boolean> enabled;
    public static List<ConfiguredData> INSTANCES = new LinkedList<ConfiguredData>();

    public ConfiguredData(class_2960 target, Supplier<Boolean> enabled, Function<JsonElement, String> provider) {
        this.target = target;
        this.provider = provider;
        this.enabled = enabled;
    }

    public String apply(@Nullable String original) {
        return ((JsonElement)gson.fromJson(this.provider.apply((JsonElement)gson.fromJson(original == null ? "" : original, JsonElement.class)), JsonElement.class)).toString();
    }

    @Nullable
    public static ConfiguredData get(class_2960 id) {
        return INSTANCES.stream().filter(data -> data.target.equals((Object)id)).findAny().orElse(null);
    }

    protected static void register(class_2960 target, Supplier<Boolean> enabled, Function<JsonElement, String> provider) {
        INSTANCES.add(new ConfiguredData(target, enabled, provider));
    }

    public static void register() {
        ConfiguredData.register(Sortilege.makeID("tags/items/staffs.json"), () -> true, Common::generateStaffTag);
        ConfiguredData.register(class_2960.method_43902((String)"minecraft", (String)"advancements/adventure/voluntary_exile.json"), () -> ConfigEntries.witchHatEnabled, Common::changeVoluntaryExileParent);
        if (FabricLoader.getInstance().isModLoaded("miningmaster")) {
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/power_pyrite_smithing.json"), () -> ModEnchants.POTENCY != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:potency"));
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/kinetic_opal_smithing.json"), () -> ModEnchants.PUSH != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:push"));
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/ice_sapphire_smithing.json"), () -> ModEnchants.BLIZZARD != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:blizzard"));
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/fire_ruby_smithing.json"), () -> ModEnchants.BRAZIER != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:brazier"));
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/air_malachite_smithing.json"), () -> ModEnchants.STABILITY != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:stability"));
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/spirit_garnet_smithing.json"), () -> ModEnchants.WISDOM != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:wisdom"));
            ConfiguredData.register(class_2960.method_43902((String)"miningmaster", (String)"recipes/smithing/haste_peridot_smithing.json"), () -> ModEnchants.FOCUS != null && ConfigEntries.miningMasterIntegration, json -> Common.changeMiningMasterGem(json, "sortilege:focus"));
        }
    }

    public static void registerClient() {
        for (Pair<String, ModConfig.StaffInfo> staff : ModConfig.STAFFS) {
            ConfiguredData.register(Sortilege.makeID("models/item/" + (String)staff.getFirst() + ".json"), () -> FabricLoader.getInstance().isModLoaded(((ModConfig.StaffInfo)staff.getSecond()).dependency), json -> Client.generateDefaultModel(json, (String)staff.getFirst()));
        }
        ConfiguredData.register(Sortilege.makeID("lang/en_us.json"), () -> true, Client::generateTranslations);
        ConfiguredData.register(class_2960.method_43902((String)"enchdesc", (String)"lang/en_us.json"), () -> FabricLoader.getInstance().isModLoaded("enchdesc"), Client::changeEnchantmentDescriptions);
        ConfiguredData.register(class_2960.method_43902((String)"quark", (String)"attribute_tooltips.json"), () -> FabricLoader.getInstance().isModLoaded("quark"), Client::changeQuarkAttributeDisplay);
    }

    protected static JsonElement getJson(String string) {
        return (JsonElement)gson.fromJson(string, JsonElement.class);
    }

    public static class Client {
        public static String generateDefaultModel(JsonElement json, String path) {
            if (json != null) {
                return json.toString();
            }
            return "{\n  \"parent\": \"item/handheld\",\n  \"textures\": {\n    \"layer0\":\"sortilege:item/" + path + "\"  }\n}";
        }

        public static String generateTranslations(JsonElement json) {
            for (Pair<String, ModConfig.StaffInfo> staff : ModConfig.STAFFS) {
                if (!FabricLoader.getInstance().isModLoaded(((ModConfig.StaffInfo)staff.getSecond()).dependency)) continue;
                String id = (String)staff.getFirst();
                StringBuilder translation = new StringBuilder("" + id.toUpperCase().charAt(0));
                for (int i = 1; i < id.length(); ++i) {
                    if (id.charAt(i - 1) == '_') {
                        translation.append(id.toUpperCase().charAt(i));
                        continue;
                    }
                    if (id.charAt(i) == '_') {
                        translation.append(' ');
                        continue;
                    }
                    translation.append(id.charAt(i));
                }
                json.getAsJsonObject().addProperty("item.sortilege." + id, translation.toString());
            }
            if (ConfigEntries.betterMagicProt) {
                json.getAsJsonObject().asMap().replace("enchantment.sortilege.magic_protection.desc", new JsonPrimitive("Reduces damage from magic, and gives a chance to dodge attacks."));
            }
            return json.toString();
        }

        public static String changeEnchantmentDescriptions(JsonElement json) {
            JsonObject o = (JsonObject)json;
            if (ConfigEntries.betterFireProt > 0) {
                o.asMap().replace("enchantment.minecraft.fire_protection.desc", new JsonPrimitive(o.get("enchantment.minecraft.fire_protection.desc").getAsString() + " Wearing a full set at max level completely negates them."));
            }
            if (ConfigEntries.betterBane) {
                o.asMap().replace("enchantment.minecraft.bane_of_arthropods.desc", new JsonPrimitive(o.get("enchantment.minecraft.bane_of_arthropods.desc").getAsString() + " Also slows down opponents."));
            }
            if (ConfigEntries.betterFeatherFalling > 0) {
                o.asMap().replace("enchantment.minecraft.feather_falling.desc", new JsonPrimitive(o.get("enchantment.minecraft.feather_falling.desc").getAsString() + " They are completely negated at max level."));
            }
            if (ConfigEntries.betterUnbreaking > 0) {
                o.asMap().replace("enchantment.minecraft.unbreaking.desc", new JsonPrimitive(o.get("enchantment.minecraft.unbreaking.desc").getAsString() + " Max level makes the item unbreakable"));
            }
            return o.toString();
        }

        public static String changeQuarkAttributeDisplay(JsonElement json) {
            if (json == null) {
                return "";
            }
            if (!json.isJsonObject()) {
                return "";
            }
            json.getAsJsonObject().add("sortilege:generic.staff_damage", ConfiguredData.getJson("{\n  \"display\": {\n    \"mainhand\": \"flat\",\n    \"offhand\": \"flat\",\n    \"feet\": \"difference\",\n    \"legs\": \"difference\",\n    \"chest\": \"difference\",\n    \"head\": \"difference\",\n    \"potion\": \"difference\"\n  },\n  \"texture\": \"quark:attribute/staff_damage\",\n  \"compare\": \"higher_better\"\n}"));
            json.getAsJsonObject().add("sortilege:generic.staff_range", ConfiguredData.getJson("{\n  \"display\": {\n    \"mainhand\": \"flat\",\n    \"offhand\": \"flat\",\n    \"feet\": \"difference\",\n    \"legs\": \"difference\",\n    \"chest\": \"difference\",\n    \"head\": \"difference\",\n    \"potion\": \"difference\"\n  },\n  \"texture\": \"quark:attribute/staff_range\",\n  \"compare\": \"higher_better\"\n}"));
            json.getAsJsonObject().add("sortilege:generic.staff_pierce", ConfiguredData.getJson("{\n  \"display\": {\n    \"mainhand\": \"flat\",\n    \"offhand\": \"flat\",\n    \"feet\": \"difference\",\n    \"legs\": \"difference\",\n    \"chest\": \"difference\",\n    \"head\": \"difference\",\n    \"potion\": \"difference\"\n  },\n  \"texture\": \"quark:attribute/staff_pierce\",\n  \"compare\": \"higher_better\"\n}"));
            return gson.toJson(json);
        }
    }

    private static class Common {
        private Common() {
        }

        public static String generateStaffTag(JsonElement json) {
            if (json == null) {
                json = new JsonObject();
            }
            json.getAsJsonObject().add("values", (JsonElement)new JsonArray());
            for (Pair<String, ModConfig.StaffInfo> staff : ModConfig.STAFFS) {
                if (!FabricLoader.getInstance().isModLoaded(((ModConfig.StaffInfo)staff.getSecond()).dependency)) continue;
                json.getAsJsonObject().get("values").getAsJsonArray().add(Sortilege.makeID((String)staff.getFirst()).toString());
            }
            return json.toString();
        }

        public static String changeVoluntaryExileParent(JsonElement json) {
            json.getAsJsonObject().asMap().replace("parent", new JsonPrimitive(Sortilege.makeID("get_witch_hat").toString()));
            return json.toString();
        }

        public static String changeMiningMasterGem(JsonElement json, String addedEnchant) {
            if (json == null) {
                return "{}";
            }
            if (!(json.isJsonObject() && json.getAsJsonObject().has("enchantments") && json.getAsJsonObject().get("enchantments").isJsonArray())) {
                return json.toString();
            }
            json.getAsJsonObject().get("enchantments").getAsJsonArray().add(addedEnchant);
            return json.toString();
        }
    }
}

