/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.util;

import java.util.HashMap;
import java.util.Map;
import net.lyof.sortilege.config.ConfigEntries;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    public static final String ENCHLIMIT_NBT = "sortilege_extra_enchants";
    public static final Map<class_1792, Integer> ENCHLIMIT_CACHE = new HashMap<class_1792, Integer>();

    public static int getEnchantLevel(@Nullable class_1887 enchant, class_1799 item) {
        if (enchant == null) {
            return 0;
        }
        return class_1890.method_8225((class_1887)enchant, (class_1799)item);
    }

    public static boolean hasEnchant(class_1887 enchant, class_1799 item) {
        return ItemHelper.getEnchantLevel(enchant, item) > 0;
    }

    public static int getUsedEnchantSlots(class_1799 stack) {
        int l = 0;
        for (class_1887 enchant : class_1890.method_8222((class_1799)stack).keySet()) {
            if (enchant.method_8195() && ConfigEntries.cursesAddSlots) continue;
            ++l;
        }
        return l;
    }

    public static int getTotalEnchantSlots(class_1799 stack) {
        if (ENCHLIMIT_CACHE == null) {
            return 0;
        }
        int l = ItemHelper.getBaseEnchantSlots(stack);
        if (l >= 0) {
            l = l + ItemHelper.getExtraEnchantSlots(stack) + ItemHelper.getCurseEnchantSlots(stack);
        }
        return l;
    }

    public static int getBaseEnchantSlots(class_1799 stack) {
        if (ENCHLIMIT_CACHE.containsKey(stack.method_7909())) {
            return ENCHLIMIT_CACHE.get(stack.method_7909());
        }
        String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        int default_limit = ConfigEntries.enchantLimiterDefault;
        boolean sum = ConfigEntries.enchantLimiterMode.equals("relative");
        if (ConfigEntries.enchantLimiterOverrides.containsKey(id)) {
            int l = ConfigEntries.enchantLimiterOverrides.get(id).intValue();
            l = sum ? l + default_limit : l;
            ENCHLIMIT_CACHE.putIfAbsent(stack.method_7909(), l);
            return l;
        }
        for (String str : ConfigEntries.enchantLimiterOverrides.keySet()) {
            class_6862 tag;
            if (!str.startsWith("#") || !stack.method_31573(tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(str.substring(1))))) continue;
            int l = ConfigEntries.enchantLimiterOverrides.get(str).intValue();
            l = sum ? l + default_limit : l;
            ENCHLIMIT_CACHE.putIfAbsent(stack.method_7909(), l);
            return l;
        }
        ENCHLIMIT_CACHE.putIfAbsent(stack.method_7909(), default_limit);
        return default_limit;
    }

    public static int getCurseEnchantSlots(class_1799 stack) {
        int l = 0;
        for (class_1887 enchant : class_1890.method_8222((class_1799)stack).keySet()) {
            if (!enchant.method_8195() || !ConfigEntries.cursesAddSlots) continue;
            ++l;
        }
        return l;
    }

    public static int getExtraEnchantSlots(class_1799 stack) {
        return stack.method_7985() ? stack.method_7948().method_10550(ENCHLIMIT_NBT) : 0;
    }

    public static class_1799 addExtraEnchantSlot(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        int current = tag.method_10550(ENCHLIMIT_NBT);
        if (current < ConfigEntries.maxLimitBreak) {
            tag.method_10569(ENCHLIMIT_NBT, current + 1);
        }
        stack.method_7980(tag);
        return stack;
    }

    public static class_2561 getShiftTooltip() {
        return class_2561.method_43471((String)"tooltip.press_shift.left").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43471((String)"tooltip.press_shift.center").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)"tooltip.press_shift.right").method_27692(class_124.field_1063));
    }
}

