/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.hitboxforlight.client;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.lx862.hitboxforlight.client.HitboxForMyLightBlockClient;
import com.lx862.hitboxforlight.client.LoaderImpl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_310;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    private static final Path configDirectory = LoaderImpl.getConfigDirectory().resolve("hitboxformylightblock.json");
    private boolean showHitboxInCreative = true;

    public void readOrCreateConfig() {
        try {
            this.read();
        }
        catch (FileNotFoundException e) {
            this.write();
        }
    }

    public void read() throws FileNotFoundException {
        HitboxForMyLightBlockClient.LOGGER.info("Reading Config...");
        JsonElement jsonElement = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new FileReader(configDirectory.toFile())));
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.showHitboxInCreative = class_3518.method_15258((JsonObject)jsonObject, (String)"showHitboxInCreative", (boolean)false);
    }

    public void write() {
        HitboxForMyLightBlockClient.LOGGER.info("Writing Config...");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("showHitboxInCreative", Boolean.valueOf(this.showHitboxInCreative));
        try (FileWriter writer = new FileWriter(configDirectory.toFile());){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (IOException e) {
            HitboxForMyLightBlockClient.LOGGER.error("Failed to write config file!", (Throwable)e);
        }
    }

    public boolean showHitboxInCreative() {
        return this.showHitboxInCreative;
    }

    public void setShowHitboxInCreative(boolean bl) {
        this.showHitboxInCreative = bl;
    }

    public boolean shouldShowHitbox(class_1792 itemHolding) {
        return class_310.method_1551().field_1724.method_68878() && this.showHitboxInCreative;
    }
}

