/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.hitboxforlight.client.gui.widget;

import com.lx862.hitboxforlight.client.gui.GuiHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractScrollViewWidget
extends class_339 {
    public static final int SCROLLBAR_WIDTH = 6;
    protected double currentScroll = 0.0;
    private boolean scrollbarDragging = false;

    public AbstractScrollViewWidget(int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrollbarDragging = button == 0 && this.isOverScrollbar(mouseX, mouseY);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrollbarDragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.field_22764 && this.method_25370() && this.scrollbarDragging) {
            double remainingHeight = this.getContentHeight() - this.method_25364();
            int s1 = this.method_25364() * this.method_25364() / this.getContentHeight();
            double scrollScale = remainingHeight / ((double)this.method_25364() - (double)s1);
            this.setScroll(this.currentScroll + deltaY * scrollScale);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        double oldScroll = this.currentScroll;
        this.setScroll(this.currentScroll - (scrollY *= 15.0));
        return oldScroll != this.currentScroll;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean bl2;
        boolean bl = keyCode == 265;
        boolean bl3 = bl2 = keyCode == 264;
        if (bl || bl2) {
            double oldScroll = this.currentScroll;
            if (bl) {
                this.setScroll(this.currentScroll - 15.0);
            } else {
                this.setScroll(this.currentScroll + 15.0);
            }
            if (oldScroll != this.currentScroll) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean contentOverflowed() {
        return this.getContentHeight() > this.method_25364();
    }

    protected int getScrollbarOffset() {
        return this.contentOverflowed() ? 6 : 0;
    }

    public void setScroll(double scroll) {
        this.currentScroll = scroll < 0.0 || !this.contentOverflowed() ? 0.0 : (scroll > (double)(this.getContentHeight() - this.method_25364()) ? (double)(this.getContentHeight() - this.method_25364()) : scroll);
    }

    private void renderScrollbar(class_332 guiGraphics, boolean isMouseOverScrollbar) {
        if (!this.contentOverflowed()) {
            return;
        }
        int fullHeight = this.getContentHeight();
        int visibleHeight = this.method_25364();
        double scrollbarHeight = (double)visibleHeight * ((double)visibleHeight / (double)fullHeight);
        double bottomOffset = this.currentScroll / (double)(fullHeight - visibleHeight);
        double yOffset = bottomOffset * ((double)visibleHeight - scrollbarHeight);
        GuiHelper.drawRectangle(guiGraphics, this.method_46426() + this.method_25368() - 6, (double)this.method_46427() + yOffset, 6.0, scrollbarHeight, isMouseOverScrollbar ? GuiHelper.ARGB_WHITE : -4144960);
        GuiHelper.drawRectangle(guiGraphics, this.method_46426() + this.method_25368() - 1, (double)this.method_46427() + yOffset, 1.0, scrollbarHeight, -8355712);
        GuiHelper.drawRectangle(guiGraphics, this.method_46426() + this.method_25368() - 6, (double)this.method_46427() + yOffset + scrollbarHeight - 1.0, 6.0, 1.0, -8355712);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364());
        this.renderScrollbar(guiGraphics, this.isOverScrollbar(mouseX, mouseY));
        guiGraphics.method_44380();
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + (this.method_25368() - this.getScrollbarOffset()), this.method_46427() + this.method_25364());
        this.renderContent(guiGraphics, mouseX, mouseY, tickDelta);
        guiGraphics.method_44380();
    }

    private boolean isOverScrollbar(double mouseX, double mouseY) {
        int scrollbarEndX = this.method_46426() + this.method_25368();
        int scrollbarStartX = scrollbarEndX - this.getScrollbarOffset();
        return mouseX >= (double)scrollbarStartX && mouseX <= (double)scrollbarEndX && mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.method_25364());
    }

    public abstract void renderContent(class_332 var1, int var2, int var3, float var4);

    protected abstract int getContentHeight();
}

