/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.hitboxforlight.client.gui.widget;

import com.lx862.hitboxforlight.client.gui.GuiHelper;
import com.lx862.hitboxforlight.client.gui.widget.AbstractListItem;
import com.lx862.hitboxforlight.client.gui.widget.AbstractScrollViewWidget;
import com.lx862.hitboxforlight.client.gui.widget.CategoryItem;
import com.lx862.hitboxforlight.client.gui.widget.ContentItem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class ListViewWidget
extends AbstractScrollViewWidget {
    public static final int ENTRY_PADDING = 5;
    private final List<AbstractListItem> displayedEntryList = new ArrayList<AbstractListItem>();
    private final List<AbstractListItem> entryList = new ArrayList<AbstractListItem>();
    private float elapsed;
    private String searchTerm = "";

    public ListViewWidget() {
        super(0, 0, 0, 0);
    }

    public void setXYSize(int x, int y, int width, int height) {
        this.method_46421(x);
        this.method_46419(y);
        this.method_25358(width);
        this.method_53533(height);
        this.setScroll(this.currentScroll);
        this.positionWidgets(this.currentScroll);
        this.refreshDisplayedList();
    }

    public void add(class_5250 text, class_339 widget) {
        this.add(new ContentItem(text, widget));
    }

    public void add(AbstractListItem listItem) {
        this.entryList.add(listItem);
        this.refreshDisplayedList();
    }

    public void addCategory(class_5250 text) {
        this.entryList.add(new CategoryItem(text));
        this.refreshDisplayedList();
    }

    public void reset() {
        this.entryList.clear();
        this.refreshDisplayedList();
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        this.refreshDisplayedList();
    }

    private void refreshDisplayedList() {
        this.displayedEntryList.clear();
        this.entryList.forEach(e -> {
            if (e.matchQuery(this.searchTerm)) {
                e.shown();
                this.displayedEntryList.add((AbstractListItem)e);
            } else {
                e.hidden();
            }
        });
        this.positionWidgets();
        this.setScroll(this.currentScroll);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        GuiHelper.drawRectangle(guiGraphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, 0x4F4C4C4C);
        guiGraphics.method_49601(this.method_46426() - 1, this.method_46427() - 1, this.method_25368() + 2, this.method_25364() + 2, 0x66FFFFFF);
        super.method_48579(guiGraphics, mouseX, mouseY, tickDelta);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void method_25354(class_1144 handler) {
    }

    @Override
    public void renderContent(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.elapsed += class_310.method_1551().method_61966().method_60636() / 20.0f;
        int incY = 0;
        for (AbstractListItem abstractListItem : this.displayedEntryList) {
            int entryX = this.method_46426();
            int entryY = this.method_46427() + incY - (int)this.currentScroll;
            boolean widgetVisible = false;
            if (abstractListItem instanceof ContentItem) {
                ContentItem contentItem = (ContentItem)abstractListItem;
                boolean topLeftVisible = GuiHelper.inRectangle(contentItem.widget.method_46426(), contentItem.widget.method_46427(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
                boolean bottomRightVisible = GuiHelper.inRectangle(contentItem.widget.method_46426() + contentItem.widget.method_25368(), contentItem.widget.method_46427() + contentItem.widget.method_25364(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
                widgetVisible = topLeftVisible || bottomRightVisible;
            }
            abstractListItem.draw(guiGraphics, entryX, entryY, this.field_22758 - this.getScrollbarOffset(), this.field_22759, mouseX, mouseY, widgetVisible, this.elapsed, tickDelta);
            incY += abstractListItem.height;
        }
    }

    @Override
    public void setScroll(double newScroll) {
        super.setScroll(newScroll);
        this.positionWidgets();
    }

    @Override
    protected int getContentHeight() {
        int entryHeight = 0;
        for (AbstractListItem entry : this.displayedEntryList) {
            entryHeight += entry.height;
        }
        return entryHeight;
    }

    public void positionWidgets() {
        this.positionWidgets(this.currentScroll);
    }

    private void positionWidgets(double scroll) {
        int startX = this.method_46426();
        int startY = this.method_46427();
        int incY = 0;
        for (AbstractListItem listItem : this.displayedEntryList) {
            int entryY = startY + incY;
            int x = startX + this.field_22758 - this.getScrollbarOffset() - 5;
            listItem.positionChanged(x, (int)(-scroll) + entryY);
            incY += listItem.height;
        }
    }
}

