/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.SplitWorld;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import tech.snaco.SplitWorld.SplitWorld;
import tech.snaco.SplitWorld.types.Config;
import tech.snaco.SplitWorld.types.DimensionConfig;
import tech.snaco.utils.string.string;

public class ConfigLoader {
    private final Logger LOGGER = SplitWorld.LOGGER;
    private final Path file = Path.of("config/splitworld.yaml", new String[0]);
    private final File yaml = new File("config/splitworld.yaml");
    private final YAMLMapper mapper = (YAMLMapper)((YAMLMapper.Builder)YAMLMapper.builder().disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.WRITE_DOC_START_MARKER}).build();

    public Config load() {
        Config config;
        try {
            config = (Config)this.mapper.readValue(Files.readString(this.file), Config.class);
            this.LOGGER.info(string.info("Loaded config.", new Object[0]));
        }
        catch (JsonSyntaxException | IOException e) {
            config = this.createConfig();
        }
        return config;
    }

    private Config createConfig() {
        try {
            try {
                Files.createDirectory(Path.of("config", new String[0]), new FileAttribute[0]);
            }
            catch (Exception ex1) {
                this.LOGGER.debug(string.debug("config folder exists, skipping creation.", new Object[0]));
            }
            Config config = new Config();
            config.dimensionConfigs.add(new DimensionConfig("minecraft:overworld", true, null, "X", 0, "negative", 10, true));
            this.mapper.writeValue(this.yaml, (Object)config);
            this.LOGGER.info(string.info("Created new config.", new Object[0]));
        }
        catch (Exception ex) {
            this.LOGGER.error(string.error("Error writing config file!", new Object[0]), (Throwable)ex);
        }
        return new Config();
    }
}

