/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.SplitWorld;

import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1269;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.snaco.SplitWorld.ConfigLoader;
import tech.snaco.SplitWorld.callbacks.PlayerCallback;
import tech.snaco.SplitWorld.types.Config;
import tech.snaco.SplitWorld.types.DimensionConfig;
import tech.snaco.utils.IO;
import tech.snaco.utils.exceptions.SplitWorldConfigException;
import tech.snaco.utils.mc;
import tech.snaco.utils.string.string;

public class SplitWorld
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"splitworld");
    public Config config;

    public void onInitialize() {
        IO.verifyDir("splitworld");
        this.config = new ConfigLoader().load();
        PlayerCallback.PLAYER_TICK.register(IO::verifyPlayerInventoryDir);
        PlayerCallback.PLAYER_TICK.register(IO::verifyPlayerEnderChestDir);
        PlayerCallback.PLAYER_TICK.register(this::trackPlayerPosition);
        PlayerCallback.BEFORE_DEATH.register(this::nukeInventoryIfSurvival);
        PlayerCallback.WORLD_CHANGE.register(this::worldChange);
    }

    private class_1269 worldChange(class_3222 player) {
        ArrayList<String> validGameModes = new ArrayList<String>();
        validGameModes.add("survival");
        validGameModes.add("creative");
        validGameModes.add("adventure");
        validGameModes.add("spectator");
        String dimension = this.getPlayerCurrentDimension(player);
        Optional<DimensionConfig> cfg = this.config.dimensionConfigs.stream().filter(dc -> dc.dimensionName.equals(dimension)).findFirst();
        if (cfg.isPresent()) {
            DimensionConfig config = cfg.get();
            if (config.gameModeOverride != null) {
                if (validGameModes.contains(config.gameModeOverride)) {
                    this.changeGameMode(player, mc.getPlayerGameMode(player), mc.getGameModeFromString(config.gameModeOverride));
                } else {
                    LOGGER.error(string.error("Dimension %s has an invalid game mode override of %s. Please set it to 'survival', 'creative', 'adventure' or 'spectator'", new Object[0]), (Object)config.dimensionName, (Object)config.gameModeOverride);
                }
            } else {
                return this.trackPlayerPosition(player);
            }
        }
        return class_1269.field_5811;
    }

    private class_1269 trackPlayerPosition(class_3222 player) {
        String dimension = this.getPlayerCurrentDimension(player);
        Optional<DimensionConfig> cfg = this.config.dimensionConfigs.stream().filter(dc -> dc.dimensionName.equals(dimension)).findFirst();
        if (cfg.isPresent()) {
            DimensionConfig config = cfg.get();
            if (!config.enabled) {
                return class_1269.field_5811;
            }
            double playerPosition = this.getRelevantPlayerPosition(player, config);
            if (config.borderWidth < 0) {
                LOGGER.error(string.error("Error in split world config file!", new Object[0]), (Throwable)new SplitWorldConfigException("Split World border width cannot be a negative value!"));
                return class_1269.field_5814;
            }
            if (config.borderWidth == 0) {
                this.setGameMode(player, playerPosition > (double)config.borderLocation.intValue(), true, config);
            } else {
                int positiveBorder = config.borderLocation + config.borderWidth / 2;
                int negativeBorder = config.borderLocation - config.borderWidth / 2;
                if (playerPosition > (double)positiveBorder) {
                    this.setGameMode(player, true, false, config);
                } else if (playerPosition <= (double)positiveBorder && playerPosition >= (double)negativeBorder) {
                    this.bufferZone(player);
                    if (config.replaceBorderBlocks) {
                        this.convertBorderBlocksAtFeet(player, config);
                        this.keepPlayerAboveGround(player);
                    }
                } else if (playerPosition < (double)negativeBorder) {
                    this.setGameMode(player, false, false, config);
                } else {
                    LOGGER.info(string.info("Cannot make heads or tails of player position. Ignoring.", new Object[0]));
                }
            }
        }
        return class_1269.field_5811;
    }

    private class_1269 nukeInventoryIfSurvival(class_3222 player) {
        if (mc.getPlayerGameMode(player) == class_1934.field_9215 && !player.field_13995.method_3767().method_8355(class_1928.field_19389)) {
            IO.nukeSavedSurvivalInventory(player);
        }
        return class_1269.field_5811;
    }

    private void bufferZone(class_3222 player) {
        class_1934 gameMode = mc.getPlayerGameMode(player);
        if (gameMode == class_1934.field_9220 || gameMode == class_1934.field_9215) {
            IO.nukeSavedInventory(player, gameMode);
            IO.nukeSavedEnderChest(player, gameMode);
            IO.saveEnderChest(player, gameMode);
            IO.saveInventory(player, gameMode);
            player.method_31548().method_5448();
            mc.setPlayerGameMode(player, class_1934.field_9219);
            player.field_6002.method_8396(null, new class_2338(player.method_19538()), class_3417.field_18309, class_3419.field_15245, 0.25f, 1.0f);
            LOGGER.info(string.info("%s is now adventuring.", mc.playerName(player)));
        }
        player.method_31548().method_5448();
        player.method_7274().method_5448();
    }

    private void setGameMode(class_3222 player, boolean onPositiveSide, boolean preNukeInventory, DimensionConfig config) {
        class_1934 playerGameMode = mc.getPlayerGameMode(player);
        if (this.shouldSetCreative(onPositiveSide, config) && playerGameMode != class_1934.field_9220) {
            if (preNukeInventory) {
                IO.nukeSavedInventory(player, class_1934.field_9215);
                IO.nukeSavedEnderChest(player, class_1934.field_9215);
                IO.saveInventory(player, class_1934.field_9215);
                IO.saveEnderChest(player, class_1934.field_9215);
            }
            mc.setPlayerGameMode(player, class_1934.field_9220);
            IO.loadInventory(player, class_1934.field_9220);
            IO.loadEnderChest(player, class_1934.field_9220);
            player.field_6002.method_8396(null, new class_2338(player.method_19538()), class_3417.field_18309, class_3419.field_15245, 0.25f, 1.0f);
            LOGGER.info(string.info("%s is now creative.", mc.playerName(player)));
        } else if (this.shouldSetSurvival(onPositiveSide, config) && playerGameMode != class_1934.field_9215) {
            if (preNukeInventory) {
                IO.nukeSavedInventory(player, class_1934.field_9220);
                IO.nukeSavedEnderChest(player, class_1934.field_9220);
                IO.saveInventory(player, class_1934.field_9220);
                IO.saveEnderChest(player, class_1934.field_9220);
            }
            mc.setPlayerGameMode(player, class_1934.field_9215);
            IO.loadInventory(player, class_1934.field_9215);
            IO.loadEnderChest(player, class_1934.field_9215);
            player.field_6002.method_8396(null, new class_2338(player.method_19538()), class_3417.field_18309, class_3419.field_15245, 0.25f, 1.0f);
            if (config.creativeSide.equals("negative")) {
                player.method_20620(player.method_23317(), (double)(this.findGroundLevel(player) + 1), player.method_23321());
            }
            LOGGER.info(string.info("%s is now surviving.", mc.playerName(player)));
        }
    }

    private boolean shouldSetSurvival(boolean onPositiveSide, DimensionConfig config) {
        return !this.shouldSetCreative(onPositiveSide, config);
    }

    private boolean shouldSetCreative(boolean onPositiveSide, DimensionConfig config) {
        if (onPositiveSide && config.creativeSide.equals("positive")) {
            return true;
        }
        return !onPositiveSide && config.creativeSide.equals("negative");
    }

    private double getRelevantPlayerPosition(class_3222 player, DimensionConfig config) {
        config.borderAxis = config.borderAxis.toUpperCase();
        if (config.borderAxis.equals("Y")) {
            return player.method_19538().field_1351;
        }
        if (config.borderAxis.equals("Z")) {
            return player.method_19538().field_1350;
        }
        return player.method_19538().field_1352;
    }

    private String getPlayerCurrentDimension(class_3222 player) {
        return player.method_5770().method_27983().method_29177().toString();
    }

    private double getRelevantBlockPos(class_2338 blockPos, DimensionConfig config) {
        config.borderAxis = config.borderAxis.toUpperCase();
        if (config.borderAxis.equals("Z")) {
            return blockPos.method_10260();
        }
        return blockPos.method_10263();
    }

    private void convertBorderBlocksAtFeet(class_3222 player, DimensionConfig config) {
        for (int k = -400; k < 5; ++k) {
            for (int i = -5; i < 5; ++i) {
                for (int j = -config.borderWidth.intValue() - 1; j < config.borderWidth; ++j) {
                    class_2680 blockAtFeet;
                    class_2338 feet = new class_2338(new class_2382((double)player.method_24515().method_10263(), (double)(player.method_24515().method_10264() - 1), player.method_19538().method_10215()));
                    if (config.borderAxis.equals("X")) {
                        feet = feet.method_10069(j, k, i);
                    }
                    if (config.borderAxis.equals("Z")) {
                        feet = feet.method_10069(i, k, j);
                    }
                    if ((blockAtFeet = player.field_6002.method_8320(feet)) == class_2246.field_10124.method_9564() || blockAtFeet == class_2246.field_9987.method_9564() || blockAtFeet == class_2246.field_10027.method_9564() || blockAtFeet == class_2246.field_10398.method_9564() || !(this.getRelevantBlockPos(feet, config) >= (double)config.borderLocation.intValue() - (double)config.borderWidth.intValue() / 2.0) || !(this.getRelevantBlockPos(feet, config) < (double)config.borderLocation.intValue() + (double)config.borderWidth.intValue() / 2.0)) continue;
                    class_2338 head = new class_2338(new class_2382(player.method_23317(), player.method_23318() + 1.0, player.method_23321()));
                    class_2338 body = new class_2338(new class_2382(player.method_23317(), player.method_23318(), player.method_23321()));
                    player.field_6002.method_8501(feet, class_2246.field_9987.method_9564());
                }
            }
        }
    }

    private void keepPlayerAboveGround(class_3222 player) {
        int ground = this.findGroundLevel(player);
        if (player.method_23318() < (double)ground) {
            player.method_20620(player.method_23317(), (double)(ground + 1), player.method_23321());
        }
    }

    private int findGroundLevel(class_3222 player) {
        for (int y = 319; y > -64; --y) {
            class_2680 block = player.field_6002.method_8320(new class_2338(new class_2382((double)player.method_24515().method_10263(), (double)y, player.method_19538().method_10215())));
            if (block == class_2246.field_10124.method_9564() || block == class_2246.field_10243.method_9564()) continue;
            return y;
        }
        return 0;
    }

    private void changeGameMode(class_3222 player, class_1934 currentGameMode, class_1934 newGameMode) {
        IO.nukeSavedInventory(player, currentGameMode);
        IO.nukeSavedEnderChest(player, currentGameMode);
        IO.saveInventory(player, currentGameMode);
        IO.saveEnderChest(player, currentGameMode);
        IO.loadInventory(player, newGameMode);
        IO.loadEnderChest(player, currentGameMode);
        mc.setPlayerGameMode(player, newGameMode);
    }
}

