/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import tech.snaco.SplitWorld.SplitWorld;
import tech.snaco.utils.string.string;

public class IO {
    public static String getInventoryDir(class_3222 player) {
        return string.f("splitworld/%s_inv", player.method_5845());
    }

    public static String getEnderChestDir(class_3222 player) {
        return string.f("splitworld/%s_enderchest", player.method_5845());
    }

    public static class_1269 nukeSavedEnderChest(class_3222 player) {
        if (IO.nukeSavedEnderChest(player, class_1934.field_9215)) {
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }

    public static class_1269 nukeSavedSurvivalInventory(class_3222 player) {
        if (IO.nukeSavedInventory(player, class_1934.field_9215)) {
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }

    public static boolean nukeSavedEnderChest(class_3222 player, class_1934 gameMode) {
        File dir = new File(IO.getEnderChestDir(player));
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            if (!file.getName().contains(gameMode.toString())) continue;
            file.delete();
        }
        return true;
    }

    public static boolean nukeSavedInventory(class_3222 player, class_1934 gameMode) {
        File dir = new File(IO.getInventoryDir(player));
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            if (!file.getName().contains(gameMode.toString())) continue;
            file.delete();
        }
        return true;
    }

    public static class_1269 verifyPlayerInventoryDir(class_3222 player) {
        String dirName = IO.getInventoryDir(player);
        if (!IO.verifyDir(dirName)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 verifyPlayerEnderChestDir(class_3222 player) {
        String dirName = IO.getEnderChestDir(player);
        if (!IO.verifyDir(dirName)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void loadInventory(class_3222 player, class_1934 gameMode) {
        try {
            class_2499 nbtList = new class_2499();
            File dir = new File(IO.getInventoryDir(player));
            File[] files = dir.listFiles();
            if (files == null) {
                player.method_31548().method_5448();
            } else {
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    class_2487 nbt;
                    if (!file.getName().contains(gameMode.toString()) || (nbt = class_2507.method_10633((File)file)) == null) continue;
                    nbtList.add((Object)nbt);
                }
            }
            player.method_31548().method_5448();
            player.method_31548().method_7397(nbtList);
        }
        catch (IOException ex) {
            player.method_31548().method_7388();
            SplitWorld.LOGGER.error(string.error("Error reading inventory file!", new Object[0]), (Throwable)ex);
        }
    }

    public static void loadEnderChest(class_3222 player, class_1934 gameMode) {
        try {
            class_2499 nbtList = new class_2499();
            File dir = new File(IO.getEnderChestDir(player));
            File[] files = dir.listFiles();
            if (files == null) {
                player.method_7274().method_5448();
            } else {
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    class_2487 nbt;
                    if (!file.getName().contains(gameMode.toString()) || (nbt = class_2507.method_10633((File)file)) == null) continue;
                    nbtList.add((Object)nbt);
                }
            }
            player.method_7274().method_5448();
            player.method_7274().method_7659(nbtList);
        }
        catch (IOException ex) {
            player.method_7274().method_5448();
            SplitWorld.LOGGER.error(string.error("Error reading ender chest file!", new Object[0]), (Throwable)ex);
        }
    }

    public static void saveInventory(class_3222 player, class_1934 gameMode) {
        try {
            String dir = IO.getInventoryDir(player);
            class_2499 nbtList = new class_2499();
            nbtList = player.method_31548().method_7384(nbtList);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2520 nbt = nbtList.method_10534(i);
                File file = new File(string.f("%s/%s_%d.nbt", dir, gameMode.toString(), i));
                class_2507.method_10630((class_2487)((class_2487)nbt), (File)file);
            }
        }
        catch (Exception ex) {
            SplitWorld.LOGGER.error(string.error("Error saving inventory file for %s!", player.method_5477().getString()));
        }
    }

    public static void saveEnderChest(class_3222 player, class_1934 gameMode) {
        try {
            class_2499 nbtList = player.method_7274().method_7660();
            String dir = IO.getEnderChestDir(player);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2520 nbt = nbtList.method_10534(i);
                File file = new File(string.f("%s/%s_%d.nbt", dir, gameMode.toString(), i));
                class_2507.method_10630((class_2487)((class_2487)nbt), (File)file);
            }
        }
        catch (IOException e) {
            SplitWorld.LOGGER.error(string.error("Error saving ender chest file for %s!", player.method_5477().getString()));
        }
    }

    public static boolean verifyDir(String dirName) {
        Path dir = Paths.get(dirName, new String[0]);
        try {
            Path dirPath = Files.createDirectory(dir, new FileAttribute[0]);
            if (Files.notExists(dirPath, new LinkOption[0]) && !Files.exists(dirPath, new LinkOption[0])) {
                new File(dirName).mkdir();
                SplitWorld.LOGGER.info(string.info("Created directory: %s", dirName));
                return true;
            }
        }
        catch (FileAlreadyExistsException ex) {
            SplitWorld.LOGGER.debug(string.debug("Verified directory: %s", dirName));
            return true;
        }
        catch (IOException ex) {
            SplitWorld.LOGGER.error(string.error("Error verifying directory: %s", dirName), (Throwable)ex);
            return false;
        }
        return true;
    }
}

