/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/snaco/split_world/BufferZoneVisualizer;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "(Lorg/bukkit/plugin/Plugin;)V", "offsetCycle", "", "offsets", "", "", "renderBufferEdge", "", "player", "Lorg/bukkit/entity/Player;", "position", "axis", "", "offset", "SplitWorld-plugin"})
public final class BufferZoneVisualizer
implements Listener {
    private int offsetCycle;
    @NotNull
    private final List<Double> offsets;

    public BufferZoneVisualizer(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Double[] doubleArray = new Double[]{0.0, 0.25, -0.25, 0.5, -0.5, 0.75, -0.75};
        this.offsets = CollectionsKt.listOf(doubleArray);
        new BukkitRunnable(){

            public void run() {
                if (!ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().borderParticles()) {
                    return;
                }
                double currentOffset = ((Number)offsets.get(offsetCycle)).doubleValue();
                offsetCycle = (offsetCycle + 1) % offsets.size();
                for (World world : Bukkit.getWorlds()) {
                    Intrinsics.checkNotNullExpressionValue(world, "world");
                    if (!WorldUtilsKt.isSplit(world)) continue;
                    double borderLocation = WorldUtilsKt.splitConfig(world).borderLocation();
                    double borderWidth = WorldUtilsKt.splitConfig(world).borderWidth();
                    Intrinsics.checkNotNullExpressionValue(WorldUtilsKt.splitConfig(world).borderAxis().toUpperCase(Locale.ROOT), "this as java.lang.String).toUpperCase(Locale.ROOT)");
                    for (Player player : world.getPlayers()) {
                        double d;
                        double distanceToBuffer;
                        double d2;
                        Location playerLoc;
                        String axis;
                        Intrinsics.checkNotNullExpressionValue(player.getLocation(), "player.location");
                        String string = axis;
                        if (Intrinsics.areEqual(string, "X")) {
                            d2 = Math.abs(playerLoc.getX() - borderLocation);
                        } else {
                            if (!Intrinsics.areEqual(string, "Z")) continue;
                            d2 = Math.abs(playerLoc.getZ() - borderLocation);
                        }
                        if ((distanceToBuffer = d2) > (double)30 + borderWidth) continue;
                        if (LocationUtilsKt.inBufferZone(playerLoc)) {
                            Intrinsics.checkNotNullExpressionValue(player, "player");
                            this.renderBufferEdge(player, borderLocation - borderWidth, axis, currentOffset);
                            this.renderBufferEdge(player, borderLocation + borderWidth, axis, currentOffset);
                            continue;
                        }
                        String string2 = axis;
                        if (Intrinsics.areEqual(string2, "X")) {
                            d = playerLoc.getX();
                        } else {
                            if (!Intrinsics.areEqual(string2, "Z")) continue;
                            d = playerLoc.getZ();
                        }
                        double playerPosition = d;
                        if (playerPosition < borderLocation - borderWidth) {
                            Intrinsics.checkNotNullExpressionValue(player, "player");
                            this.renderBufferEdge(player, borderLocation - borderWidth, axis, currentOffset);
                            continue;
                        }
                        if (!(playerPosition > borderLocation + borderWidth)) continue;
                        Intrinsics.checkNotNullExpressionValue(player, "player");
                        this.renderBufferEdge(player, borderLocation + borderWidth, axis, currentOffset);
                    }
                }
            }
        }.runTaskTimer(plugin, 0L, 10L);
    }

    private final void renderBufferEdge(Player player, double position, String axis, double offset) {
        block5: {
            String string;
            double centerHeight;
            Location playerLoc;
            double particleRadius;
            block4: {
                particleRadius = 15.0;
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "player.location");
                playerLoc = location;
                centerHeight = player.getEyeLocation().getY();
                string = axis;
                if (!Intrinsics.areEqual(string, "X")) break block4;
                for (double y = centerHeight - particleRadius + offset; y <= centerHeight + particleRadius; y += 1.0) {
                    for (double z = playerLoc.getZ() - particleRadius + offset; z <= playerLoc.getZ() + particleRadius; z += 1.0) {
                        Location loc = new Location(player.getWorld(), position, y, z);
                        if (!(loc.distance(playerLoc) <= 32.0)) continue;
                        player.spawnParticle(Particle.PORTAL, loc, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                break block5;
            }
            if (!Intrinsics.areEqual(string, "Z")) break block5;
            for (double y = centerHeight - particleRadius + offset; y <= centerHeight + particleRadius; y += 1.0) {
                for (double x = playerLoc.getX() - particleRadius + offset; x <= playerLoc.getX() + particleRadius; x += 1.0) {
                    Location loc = new Location(player.getWorld(), x, y, position);
                    if (!(loc.distance(playerLoc) <= 32.0)) continue;
                    player.spawnParticle(Particle.PORTAL, loc, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

