/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.SplitWorldPlugin;
import tech.snaco.split_world.config.SplitWorldConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Ltech/snaco/split_world/config/SplitServerConfig;", "", "plugin", "Ltech/snaco/split_world/SplitWorldPlugin;", "(Ltech/snaco/split_world/SplitWorldPlugin;)V", "getPlugin", "()Ltech/snaco/split_world/SplitWorldPlugin;", "borderBlocks", "", "borderParticles", "creativeCommands", "", "", "customRespawn", "defaultGameMode", "Lorg/bukkit/GameMode;", "disableAdvancementsInCreative", "disableWelcomeMessage", "easterEggsEnabled", "manageCreativeCommands", "respawnLocation", "Lorg/bukkit/Location;", "worldConfigs", "", "Lorg/bukkit/World;", "Ltech/snaco/split_world/config/SplitWorldConfig;", "xpLossPercentage", "", "xpModEnabled", "SplitWorld-plugin"})
@SourceDebugExtension(value={"SMAP\nSplitServerConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitServerConfig.kt\ntech/snaco/split_world/config/SplitServerConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1#2:72\n1#2:83\n1#2:100\n1603#3,9:73\n1855#3:82\n1856#3:84\n1612#3:85\n1549#3:86\n1620#3,3:87\n1603#3,9:90\n1855#3:99\n1856#3:101\n1612#3:102\n*S KotlinDebug\n*F\n+ 1 SplitServerConfig.kt\ntech/snaco/split_world/config/SplitServerConfig\n*L\n51#1:83\n53#1:100\n51#1:73,9\n51#1:82\n51#1:84\n51#1:85\n52#1:86\n52#1:87,3\n53#1:90,9\n53#1:99\n53#1:101\n53#1:102\n*E\n"})
public final class SplitServerConfig {
    @NotNull
    private final SplitWorldPlugin plugin;

    public SplitServerConfig(@NotNull SplitWorldPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.plugin.saveDefaultConfig();
        if (Bukkit.getWorld((String)"split_world") == null) {
            Bukkit.createWorld((WorldCreator)new WorldCreator("split_world"));
        }
        if (Bukkit.getWorld((String)"creative_world") == null) {
            Bukkit.createWorld((WorldCreator)new WorldCreator("creative_world"));
        }
    }

    @NotNull
    public final SplitWorldPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final GameMode defaultGameMode() {
        GameMode gameMode;
        String string = this.plugin.getConfig().getString("default_game_mode");
        if (string != null) {
            GameMode gameMode2;
            String it = string;
            boolean bl = false;
            try {
                gameMode2 = GameMode.valueOf((String)it);
            }
            catch (IllegalArgumentException _) {
                gameMode2 = GameMode.SURVIVAL;
            }
            GameMode gameMode3 = gameMode2;
            if (gameMode3 != null) {
                gameMode = gameMode3;
                return gameMode;
            }
        }
        gameMode = GameMode.SURVIVAL;
        return gameMode;
    }

    public final boolean disableWelcomeMessage() {
        return this.plugin.getConfig().getBoolean("disable_welcome_message", false);
    }

    public final boolean xpModEnabled() {
        return this.plugin.getConfig().getBoolean("enable_xp_mod", false);
    }

    public final double xpLossPercentage() {
        return this.plugin.getConfig().getDouble("xp_loss_percentage", 25.0);
    }

    public final boolean manageCreativeCommands() {
        return this.plugin.getConfig().getBoolean("manage_creative_commands", true);
    }

    @NotNull
    public final List<String> creativeCommands() {
        List<String> list;
        List<String> list2 = this.plugin.getConfig().getStringList("creative_commands");
        if (list2.isEmpty()) {
            boolean bl = false;
            String[] stringArray = new String[]{"fill", "setblock", "clone"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = list2;
        }
        return list;
    }

    public final boolean disableAdvancementsInCreative() {
        return this.plugin.getConfig().getBoolean("disable_advancements_in_creative", true);
    }

    public final boolean easterEggsEnabled() {
        return this.plugin.getConfig().getBoolean("enable_easter_eggs", false);
    }

    public final boolean customRespawn() {
        return this.plugin.getConfig().getBoolean("custom_respawn", false);
    }

    public final boolean borderParticles() {
        return this.plugin.getConfig().getBoolean("border_particles", true);
    }

    public final boolean borderBlocks() {
        return this.plugin.getConfig().getBoolean("border_blocks", true);
    }

    @NotNull
    public final Location respawnLocation() {
        ConfigurationSection configurationSection = this.plugin.getConfig().getConfigurationSection("respawn_location");
        if (configurationSection == null) {
            throw new IllegalStateException("Missing respawn_location section of split world config".toString());
        }
        ConfigurationSection locationCfg = configurationSection;
        if (!locationCfg.contains("x")) {
            throw new IllegalStateException("Missing x coordinate in respawn_location section of split world config".toString());
        }
        if (!locationCfg.contains("y")) {
            throw new IllegalStateException("Missing y coordinate in respawn_location section of split world config".toString());
        }
        if (!locationCfg.contains("z")) {
            throw new IllegalStateException("Missing z coordinate in respawn_location section of split world config".toString());
        }
        String string = locationCfg.getString("world");
        if (string == null) {
            throw new IllegalStateException("Missing world name in respawn_location section of split world config".toString());
        }
        World world = Bukkit.getWorld((String)string);
        if (world == null) {
            throw new IllegalStateException("Invalid world name in respawn_location section of split world config".toString());
        }
        World world2 = world;
        double x = locationCfg.getDouble("x");
        double y = locationCfg.getDouble("y");
        double z = locationCfg.getDouble("z");
        double yaw = locationCfg.getDouble("yaw", 0.0);
        double pitch = locationCfg.getDouble("yaw", 0.0);
        return new Location(world2, x, y, z, (float)yaw, (float)pitch);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<World, SplitWorldConfig> worldConfigs() {
        Iterable $this$mapTo$iv$iv;
        boolean bl;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List list = this.plugin.getConfig().getMapList("world_configs");
        Intrinsics.checkNotNullExpressionValue(list, "plugin.config\n    .getMapList(\"world_configs\")");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Map it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            Map it = (Map)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof Map ? it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            iterator2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(new SplitWorldConfig((Map<String, ? extends Object>)it, this));
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<World, SplitWorldConfig> pair;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            SplitWorldConfig cfg = (SplitWorldConfig)element$iv$iv;
            boolean bl5 = false;
            World world = Bukkit.getWorld((String)cfg.worldName());
            if (world != null) {
                World world2 = world;
                boolean bl6 = false;
                pair = TuplesKt.to(world2, cfg);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair<World, SplitWorldConfig> it$iv$iv = pair;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }
}

