/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.config;

import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.config.SplitServerConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u0006\u0010\u0016\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/snaco/split_world/config/SplitWorldConfig;", "Lorg/bukkit/configuration/serialization/ConfigurationSerializable;", "map", "", "", "", "splitServerConfig", "Ltech/snaco/split_world/config/SplitServerConfig;", "(Ljava/util/Map;Ltech/snaco/split_world/config/SplitServerConfig;)V", "borderAxis", "borderLocation", "", "borderWidth", "creativeSide", "creativeSideModifier", "defaultGameMode", "Lorg/bukkit/GameMode;", "defaultSideModifier", "enabled", "", "noCreativeMonsters", "serialize", "worldName", "SplitWorld-plugin"})
public final class SplitWorldConfig
implements ConfigurationSerializable {
    @NotNull
    private final Map<String, Object> map;
    @NotNull
    private final SplitServerConfig splitServerConfig;

    public SplitWorldConfig(@NotNull Map<String, ? extends Object> map, @NotNull SplitServerConfig splitServerConfig) {
        Intrinsics.checkNotNullParameter(map, "map");
        Intrinsics.checkNotNullParameter(splitServerConfig, "splitServerConfig");
        this.map = map;
        this.splitServerConfig = splitServerConfig;
    }

    @NotNull
    public final String worldName() {
        Object object = this.map.get("world_name");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            throw new IllegalStateException("world_configs entry missing 'world_name'".toString());
        }
        return string;
    }

    @NotNull
    public final GameMode defaultGameMode() {
        String string;
        block5: {
            block4: {
                String string2;
                Object object = this.map.get("default_game_mode");
                string = object instanceof String ? (String)object : null;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                try {
                    string2 = it;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
                    String string3 = string2.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toUpperCase(locale)");
                    string2 = GameMode.valueOf((String)string3);
                }
                catch (IllegalArgumentException _) {
                    string2 = this.splitServerConfig.defaultGameMode();
                }
                String string4 = string2;
                string = string4;
                if (string4 != null) break block5;
            }
            string = this.splitServerConfig.defaultGameMode();
        }
        return string;
    }

    public final boolean enabled() {
        Object object = this.map.get("enabled");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    @NotNull
    public final String borderAxis() {
        Object object = this.map.get("border_axis");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = "X";
        }
        return string;
    }

    public final double borderLocation() {
        Object object = this.map.get("border_location");
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        return number != null ? number.doubleValue() : 0.0;
    }

    @NotNull
    public final String creativeSide() {
        Object object = this.map.get("creative_side");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = "negative";
        }
        return string;
    }

    public final double borderWidth() {
        Object object = this.map.get("border_width");
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        return number != null ? number.doubleValue() : 5.0;
    }

    public final boolean noCreativeMonsters() {
        Object object = this.map.get("no_creative_monsters");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : true;
    }

    public final double creativeSideModifier() {
        return Intrinsics.areEqual(this.creativeSide(), "negative") ? -1.0 : 1.0;
    }

    public final double defaultSideModifier() {
        return -this.creativeSideModifier();
    }

    @NotNull
    public Map<String, Object> serialize() {
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to("world_name", this.worldName());
        pairArray[1] = TuplesKt.to("enabled", this.enabled());
        pairArray[2] = TuplesKt.to("border_axis", this.borderAxis());
        pairArray[3] = TuplesKt.to("border_location", this.borderLocation());
        pairArray[4] = TuplesKt.to("creative_side", this.creativeSide());
        pairArray[5] = TuplesKt.to("border_width", this.borderWidth());
        pairArray[6] = TuplesKt.to("no_creative_monsters", this.noCreativeMonsters());
        String string = this.defaultGameMode().name();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(locale)");
        pairArray[7] = TuplesKt.to("default_game_mode", string2);
        return MapsKt.mapOf(pairArray);
    }
}

