/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.listener;

import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.utils.BlockUtilsKt;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u0004\"\f\b\u0000\u0010\u0005*\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u001dH\u0007\u00a8\u0006\u001e"}, d2={"Ltech/snaco/split_world/listener/BufferZoneListener;", "Lorg/bukkit/event/Listener;", "()V", "handleBlockEvent", "", "T", "Lorg/bukkit/event/block/BlockEvent;", "Lorg/bukkit/event/Cancellable;", "event", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/event/block/BlockEvent;Lorg/bukkit/entity/Player;)V", "onBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onHealthRegain", "Lorg/bukkit/event/entity/EntityRegainHealthEvent;", "onPickup", "Lorg/bukkit/event/player/PlayerAttemptPickupItemEvent;", "onPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onPlayerLoadChunk", "Lio/papermc/paper/event/packet/PlayerChunkLoadEvent;", "playerDamage", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "playerDamaged", "Lorg/bukkit/event/entity/EntityDamageEvent;", "playerHunger", "Lorg/bukkit/event/entity/FoodLevelChangeEvent;", "SplitWorld-plugin"})
public final class BufferZoneListener
implements Listener {
    @EventHandler
    public final void onDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "event.player.world");
        if (WorldUtilsKt.isSplit(world)) {
            Location location = event.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "event.player.location");
            if (LocationUtilsKt.inBufferZone(location)) {
                event.getPlayer().setHealth(0.1);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void onHealthRegain(@NotNull EntityRegainHealthEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "event.entity.world");
        if (WorldUtilsKt.isSplit(world)) {
            Location location = event.getEntity().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "event.entity.location");
            if (LocationUtilsKt.inBufferZone(location)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void onPlayerLoadChunk(@NotNull PlayerChunkLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "event.world");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        if (!ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().borderBlocks()) {
            return;
        }
        int n = event.getWorld().getMaxHeight();
        for (int y = event.getWorld().getMinHeight(); y < n; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block;
                    Intrinsics.checkNotNullExpressionValue(event.getChunk().getBlock(x, y, z), "event.chunk.getBlock(x, y, z)");
                    if (!block.isSolid() || !BlockUtilsKt.getInBufferZone(block)) continue;
                    event.getPlayer().sendBlockChange(block.getLocation(), Bukkit.createBlockData((Material)Material.BLACK_CONCRETE));
                }
            }
        }
    }

    @EventHandler
    public final void onPickup(@NotNull PlayerAttemptPickupItemEvent event) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(event, "event");
                Location location = event.getPlayer().getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "event.player.location");
                Location location2 = event.getItem().getLocation();
                Intrinsics.checkNotNullExpressionValue(location2, "event.item.location");
                if (LocationUtilsKt.onDifferentSide(location, location2)) break block2;
                Location location3 = event.getPlayer().getLocation();
                Intrinsics.checkNotNullExpressionValue(location3, "event.player.location");
                if (!LocationUtilsKt.inBufferZone(location3)) break block3;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void playerHunger(@NotNull FoodLevelChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "event.entity.world");
        if (WorldUtilsKt.isSplit(world) && event.getEntity() instanceof Player) {
            Location location = event.getEntity().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "event.entity.location");
            if (LocationUtilsKt.inBufferZone(location)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void playerDamage(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "event.entity.world");
        if (WorldUtilsKt.isSplit(world) && event.getEntity() instanceof Player) {
            Location location = event.getEntity().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "event.entity.location");
            if (LocationUtilsKt.inBufferZone(location)) {
                event.setCancelled(true);
            }
        }
        World world2 = event.getDamager().getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "event.damager.world");
        if (WorldUtilsKt.isSplit(world2) && event.getDamager() instanceof Player) {
            Location location = event.getDamager().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "event.damager.location");
            if (LocationUtilsKt.inBufferZone(location)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void playerDamaged(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
            World world = event.getEntity().getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "event.entity.world");
            if (WorldUtilsKt.isSplit(world) && event.getEntity() instanceof Player) {
                Location location = event.getEntity().getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "event.entity.location");
                if (LocationUtilsKt.inBufferZone(location)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public final void onPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        BlockEvent blockEvent = (BlockEvent)event;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        this.handleBlockEvent(blockEvent, player);
    }

    @EventHandler
    public final void onBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        BlockEvent blockEvent = (BlockEvent)event;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        this.handleBlockEvent(blockEvent, player);
    }

    public final <T extends BlockEvent> void handleBlockEvent(@NotNull T event, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(player, "player");
        World world = event.getBlock().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "event.block.world");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "event.block");
        if (BlockUtilsKt.getInBufferZone(block)) {
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "player.location");
            if (!LocationUtilsKt.inBufferZone(location)) {
                ((Cancellable)event).setCancelled(true);
            }
        }
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "player.location");
        if (LocationUtilsKt.onCreativeSide(location)) {
            Block block2 = event.getBlock();
            Intrinsics.checkNotNullExpressionValue(block2, "event.block");
            if (!BlockUtilsKt.getOnCreativeSide(block2)) {
                ((Cancellable)event).setCancelled(true);
            }
        }
        Location location2 = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "player.location");
        if (LocationUtilsKt.onDefaultSide(location2)) {
            Block block3 = event.getBlock();
            Intrinsics.checkNotNullExpressionValue(block3, "event.block");
            if (!BlockUtilsKt.getOnDefaultSide(block3)) {
                ((Cancellable)event).setCancelled(true);
            }
        }
    }
}

