/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.listener;

import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.extras.easter_eggs.Messages;
import tech.snaco.split_world.utils.PlayerUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0007R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/snaco/split_world/listener/EasterEggListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "(Lorg/bukkit/plugin/Plugin;)V", "playersSleepingInNether", "Ljava/util/HashSet;", "Lorg/bukkit/entity/Player;", "Lkotlin/collections/HashSet;", "enterBed", "", "event", "Lorg/bukkit/event/player/PlayerBedEnterEvent;", "enterDeepSleep", "Lio/papermc/paper/event/player/PlayerDeepSleepEvent;", "itemInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "leaveBed", "Lorg/bukkit/event/player/PlayerBedLeaveEvent;", "onDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "SplitWorld-plugin"})
public final class EasterEggListener
implements Listener {
    @NotNull
    private final HashSet<Player> playersSleepingInNether;

    public EasterEggListener(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.playersSleepingInNether = new HashSet();
        new BukkitRunnable(){

            public void run() {
                if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().easterEggsEnabled()) {
                    Messages.INSTANCE.runNetherSleepTask(playersSleepingInNether);
                }
            }
        }.runTaskTimer(plugin, 20L, 1L);
    }

    @EventHandler
    public final void onDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().easterEggsEnabled()) {
            this.playersSleepingInNether.remove(event.getPlayer());
        }
    }

    @EventHandler
    public final void itemInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().easterEggsEnabled()) {
            ItemStack itemStack = event.getItem();
            if ((itemStack != null ? itemStack.getType() : null) == Material.DIAMOND) {
                event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f);
                PlayerInventory playerInventory = event.getPlayer().getInventory();
                PlayerInventory playerInventory2 = event.getPlayer().getInventory();
                Intrinsics.checkNotNullExpressionValue(playerInventory2, "event.player.inventory");
                Iterable iterable = (Iterable)playerInventory2;
                ItemStack itemStack2 = event.getItem();
                Intrinsics.checkNotNull(itemStack2);
                ItemStack itemStack3 = playerInventory.getItem(CollectionsKt.indexOf(iterable, itemStack2));
                Intrinsics.checkNotNull(itemStack3);
                itemStack3.subtract();
                event.getPlayer().giveExpLevels(2);
                event.getPlayer().sendMessage("You ate a diamond you absolute madlad!");
            }
        }
    }

    @EventHandler
    public final void enterBed(@NotNull PlayerBedEnterEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().easterEggsEnabled()) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "event.player");
            if (PlayerUtilsKt.getNetherEgg(player) >= 1561) {
                return;
            }
            if (event.getBedEnterResult() == PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE) {
                event.setUseBed(Event.Result.ALLOW);
                event.getPlayer().sendMessage("Didn't expect that did you?");
            }
        }
    }

    @EventHandler
    public final void enterDeepSleep(@NotNull PlayerDeepSleepEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().easterEggsEnabled()) {
            String string = event.getPlayer().getWorld().getName();
            Intrinsics.checkNotNullExpressionValue(string, "event.player.world.name");
            if (StringsKt.endsWith$default(string, "_nether", false, 2, null)) {
                this.playersSleepingInNether.add(event.getPlayer());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void leaveBed(@NotNull PlayerBedLeaveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().easterEggsEnabled()) {
            String string = event.getPlayer().getWorld().getName();
            Intrinsics.checkNotNullExpressionValue(string, "event.player.world.name");
            if (StringsKt.endsWith$default(string, "_nether", false, 2, null)) {
                this.playersSleepingInNether.remove(event.getPlayer());
            }
        }
    }
}

