/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.listener;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.utils.PlayerUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Ltech/snaco/split_world/listener/GameModeListener;", "Lorg/bukkit/event/Listener;", "()V", "onAdvancementCriterionGrant", "", "event", "Lcom/destroystokyo/paper/event/player/PlayerAdvancementCriterionGrantEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerRespawn", "onPlayerWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "postRespawn", "Lcom/destroystokyo/paper/event/player/PlayerPostRespawnEvent;", "SplitWorld-plugin"})
public final class GameModeListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        PlayerUtilsKt.switchToConfiguredGameMode(player);
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "event.player");
        if (PlayerUtilsKt.inAir(player2) && event.getPlayer().getGameMode() == GameMode.SURVIVAL) {
            Player player3 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player3, "event.player");
            PlayerUtilsKt.warpToGround(player3);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        PlayerUtilsKt.switchToConfiguredGameMode(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerWorldChange(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        PlayerUtilsKt.switchToConfiguredGameMode(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void postRespawn(@NotNull PlayerPostRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        PlayerUtilsKt.switchToConfiguredGameMode(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        PlayerUtilsKt.switchToConfiguredGameMode(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerJoin(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "event.player");
        PlayerUtilsKt.switchToConfiguredGameMode(player);
    }

    @EventHandler
    public final void onAdvancementCriterionGrant(@NotNull PlayerAdvancementCriterionGrantEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().disableAdvancementsInCreative()) {
            return;
        }
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE || event.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            event.setCancelled(true);
        }
    }
}

