/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0004\u00a8\u0006\u0010"}, d2={"inBufferZone", "", "Lorg/bukkit/block/Block;", "getInBufferZone", "(Lorg/bukkit/block/Block;)Z", "onCreativeSide", "getOnCreativeSide", "onDefaultSide", "getOnDefaultSide", "onNegativeSide", "getOnNegativeSide", "onPositiveSide", "getOnPositiveSide", "onDifferentSide", "location", "Lorg/bukkit/Location;", "SplitWorld-plugin"})
public final class BlockUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getInBufferZone(@NotNull Block $this$inBufferZone) {
        Intrinsics.checkNotNullParameter($this$inBufferZone, "<this>");
        Location location = $this$inBufferZone.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "location");
        if (LocationUtilsKt.onNegativeSideOfBuffer(location)) return false;
        Location location2 = $this$inBufferZone.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "location");
        if (LocationUtilsKt.onPositiveSideOfBuffer(location2, -1.0)) return false;
        return true;
    }

    public static final boolean getOnPositiveSide(@NotNull Block $this$onPositiveSide) {
        Intrinsics.checkNotNullParameter($this$onPositiveSide, "<this>");
        Location location = $this$onPositiveSide.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "location");
        return LocationUtilsKt.onPositiveSideOfBuffer(location, -1.0);
    }

    public static final boolean getOnNegativeSide(@NotNull Block $this$onNegativeSide) {
        Intrinsics.checkNotNullParameter($this$onNegativeSide, "<this>");
        Location location = $this$onNegativeSide.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "location");
        return LocationUtilsKt.onNegativeSideOfBuffer(location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getOnDefaultSide(@NotNull Block $this$onDefaultSide) {
        Intrinsics.checkNotNullParameter($this$onDefaultSide, "<this>");
        Location location = $this$onDefaultSide.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "location");
        if (LocationUtilsKt.onNegativeSideOfBuffer(location)) {
            World world = $this$onDefaultSide.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "world");
            if (!Intrinsics.areEqual(WorldUtilsKt.splitConfig(world).creativeSide(), "negative")) return true;
        }
        Location location2 = $this$onDefaultSide.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "location");
        if (!LocationUtilsKt.onPositiveSideOfBuffer(location2, -1.0)) return false;
        World world = $this$onDefaultSide.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "world");
        if (Intrinsics.areEqual(WorldUtilsKt.splitConfig(world).creativeSide(), "positive")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getOnCreativeSide(@NotNull Block $this$onCreativeSide) {
        Intrinsics.checkNotNullParameter($this$onCreativeSide, "<this>");
        Location location = $this$onCreativeSide.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "location");
        if (LocationUtilsKt.onNegativeSideOfBuffer(location)) {
            World world = $this$onCreativeSide.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "world");
            if (Intrinsics.areEqual(WorldUtilsKt.splitConfig(world).creativeSide(), "negative")) return true;
        }
        Location location2 = $this$onCreativeSide.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "location");
        if (!LocationUtilsKt.onPositiveSideOfBuffer(location2, -1.0)) return false;
        World world = $this$onCreativeSide.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "world");
        if (!Intrinsics.areEqual(WorldUtilsKt.splitConfig(world).creativeSide(), "positive")) return false;
        return true;
    }

    public static final boolean onDifferentSide(@NotNull Block $this$onDifferentSide, @NotNull Location location) {
        Intrinsics.checkNotNullParameter($this$onDifferentSide, "<this>");
        Intrinsics.checkNotNullParameter(location, "location");
        return BlockUtilsKt.getOnCreativeSide($this$onDifferentSide) && !LocationUtilsKt.onCreativeSide(location) || BlockUtilsKt.getOnDefaultSide($this$onDifferentSide) && !LocationUtilsKt.onDefaultSide(location);
    }
}

