/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.utils;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0001\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0001\u001a\u0012\u0010\t\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0001\u001a\u0012\u0010\f\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0001\u001a\u0012\u0010\u000f\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0011"}, d2={"addAcrossSplitAxis", "Lorg/bukkit/Location;", "value", "", "closestSolidBlockBelow", "getRelevantPos", "inBufferZone", "", "extra", "onCreativeSide", "offset", "onDefaultSide", "onDifferentSide", "otherLocation", "onNegativeSideOfBuffer", "onPositiveSideOfBuffer", "setRelevantPos", "SplitWorld-plugin"})
public final class LocationUtilsKt {
    public static final boolean onDefaultSide(@NotNull Location $this$onDefaultSide) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$onDefaultSide, "<this>");
        World world = $this$onDefaultSide.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "this.world");
        if (Intrinsics.areEqual(WorldUtilsKt.splitConfig(world).creativeSide(), "negative") && LocationUtilsKt.onPositiveSideOfBuffer($this$onDefaultSide)) {
            bl = true;
        } else {
            World world2 = $this$onDefaultSide.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "this.world");
            bl = Intrinsics.areEqual(WorldUtilsKt.splitConfig(world2).creativeSide(), "positive") && LocationUtilsKt.onNegativeSideOfBuffer($this$onDefaultSide);
        }
        return bl;
    }

    public static final boolean onDifferentSide(@NotNull Location $this$onDifferentSide, @NotNull Location otherLocation) {
        Intrinsics.checkNotNullParameter($this$onDifferentSide, "<this>");
        Intrinsics.checkNotNullParameter(otherLocation, "otherLocation");
        boolean acrossDefaultSide = LocationUtilsKt.onDefaultSide($this$onDifferentSide) && !LocationUtilsKt.onDefaultSide(otherLocation);
        boolean acrossBufferZone = LocationUtilsKt.inBufferZone($this$onDifferentSide) && !LocationUtilsKt.inBufferZone(otherLocation);
        boolean acrossCreativeSide = LocationUtilsKt.onCreativeSide($this$onDifferentSide) && !LocationUtilsKt.onCreativeSide(otherLocation);
        return acrossCreativeSide || acrossDefaultSide || acrossBufferZone;
    }

    public static final boolean onCreativeSide(@NotNull Location $this$onCreativeSide) {
        Intrinsics.checkNotNullParameter($this$onCreativeSide, "<this>");
        return LocationUtilsKt.onCreativeSide($this$onCreativeSide, 0.0);
    }

    public static final boolean onCreativeSide(@NotNull Location $this$onCreativeSide, double offset) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$onCreativeSide, "<this>");
        World world = $this$onCreativeSide.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "this.world");
        if (Intrinsics.areEqual(WorldUtilsKt.splitConfig(world).creativeSide(), "negative") && LocationUtilsKt.onNegativeSideOfBuffer($this$onCreativeSide, offset)) {
            bl = true;
        } else {
            World world2 = $this$onCreativeSide.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "this.world");
            bl = Intrinsics.areEqual(WorldUtilsKt.splitConfig(world2).creativeSide(), "positive") && LocationUtilsKt.onPositiveSideOfBuffer($this$onCreativeSide, offset);
        }
        return bl;
    }

    public static final boolean inBufferZone(@NotNull Location $this$inBufferZone) {
        Intrinsics.checkNotNullParameter($this$inBufferZone, "<this>");
        return !LocationUtilsKt.onNegativeSideOfBuffer($this$inBufferZone) && !LocationUtilsKt.onPositiveSideOfBuffer($this$inBufferZone);
    }

    public static final boolean inBufferZone(@NotNull Location $this$inBufferZone, double extra) {
        Intrinsics.checkNotNullParameter($this$inBufferZone, "<this>");
        return !LocationUtilsKt.onNegativeSideOfBuffer($this$inBufferZone, extra) && !LocationUtilsKt.onPositiveSideOfBuffer($this$inBufferZone, extra);
    }

    public static final double getRelevantPos(@NotNull Location $this$getRelevantPos) {
        Intrinsics.checkNotNullParameter($this$getRelevantPos, "<this>");
        World world = $this$getRelevantPos.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "this.world");
        String string = WorldUtilsKt.splitConfig(world).borderAxis().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        String string2 = string;
        return Intrinsics.areEqual(string2, "Y") ? $this$getRelevantPos.getY() : (Intrinsics.areEqual(string2, "Z") ? $this$getRelevantPos.getZ() : $this$getRelevantPos.getX());
    }

    @NotNull
    public static final Location setRelevantPos(@NotNull Location $this$setRelevantPos, double value) {
        Intrinsics.checkNotNullParameter($this$setRelevantPos, "<this>");
        World world = $this$setRelevantPos.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "this.world");
        String string = WorldUtilsKt.splitConfig(world).borderAxis().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        String string2 = string;
        if (Intrinsics.areEqual(string2, "Y")) {
            $this$setRelevantPos.setY(value);
        } else if (Intrinsics.areEqual(string2, "Z")) {
            $this$setRelevantPos.setZ(value);
        } else {
            $this$setRelevantPos.setX(value);
        }
        return $this$setRelevantPos;
    }

    public static final boolean onNegativeSideOfBuffer(@NotNull Location $this$onNegativeSideOfBuffer) {
        Intrinsics.checkNotNullParameter($this$onNegativeSideOfBuffer, "<this>");
        return LocationUtilsKt.onNegativeSideOfBuffer($this$onNegativeSideOfBuffer, 0.0);
    }

    public static final boolean onNegativeSideOfBuffer(@NotNull Location $this$onNegativeSideOfBuffer, double extra) {
        Intrinsics.checkNotNullParameter($this$onNegativeSideOfBuffer, "<this>");
        double d = LocationUtilsKt.getRelevantPos($this$onNegativeSideOfBuffer);
        World world = $this$onNegativeSideOfBuffer.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "world");
        double d2 = WorldUtilsKt.splitConfig(world).borderLocation();
        World world2 = $this$onNegativeSideOfBuffer.getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "world");
        return d < d2 - WorldUtilsKt.splitConfig(world2).borderWidth() - extra;
    }

    public static final boolean onPositiveSideOfBuffer(@NotNull Location $this$onPositiveSideOfBuffer) {
        Intrinsics.checkNotNullParameter($this$onPositiveSideOfBuffer, "<this>");
        return LocationUtilsKt.onPositiveSideOfBuffer($this$onPositiveSideOfBuffer, 0.0);
    }

    public static final boolean onPositiveSideOfBuffer(@NotNull Location $this$onPositiveSideOfBuffer, double extra) {
        Intrinsics.checkNotNullParameter($this$onPositiveSideOfBuffer, "<this>");
        double d = LocationUtilsKt.getRelevantPos($this$onPositiveSideOfBuffer);
        World world = $this$onPositiveSideOfBuffer.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "world");
        double d2 = WorldUtilsKt.splitConfig(world).borderLocation();
        World world2 = $this$onPositiveSideOfBuffer.getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "world");
        return d > d2 + WorldUtilsKt.splitConfig(world2).borderWidth() + extra;
    }

    @NotNull
    public static final Location addAcrossSplitAxis(@NotNull Location $this$addAcrossSplitAxis, double value) {
        Intrinsics.checkNotNullParameter($this$addAcrossSplitAxis, "<this>");
        World world = $this$addAcrossSplitAxis.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "this.world");
        String string = WorldUtilsKt.splitConfig(world).borderAxis();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(locale)");
        String string3 = string2;
        if (Intrinsics.areEqual(string3, "Y")) {
            $this$addAcrossSplitAxis.setY($this$addAcrossSplitAxis.getY() + value);
        } else if (Intrinsics.areEqual(string3, "Z")) {
            $this$addAcrossSplitAxis.setZ($this$addAcrossSplitAxis.getZ() + value);
        } else {
            $this$addAcrossSplitAxis.setX($this$addAcrossSplitAxis.getX() + value);
        }
        return $this$addAcrossSplitAxis;
    }

    @NotNull
    public static final Location closestSolidBlockBelow(@NotNull Location $this$closestSolidBlockBelow) {
        Intrinsics.checkNotNullParameter($this$closestSolidBlockBelow, "<this>");
        Location location = $this$closestSolidBlockBelow.clone();
        Intrinsics.checkNotNullExpressionValue(location, "this.clone()");
        Location loc = location;
        boolean blockFound = false;
        while (!blockFound) {
            loc.add(0.0, -1.0, 0.0);
            if (loc.getBlock().isSolid()) {
                blockFound = true;
            }
            if (!(loc.getY() <= -64.0)) continue;
            break;
        }
        return loc;
    }
}

