/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.utils;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.snaco.split_world.SplitWorldPlugin;
import tech.snaco.split_world.event.AfterGameModeChangeEvent;
import tech.snaco.split_world.event.BeforeGameModeChangeEvent;
import tech.snaco.split_world.types.ItemStackArrayDataType;
import tech.snaco.split_world.types.PotionEffectArrayDataType;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a \u0010\b\u001a\u0004\u0018\u00010?2\u0006\u0010F\u001a\u00020\u00112\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010?0H\u001a \u0010I\u001a\u0004\u0018\u00010?2\u0006\u0010F\u001a\u00020\u00112\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010?0H\u001a\n\u0010J\u001a\u00020K*\u00020\u0001\u001a\u0012\u0010L\u001a\u00020M*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u0012\u0010P\u001a\u00020M*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u0012\u0010Q\u001a\u00020M*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u0019\u0010R\u001a\u0004\u0018\u00010\u0011*\u00020\u00012\u0006\u0010S\u001a\u00020T\u00a2\u0006\u0002\u0010U\u001a\u001a\u0010R\u001a\u00020\u0011*\u00020\u00012\u0006\u0010S\u001a\u00020T2\u0006\u0010V\u001a\u00020\u0011\u001a\u0019\u0010W\u001a\u0004\u0018\u00010\u001c*\u00020\u00012\u0006\u0010S\u001a\u00020T\u00a2\u0006\u0002\u0010X\u001a\u001a\u0010W\u001a\u00020\u001c*\u00020\u00012\u0006\u0010S\u001a\u00020T2\u0006\u0010V\u001a\u00020\u001c\u001a\n\u0010Y\u001a\u00020@*\u00020\u0001\u001a\n\u0010Z\u001a\u00020\u0011*\u00020\u0001\u001a\u0018\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u001d\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_*\u00020\u00012\u0006\u0010N\u001a\u00020O\u00a2\u0006\u0002\u0010a\u001a\u001d\u0010b\u001a\b\u0012\u0004\u0012\u00020`0_*\u00020\u00012\u0006\u0010N\u001a\u00020O\u00a2\u0006\u0002\u0010a\u001a\n\u0010c\u001a\u00020@*\u00020\u0001\u001a\n\u0010d\u001a\u00020@*\u00020\u0001\u001a\u001a\u0010e\u001a\u00020@*\u00020\u00012\u0006\u0010S\u001a\u00020T2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010f\u001a\u00020@*\u00020\u00012\u0006\u0010S\u001a\u00020T2\u0006\u0010\u0010\u001a\u00020\u001c\u001a\u001a\u0010f\u001a\u00020@*\u00020\u00012\u0006\u0010g\u001a\u00020M2\u0006\u0010\u0010\u001a\u00020\u001c\u001a\u0012\u0010h\u001a\u00020@*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u0012\u0010i\u001a\u00020@*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u0012\u0010j\u001a\u00020@*\u00020\u00012\u0006\u0010N\u001a\u00020O\u001a\u0012\u0010k\u001a\u00020@*\u00020\u00012\u0006\u0010l\u001a\u00020O\u001a\n\u0010m\u001a\u00020@*\u00020\u0001\u001a\n\u0010n\u001a\u00020@*\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0003\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0003\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0003\"(\u0010\u0012\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\"(\u0010\u0017\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\"\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0003\"(\u0010\u001d\u001a\u00020\u001c*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\"(\u0010\"\u001a\u00020\u001c*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!\"(\u0010%\u001a\u00020\u001c*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!\"\u0015\u0010(\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0003\"\u0015\u0010*\u001a\u00020\u0011*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014\"(\u0010,\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\u0014\"\u0004\b.\u0010\u0016\"(\u0010/\u001a\u00020\u001c*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u001f\"\u0004\b1\u0010!\"\u0015\u00102\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0003\"(\u00104\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0014\"\u0004\b6\u0010\u0016\"(\u00107\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u0014\"\u0004\b9\u0010\u0016\"\u0015\u0010:\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0003\"\u0015\u0010<\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0003\"\u0018\u0010>\u001a\u00020?*\u00020@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\"(\u0010C\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010\u0014\"\u0004\bE\u0010\u0016\u00a8\u0006o"}, d2={"I", "Lorg/bukkit/entity/Player;", "getI", "(Lorg/bukkit/entity/Player;)Lorg/bukkit/entity/Player;", "_for", "get_for", "after", "getAfter", "also", "getAlso", "am", "getAm", "and", "getAnd", "at", "getAt", "value", "", "firstFishAttempt", "getFirstFishAttempt", "(Lorg/bukkit/entity/Player;)Z", "setFirstFishAttempt", "(Lorg/bukkit/entity/Player;Z)V", "firstJoin", "getFirstJoin", "setFirstJoin", "my", "getMy", "", "netherEgg", "getNetherEgg", "(Lorg/bukkit/entity/Player;)I", "setNetherEgg", "(Lorg/bukkit/entity/Player;I)V", "netherSleepThrottle", "getNetherSleepThrottle", "setNetherSleepThrottle", "netherSleepTock", "getNetherSleepTock", "setNetherSleepTock", "set", "getSet", "shouldAlwaysSeeTheSparkle", "getShouldAlwaysSeeTheSparkle", "shouldHearTheDing", "getShouldHearTheDing", "setShouldHearTheDing", "sleepInNetherScore", "getSleepInNetherScore", "setSleepInNetherScore", "so", "getSo", "spawnBuilder", "getSpawnBuilder", "setSpawnBuilder", "splitWorldDisabled", "getSplitWorldDisabled", "setSplitWorldDisabled", "that", "getThat", "then", "getThen", "too", "", "", "getToo", "(Lkotlin/Unit;)Ljava/lang/Object;", "welcomeMessageDisabled", "getWelcomeMessageDisabled", "setWelcomeMessageDisabled", "condition", "op", "Lkotlin/Function0;", "andIf", "facingVector", "Lorg/bukkit/util/Vector;", "getEffectsKey", "Lorg/bukkit/NamespacedKey;", "gameMode", "Lorg/bukkit/GameMode;", "getEnderChestKey", "getInventoryKey", "getPdcBoolean", "name", "", "(Lorg/bukkit/entity/Player;Ljava/lang/String;)Ljava/lang/Boolean;", "default", "getPdcInt", "(Lorg/bukkit/entity/Player;Ljava/lang/String;)Ljava/lang/Integer;", "hearThatDing", "inAir", "peekAtEffects", "", "Lorg/bukkit/potion/PotionEffect;", "peekAtEnderChest", "", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/bukkit/entity/Player;Lorg/bukkit/GameMode;)[Lorg/bukkit/inventory/ItemStack;", "peekAtInventory", "preventFirstFallDamage", "seeThatSparkle", "setPdcBoolean", "setPdcInt", "key", "stashMyEnderChest", "stashMyInventory", "stashMyPotionEffects", "switchGameMode", "theOneItShouldBe", "switchToConfiguredGameMode", "warpToGround", "SplitWorld-plugin"})
@SourceDebugExtension(value={"SMAP\nPlayerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerUtils.kt\ntech/snaco/split_world/utils/PlayerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n37#3,2:287\n37#3,2:289\n37#3,2:291\n37#3,2:293\n1855#4,2:295\n*S KotlinDebug\n*F\n+ 1 PlayerUtils.kt\ntech/snaco/split_world/utils/PlayerUtilsKt\n*L\n120#1:287,2\n124#1:289,2\n128#1:291,2\n147#1:293,2\n245#1:295,2\n*E\n"})
public final class PlayerUtilsKt {
    @NotNull
    public static final NamespacedKey getInventoryKey(@NotNull Player $this$getInventoryKey, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$getInventoryKey, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Plugin plugin = (Plugin)ServerUtilsKt.splitWorldPlugin();
        StringBuilder stringBuilder = new StringBuilder().append($this$getInventoryKey.getName()).append('_');
        String string = gameMode.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return new NamespacedKey(plugin, stringBuilder.append(string).append("_inv").toString());
    }

    @NotNull
    public static final NamespacedKey getEnderChestKey(@NotNull Player $this$getEnderChestKey, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$getEnderChestKey, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Plugin plugin = (Plugin)ServerUtilsKt.splitWorldPlugin();
        StringBuilder stringBuilder = new StringBuilder().append($this$getEnderChestKey.getName()).append('_');
        String string = gameMode.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return new NamespacedKey(plugin, stringBuilder.append(string).append("_ender_chest").toString());
    }

    @NotNull
    public static final NamespacedKey getEffectsKey(@NotNull Player $this$getEffectsKey, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$getEffectsKey, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Plugin plugin = (Plugin)ServerUtilsKt.splitWorldPlugin();
        StringBuilder stringBuilder = new StringBuilder().append($this$getEffectsKey.getName()).append('_');
        String string = gameMode.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return new NamespacedKey(plugin, stringBuilder.append(string).append("_eff").toString());
    }

    public static final void setPdcInt(@NotNull Player $this$setPdcInt, @NotNull String name, int value) {
        Intrinsics.checkNotNullParameter($this$setPdcInt, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        PlayerUtilsKt.setPdcInt($this$setPdcInt, ServerUtilsKt.splitWorldPlugin().pdcKey(name), value);
    }

    public static final void setPdcInt(@NotNull Player $this$setPdcInt, @NotNull NamespacedKey key, int value) {
        Intrinsics.checkNotNullParameter($this$setPdcInt, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        $this$setPdcInt.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
    }

    public static final void setPdcBoolean(@NotNull Player $this$setPdcBoolean, @NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter($this$setPdcBoolean, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        $this$setPdcBoolean.getPersistentDataContainer().set(ServerUtilsKt.splitWorldPlugin().pdcKey(name), PersistentDataType.INTEGER, (Object)(value ? 1 : 0));
    }

    @Nullable
    public static final Boolean getPdcBoolean(@NotNull Player $this$getPdcBoolean, @NotNull String name) {
        Boolean bl;
        Intrinsics.checkNotNullParameter($this$getPdcBoolean, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = (Integer)$this$getPdcBoolean.getPersistentDataContainer().get(ServerUtilsKt.splitWorldPlugin().pdcKey(name), PersistentDataType.INTEGER);
        if (n != null) {
            Integer it = n;
            boolean bl2 = false;
            int n2 = 1;
            bl = it == n2;
        } else {
            bl = null;
        }
        return bl;
    }

    public static final boolean getPdcBoolean(@NotNull Player $this$getPdcBoolean, @NotNull String name, boolean bl) {
        Intrinsics.checkNotNullParameter($this$getPdcBoolean, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Boolean bl2 = PlayerUtilsKt.getPdcBoolean($this$getPdcBoolean, name);
        return bl2 != null ? bl2 : bl;
    }

    @Nullable
    public static final Integer getPdcInt(@NotNull Player $this$getPdcInt, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getPdcInt, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return (Integer)$this$getPdcInt.getPersistentDataContainer().get(ServerUtilsKt.splitWorldPlugin().pdcKey(name), PersistentDataType.INTEGER);
    }

    public static final int getPdcInt(@NotNull Player $this$getPdcInt, @NotNull String name, int n) {
        Intrinsics.checkNotNullParameter($this$getPdcInt, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n2 = PlayerUtilsKt.getPdcInt($this$getPdcInt, name);
        return n2 != null ? n2 : n;
    }

    public static final boolean getWelcomeMessageDisabled(@NotNull Player $this$welcomeMessageDisabled) {
        Intrinsics.checkNotNullParameter($this$welcomeMessageDisabled, "<this>");
        return PlayerUtilsKt.getPdcBoolean($this$welcomeMessageDisabled, "no_welcome_message", false);
    }

    public static final void setWelcomeMessageDisabled(@NotNull Player $this$welcomeMessageDisabled, boolean value) {
        Intrinsics.checkNotNullParameter($this$welcomeMessageDisabled, "<this>");
        PlayerUtilsKt.setPdcBoolean($this$welcomeMessageDisabled, "no_welcome_message", value);
    }

    public static final boolean getSplitWorldDisabled(@NotNull Player $this$splitWorldDisabled) {
        Intrinsics.checkNotNullParameter($this$splitWorldDisabled, "<this>");
        return PlayerUtilsKt.getPdcBoolean($this$splitWorldDisabled, "split_world_disabled", false);
    }

    public static final void setSplitWorldDisabled(@NotNull Player $this$splitWorldDisabled, boolean value) {
        Intrinsics.checkNotNullParameter($this$splitWorldDisabled, "<this>");
        PlayerUtilsKt.setPdcBoolean($this$splitWorldDisabled, "split_world_disabled", value);
    }

    public static final boolean getFirstJoin(@NotNull Player $this$firstJoin) {
        Intrinsics.checkNotNullParameter($this$firstJoin, "<this>");
        return PlayerUtilsKt.getPdcBoolean($this$firstJoin, "first_join", true);
    }

    public static final void setFirstJoin(@NotNull Player $this$firstJoin, boolean value) {
        Intrinsics.checkNotNullParameter($this$firstJoin, "<this>");
        PlayerUtilsKt.setPdcBoolean($this$firstJoin, "first_join", value);
    }

    public static final boolean getFirstFishAttempt(@NotNull Player $this$firstFishAttempt) {
        Intrinsics.checkNotNullParameter($this$firstFishAttempt, "<this>");
        return PlayerUtilsKt.getPdcBoolean($this$firstFishAttempt, "first_fish_attempt", true);
    }

    public static final void setFirstFishAttempt(@NotNull Player $this$firstFishAttempt, boolean value) {
        Intrinsics.checkNotNullParameter($this$firstFishAttempt, "<this>");
        PlayerUtilsKt.setPdcBoolean($this$firstFishAttempt, "first_fish_attempt", value);
    }

    public static final boolean getSpawnBuilder(@NotNull Player $this$spawnBuilder) {
        Intrinsics.checkNotNullParameter($this$spawnBuilder, "<this>");
        return PlayerUtilsKt.getPdcBoolean($this$spawnBuilder, "spawn_builder", false);
    }

    public static final void setSpawnBuilder(@NotNull Player $this$spawnBuilder, boolean value) {
        Intrinsics.checkNotNullParameter($this$spawnBuilder, "<this>");
        PlayerUtilsKt.setPdcBoolean($this$spawnBuilder, "spawn_builder", value);
    }

    public static final boolean getShouldHearTheDing(@NotNull Player $this$shouldHearTheDing) {
        Intrinsics.checkNotNullParameter($this$shouldHearTheDing, "<this>");
        return PlayerUtilsKt.getPdcBoolean($this$shouldHearTheDing, "play_border_sound", true);
    }

    public static final void setShouldHearTheDing(@NotNull Player $this$shouldHearTheDing, boolean value) {
        Intrinsics.checkNotNullParameter($this$shouldHearTheDing, "<this>");
        PlayerUtilsKt.setPdcBoolean($this$shouldHearTheDing, "play_border_sound", value);
    }

    public static final int getSleepInNetherScore(@NotNull Player $this$sleepInNetherScore) {
        Intrinsics.checkNotNullParameter($this$sleepInNetherScore, "<this>");
        return PlayerUtilsKt.getPdcInt($this$sleepInNetherScore, "sleep_in_nether_score", 0);
    }

    public static final void setSleepInNetherScore(@NotNull Player $this$sleepInNetherScore, int value) {
        Intrinsics.checkNotNullParameter($this$sleepInNetherScore, "<this>");
        PlayerUtilsKt.setPdcInt($this$sleepInNetherScore, "sleep_in_nether_score", value);
    }

    public static final int getNetherEgg(@NotNull Player $this$netherEgg) {
        Intrinsics.checkNotNullParameter($this$netherEgg, "<this>");
        return PlayerUtilsKt.getPdcInt($this$netherEgg, "nether_egg_score", 0);
    }

    public static final void setNetherEgg(@NotNull Player $this$netherEgg, int value) {
        Intrinsics.checkNotNullParameter($this$netherEgg, "<this>");
        PlayerUtilsKt.setPdcInt($this$netherEgg, "nether_egg_score", value);
    }

    public static final int getNetherSleepThrottle(@NotNull Player $this$netherSleepThrottle) {
        Intrinsics.checkNotNullParameter($this$netherSleepThrottle, "<this>");
        return PlayerUtilsKt.getPdcInt($this$netherSleepThrottle, "nether_sleep_throttle", 100);
    }

    public static final void setNetherSleepThrottle(@NotNull Player $this$netherSleepThrottle, int value) {
        Intrinsics.checkNotNullParameter($this$netherSleepThrottle, "<this>");
        PlayerUtilsKt.setPdcInt($this$netherSleepThrottle, "nether_sleep_throttle", value);
    }

    public static final int getNetherSleepTock(@NotNull Player $this$netherSleepTock) {
        Intrinsics.checkNotNullParameter($this$netherSleepTock, "<this>");
        return PlayerUtilsKt.getPdcInt($this$netherSleepTock, "nether_sleep_tock", 1);
    }

    public static final void setNetherSleepTock(@NotNull Player $this$netherSleepTock, int value) {
        Intrinsics.checkNotNullParameter($this$netherSleepTock, "<this>");
        PlayerUtilsKt.setPdcInt($this$netherSleepTock, "nether_sleep_tock", value);
    }

    public static final void preventFirstFallDamage(@NotNull Player $this$preventFirstFallDamage) {
        Intrinsics.checkNotNullParameter($this$preventFirstFallDamage, "<this>");
        Ref.ObjectRef taskRef = new Ref.ObjectRef();
        SplitWorldPlugin plugin = ServerUtilsKt.splitWorldPlugin();
        long start = System.currentTimeMillis();
        taskRef.element = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> PlayerUtilsKt.preventFirstFallDamage$lambda$1($this$preventFirstFallDamage, taskRef, start), 1L, 1L);
    }

    @NotNull
    public static final ItemStack[] peekAtInventory(@NotNull Player $this$peekAtInventory, @NotNull GameMode gameMode) {
        ItemStack[] itemStackArray;
        Intrinsics.checkNotNullParameter($this$peekAtInventory, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        ItemStack[] itemStackArray2 = (ItemStack[])$this$peekAtInventory.getPersistentDataContainer().get(PlayerUtilsKt.getInventoryKey($this$peekAtInventory, gameMode), (PersistentDataType)new ItemStackArrayDataType());
        if (itemStackArray2 == null) {
            Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
        } else {
            itemStackArray = itemStackArray2;
        }
        return itemStackArray;
    }

    @NotNull
    public static final ItemStack[] peekAtEnderChest(@NotNull Player $this$peekAtEnderChest, @NotNull GameMode gameMode) {
        ItemStack[] itemStackArray;
        Intrinsics.checkNotNullParameter($this$peekAtEnderChest, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        ItemStack[] itemStackArray2 = (ItemStack[])$this$peekAtEnderChest.getPersistentDataContainer().get(PlayerUtilsKt.getEnderChestKey($this$peekAtEnderChest, gameMode), (PersistentDataType)new ItemStackArrayDataType());
        if (itemStackArray2 == null) {
            Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
        } else {
            itemStackArray = itemStackArray2;
        }
        return itemStackArray;
    }

    @NotNull
    public static final List<PotionEffect> peekAtEffects(@NotNull Player $this$peekAtEffects, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$peekAtEffects, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        PotionEffect[] potionEffectArray = (PotionEffect[])$this$peekAtEffects.getPersistentDataContainer().get(PlayerUtilsKt.getEffectsKey($this$peekAtEffects, gameMode), (PersistentDataType)new PotionEffectArrayDataType());
        if (potionEffectArray == null) {
            Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            potionEffectArray = thisCollection$iv.toArray(new PotionEffect[0]);
        }
        Intrinsics.checkNotNullExpressionValue(potionEffectArray, "persistentDataContainer.\u2026nEffect>().toTypedArray()");
        return ArraysKt.toList((Object[])potionEffectArray);
    }

    public static final void stashMyInventory(@NotNull Player $this$stashMyInventory, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$stashMyInventory, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        $this$stashMyInventory.getPersistentDataContainer().set(PlayerUtilsKt.getInventoryKey($this$stashMyInventory, gameMode), (PersistentDataType)new ItemStackArrayDataType(), (Object)$this$stashMyInventory.getInventory().getContents());
    }

    public static final void stashMyEnderChest(@NotNull Player $this$stashMyEnderChest, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$stashMyEnderChest, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        $this$stashMyEnderChest.getPersistentDataContainer().set(PlayerUtilsKt.getEnderChestKey($this$stashMyEnderChest, gameMode), (PersistentDataType)new ItemStackArrayDataType(), (Object)$this$stashMyEnderChest.getEnderChest().getContents());
    }

    public static final void stashMyPotionEffects(@NotNull Player $this$stashMyPotionEffects, @NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter($this$stashMyPotionEffects, "<this>");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        PersistentDataContainer persistentDataContainer = $this$stashMyPotionEffects.getPersistentDataContainer();
        NamespacedKey namespacedKey = PlayerUtilsKt.getEffectsKey($this$stashMyPotionEffects, gameMode);
        PersistentDataType persistentDataType = new PotionEffectArrayDataType();
        Collection collection = $this$stashMyPotionEffects.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue(collection, "activePotionEffects");
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        persistentDataContainer.set(namespacedKey, persistentDataType, (Object)thisCollection$iv.toArray(new PotionEffect[0]));
    }

    public static final void switchToConfiguredGameMode(@NotNull Player $this$switchToConfiguredGameMode) {
        Intrinsics.checkNotNullParameter($this$switchToConfiguredGameMode, "<this>");
        if (PlayerUtilsKt.getSplitWorldDisabled($this$switchToConfiguredGameMode)) {
            return;
        }
        World world = $this$switchToConfiguredGameMode.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "world");
        if (!WorldUtilsKt.isSplit(world)) {
            World world2 = $this$switchToConfiguredGameMode.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "world");
            PlayerUtilsKt.switchGameMode($this$switchToConfiguredGameMode, WorldUtilsKt.getDefaultGameMode(world2));
            return;
        }
        Location location = $this$switchToConfiguredGameMode.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "location");
        if (LocationUtilsKt.inBufferZone(location)) {
            boolean wasFlying = $this$switchToConfiguredGameMode.isFlying();
            boolean wasGliding = $this$switchToConfiguredGameMode.isGliding();
            PlayerUtilsKt.switchGameMode($this$switchToConfiguredGameMode, GameMode.ADVENTURE);
            $this$switchToConfiguredGameMode.setAllowFlight(true);
            if (wasGliding || wasFlying) {
                $this$switchToConfiguredGameMode.setFlying(true);
            }
        } else {
            Location location2 = $this$switchToConfiguredGameMode.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "location");
            if (LocationUtilsKt.onCreativeSide(location2)) {
                PlayerUtilsKt.switchGameMode($this$switchToConfiguredGameMode, GameMode.CREATIVE);
            } else {
                Location location3 = $this$switchToConfiguredGameMode.getLocation();
                Intrinsics.checkNotNullExpressionValue(location3, "location");
                if (LocationUtilsKt.onDefaultSide(location3)) {
                    World world3 = $this$switchToConfiguredGameMode.getWorld();
                    Intrinsics.checkNotNullExpressionValue(world3, "world");
                    PlayerUtilsKt.switchGameMode($this$switchToConfiguredGameMode, WorldUtilsKt.getDefaultGameMode(world3));
                }
            }
        }
    }

    public static final boolean inAir(@NotNull Player $this$inAir) {
        Intrinsics.checkNotNullParameter($this$inAir, "<this>");
        Location location = $this$inAir.getLocation().clone().add(0.0, -1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "location\n    .clone()\n    .add(0.0, -1.0, 0.0)");
        Location underFeet = location;
        return underFeet.getBlock().getType() == Material.AIR && $this$inAir.getLocation().getBlock().getType() == Material.AIR;
    }

    public static final void warpToGround(@NotNull Player $this$warpToGround) {
        Location location;
        Intrinsics.checkNotNullParameter($this$warpToGround, "<this>");
        Location location2 = $this$warpToGround.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location2, "location.clone()");
        Location location3 = location2;
        Block block = $this$warpToGround.getWorld().getHighestBlockAt(location3.getBlockX(), location3.getBlockZ());
        Intrinsics.checkNotNullExpressionValue(block, "world.getHighestBlockAt(\u2026.blockX, location.blockZ)");
        Block top = block;
        float pitch = location3.getPitch();
        float yaw = location3.getYaw();
        if (location3.getBlock().getType() == Material.AIR && location3.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR) {
            location = LocationUtilsKt.closestSolidBlockBelow(LocationUtilsKt.addAcrossSplitAxis(location3, 0.5)).add(0.0, 1.0, 0.0);
        } else {
            Location location4 = top.getLocation();
            Intrinsics.checkNotNullExpressionValue(location4, "top.location");
            location = LocationUtilsKt.addAcrossSplitAxis(location4, 0.5).add(0.0, 1.0, 0.0);
        }
        Location location5 = location;
        Intrinsics.checkNotNullExpressionValue(location5, "if (location.block.type \u2026  .add(0.0, 1.0, 0.0)\n  }");
        Location destination = location5;
        destination.setPitch(pitch);
        destination.setYaw(yaw);
        $this$warpToGround.teleport(destination);
    }

    @NotNull
    public static final Vector facingVector(@NotNull Player $this$facingVector) {
        Vector vector;
        Intrinsics.checkNotNullParameter($this$facingVector, "<this>");
        double y = 1.5;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$facingVector.getFacing().ordinal()]) {
            case 1: {
                vector = new Vector(0.0, y, -1.0);
                break;
            }
            case 2: {
                vector = new Vector(0.0, y, 1.0);
                break;
            }
            case 3: {
                vector = new Vector(1.0, y, 0.0);
                break;
            }
            case 4: {
                vector = new Vector(-1.0, y, 0.0);
                break;
            }
            case 5: {
                vector = new Vector(0.0, y + 1.0, 0.0);
                break;
            }
            case 6: {
                vector = new Vector(0.0, y - 1.0, 0.0);
                break;
            }
            case 7: {
                vector = new Vector(1.0, y, -1.0);
                break;
            }
            case 8: {
                vector = new Vector(-1.0, y, -1.0);
                break;
            }
            case 9: {
                vector = new Vector(1.0, y, 1.0);
                break;
            }
            case 10: {
                vector = new Vector(-1.0, y, 1.0);
                break;
            }
            case 11: {
                vector = new Vector(-1.0, y, -0.5);
                break;
            }
            case 12: {
                vector = new Vector(-0.5, y, -1.0);
                break;
            }
            case 13: {
                vector = new Vector(0.5, y, -1.0);
                break;
            }
            case 14: {
                vector = new Vector(1.0, y, -0.5);
                break;
            }
            case 15: {
                vector = new Vector(1.0, y, 0.5);
                break;
            }
            case 16: {
                vector = new Vector(0.5, y, 1.0);
                break;
            }
            case 17: {
                vector = new Vector(-0.5, y, 1.0);
                break;
            }
            case 18: {
                vector = new Vector(-1.0, y, 0.5);
                break;
            }
            case 19: {
                vector = new Vector(0, 0, 0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return vector;
    }

    public static final void switchGameMode(@NotNull Player $this$switchGameMode, @NotNull GameMode theOneItShouldBe) {
        Intrinsics.checkNotNullParameter($this$switchGameMode, "<this>");
        Intrinsics.checkNotNullParameter(theOneItShouldBe, "theOneItShouldBe");
        new BeforeGameModeChangeEvent($this$switchGameMode, theOneItShouldBe).callEvent();
        GameMode gameMode = PlayerUtilsKt.getMy($this$switchGameMode).getGameMode();
        Intrinsics.checkNotNullExpressionValue(gameMode, "my.gameMode");
        GameMode theOneItWas = gameMode;
        if (PlayerUtilsKt.getMy($this$switchGameMode).getGameMode() != theOneItShouldBe) {
            PlayerUtilsKt.andIf(PlayerUtilsKt.getShouldHearTheDing(PlayerUtilsKt.getI($this$switchGameMode)), (Function0<? extends Object>)new Function0<Unit>($this$switchGameMode){
                final /* synthetic */ Player $this_switchGameMode;
                {
                    this.$this_switchGameMode = $receiver;
                    super(0);
                }

                public final void invoke() {
                    PlayerUtilsKt.hearThatDing(PlayerUtilsKt.getI(PlayerUtilsKt.getThen(this.$this_switchGameMode)));
                }
            });
            PlayerUtilsKt.also(PlayerUtilsKt.getShouldAlwaysSeeTheSparkle(PlayerUtilsKt.getI($this$switchGameMode)), (Function0<? extends Object>)new Function0<Unit>($this$switchGameMode){
                final /* synthetic */ Player $this_switchGameMode;
                {
                    this.$this_switchGameMode = $receiver;
                    super(0);
                }

                public final void invoke() {
                    PlayerUtilsKt.seeThatSparkle(PlayerUtilsKt.getI(PlayerUtilsKt.getSo(this.$this_switchGameMode)));
                }
            });
            Player player = PlayerUtilsKt.getI(PlayerUtilsKt.getThen($this$switchGameMode));
            GameMode gameMode2 = PlayerUtilsKt.getMy(PlayerUtilsKt.get_for($this$switchGameMode)).getGameMode();
            Intrinsics.checkNotNullExpressionValue(gameMode2, "_for.my.gameMode");
            PlayerUtilsKt.stashMyInventory(player, gameMode2);
            Player player2 = PlayerUtilsKt.getAlso(PlayerUtilsKt.getI($this$switchGameMode));
            GameMode gameMode3 = PlayerUtilsKt.getMy(PlayerUtilsKt.get_for($this$switchGameMode)).getGameMode();
            Intrinsics.checkNotNullExpressionValue(gameMode3, "_for.my.gameMode");
            PlayerUtilsKt.stashMyPotionEffects(player2, gameMode3);
            Player player3 = PlayerUtilsKt.getI(PlayerUtilsKt.getAnd($this$switchGameMode));
            GameMode gameMode4 = PlayerUtilsKt.getMy(PlayerUtilsKt.get_for($this$switchGameMode)).getGameMode();
            Intrinsics.checkNotNullExpressionValue(gameMode4, "_for.my.gameMode");
            PlayerUtilsKt.stashMyEnderChest(player3, gameMode4);
            PlayerUtilsKt.getToo(Unit.INSTANCE);
            PlayerUtilsKt.getThat(PlayerUtilsKt.getAfter($this$switchGameMode));
            PlayerUtilsKt.getMy(PlayerUtilsKt.getSet(PlayerUtilsKt.getI($this$switchGameMode))).setGameMode(theOneItShouldBe);
            $this$switchGameMode.getInventory().clear();
            $this$switchGameMode.getEnderChest().clear();
            Collection collection = PlayerUtilsKt.getI($this$switchGameMode).getActivePotionEffects();
            Intrinsics.checkNotNullExpressionValue(collection, "I.activePotionEffects");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PotionEffect it = (PotionEffect)element$iv;
                boolean bl = false;
                $this$switchGameMode.removePotionEffect(it.getType());
            }
            PlayerUtilsKt.getMy(PlayerUtilsKt.getSet(PlayerUtilsKt.getI(PlayerUtilsKt.getAnd($this$switchGameMode)))).getInventory().setContents(PlayerUtilsKt.peekAtInventory($this$switchGameMode, theOneItShouldBe));
            PlayerUtilsKt.getMy(PlayerUtilsKt.getSet(PlayerUtilsKt.getAnd($this$switchGameMode))).getEnderChest().setContents(PlayerUtilsKt.peekAtEnderChest($this$switchGameMode, theOneItShouldBe));
            PlayerUtilsKt.getI(PlayerUtilsKt.getAnd($this$switchGameMode)).addPotionEffects((Collection)PlayerUtilsKt.peekAtEffects($this$switchGameMode, theOneItShouldBe));
            if (PlayerUtilsKt.inAir(PlayerUtilsKt.getAm(PlayerUtilsKt.getI($this$switchGameMode)))) {
                PlayerUtilsKt.preventFirstFallDamage($this$switchGameMode);
            }
        }
        new AfterGameModeChangeEvent($this$switchGameMode, theOneItWas).callEvent();
    }

    public static final void seeThatSparkle(@NotNull Player $this$seeThatSparkle) {
        Intrinsics.checkNotNullParameter($this$seeThatSparkle, "<this>");
        PlayerUtilsKt.getI($this$seeThatSparkle).spawnParticle(Particle.DRAGON_BREATH, $this$seeThatSparkle.getLocation().clone().add(PlayerUtilsKt.facingVector($this$seeThatSparkle)), 20);
    }

    public static final void hearThatDing(@NotNull Player $this$hearThatDing) {
        Intrinsics.checkNotNullParameter($this$hearThatDing, "<this>");
        PlayerUtilsKt.getI($this$hearThatDing).playSound(PlayerUtilsKt.getMy(PlayerUtilsKt.getAt($this$hearThatDing)).getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f);
    }

    private static final Object getToo(Unit $this$too) {
        return $this$too;
    }

    @NotNull
    public static final Player getSet(@NotNull Player $this$set) {
        Intrinsics.checkNotNullParameter($this$set, "<this>");
        return $this$set;
    }

    @NotNull
    public static final Player getAfter(@NotNull Player $this$after) {
        Intrinsics.checkNotNullParameter($this$after, "<this>");
        return $this$after;
    }

    @NotNull
    public static final Player getAm(@NotNull Player $this$am) {
        Intrinsics.checkNotNullParameter($this$am, "<this>");
        return $this$am;
    }

    @NotNull
    public static final Player getThat(@NotNull Player $this$that) {
        Intrinsics.checkNotNullParameter($this$that, "<this>");
        return $this$that;
    }

    @NotNull
    public static final Player getMy(@NotNull Player $this$my) {
        Intrinsics.checkNotNullParameter($this$my, "<this>");
        return $this$my;
    }

    @NotNull
    public static final Player getI(@NotNull Player $this$I) {
        Intrinsics.checkNotNullParameter($this$I, "<this>");
        return $this$I;
    }

    @NotNull
    public static final Player getSo(@NotNull Player $this$so) {
        Intrinsics.checkNotNullParameter($this$so, "<this>");
        return $this$so;
    }

    @NotNull
    public static final Player getAnd(@NotNull Player $this$and) {
        Intrinsics.checkNotNullParameter($this$and, "<this>");
        return $this$and;
    }

    @Nullable
    public static final Object andIf(boolean condition, @NotNull Function0<? extends Object> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        return condition ? op.invoke() : Unit.INSTANCE;
    }

    @Nullable
    public static final Object also(boolean condition, @NotNull Function0<? extends Object> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        return condition ? op.invoke() : Unit.INSTANCE;
    }

    @NotNull
    public static final Player getThen(@NotNull Player $this$then) {
        Intrinsics.checkNotNullParameter($this$then, "<this>");
        return $this$then;
    }

    @NotNull
    public static final Player getAt(@NotNull Player $this$at) {
        Intrinsics.checkNotNullParameter($this$at, "<this>");
        return $this$at;
    }

    @NotNull
    public static final Player getAlso(@NotNull Player $this$also) {
        Intrinsics.checkNotNullParameter($this$also, "<this>");
        return $this$also;
    }

    @NotNull
    public static final Player get_for(@NotNull Player $this$_for) {
        Intrinsics.checkNotNullParameter($this$_for, "<this>");
        return $this$_for;
    }

    public static final boolean getShouldAlwaysSeeTheSparkle(@NotNull Player $this$shouldAlwaysSeeTheSparkle) {
        Intrinsics.checkNotNullParameter($this$shouldAlwaysSeeTheSparkle, "<this>");
        return true;
    }

    private static final void preventFirstFallDamage$lambda$1(Player $this_preventFirstFallDamage, Ref.ObjectRef $taskRef, long $start) {
        block5: {
            Intrinsics.checkNotNullParameter($this_preventFirstFallDamage, "$this_preventFirstFallDamage");
            Intrinsics.checkNotNullParameter($taskRef, "$taskRef");
            if (!$this_preventFirstFallDamage.isValid() || $this_preventFirstFallDamage.isDead()) {
                BukkitTask bukkitTask = (BukkitTask)$taskRef.element;
                if (bukkitTask != null) {
                    bukkitTask.cancel();
                }
                return;
            }
            if (!$this_preventFirstFallDamage.isOnGround()) {
                $this_preventFirstFallDamage.setFallDistance(0.0f);
                if (System.currentTimeMillis() - $start > 10000L) {
                    BukkitTask bukkitTask = (BukkitTask)$taskRef.element;
                    if (bukkitTask != null) {
                        bukkitTask.cancel();
                    }
                }
                return;
            }
            $this_preventFirstFallDamage.setFallDistance(0.0f);
            BukkitTask bukkitTask = (BukkitTask)$taskRef.element;
            if (bukkitTask == null) break block5;
            bukkitTask.cancel();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockFace.values().length];
            try {
                nArray[BlockFace.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_EAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_WEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_EAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_WEST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST_NORTH_WEST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_NORTH_WEST.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_NORTH_EAST.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST_NORTH_EAST.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST_SOUTH_EAST.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_SOUTH_EAST.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_SOUTH_WEST.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST_SOUTH_WEST.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SELF.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

