/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.config.SplitWorldConfig;
import tech.snaco.split_world.types.DroppedItem;
import tech.snaco.split_world.utils.BlockUtilsKt;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.PlayerUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001fH\u0007R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltech/snaco/split_world/listener/CheatListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "droppedItems", "Ljava/util/ArrayList;", "Ltech/snaco/split_world/types/DroppedItem;", "Lkotlin/collections/ArrayList;", "onPistonExtend", "", "event", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "onPistonRetract", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "onBlockFromTo", "Lorg/bukkit/event/block/BlockFromToEvent;", "onPlayerInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onInventoryOpen", "Lorg/bukkit/event/inventory/InventoryOpenEvent;", "onPlayerDrop", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onEntityPortal", "Lorg/bukkit/event/entity/EntityPortalEvent;", "onPlayerFish", "Lorg/bukkit/event/player/PlayerFishEvent;", "onVehicleMove", "Lorg/bukkit/event/vehicle/VehicleMoveEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "SplitWorld-plugin"})
@SourceDebugExtension(value={"SMAP\nCheatListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheatListener.kt\ntech/snaco/split_world/listener/CheatListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1869#2,2:204\n*S KotlinDebug\n*F\n+ 1 CheatListener.kt\ntech/snaco/split_world/listener/CheatListener\n*L\n180#1:204,2\n*E\n"})
public final class CheatListener
implements Listener {
    @NotNull
    private final ArrayList<DroppedItem> droppedItems;

    public CheatListener(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.droppedItems = new ArrayList();
        new BukkitRunnable(){

            public void run() {
                if ((long)droppedItems.size() > 0L) {
                    ArrayList<DroppedItem> droppedItemsToStopTracking = new ArrayList<DroppedItem>();
                    Iterator iterator2 = droppedItems.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        DroppedItem droppedItem = (DroppedItem)e;
                        World world = droppedItem.getItem().getWorld();
                        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
                        if (WorldUtilsKt.isSplit(world)) {
                            Location location = droppedItem.getItem().getLocation();
                            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                            if (LocationUtilsKt.inBufferZone(location) && !LocationUtilsKt.inBufferZone(droppedItem.getPreviousLocation())) {
                                droppedItem.getCheater().sendMessage("Stop that");
                                ItemStack[] itemStackArray = new ItemStack[]{droppedItem.getItem().getItemStack()};
                                droppedItem.getCheater().getInventory().addItem(itemStackArray);
                                droppedItemsToStopTracking.add(droppedItem);
                                droppedItem.getItem().remove();
                                continue;
                            }
                        }
                        Location location = droppedItem.getItem().getLocation();
                        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                        droppedItem.setPreviousLocation(location);
                    }
                    droppedItems.removeAll(CollectionsKt.toSet((Iterable)droppedItemsToStopTracking));
                }
            }
        }.runTaskTimer(plugin, 0L, 1L);
    }

    @EventHandler
    public final void onPistonExtend(@NotNull BlockPistonExtendEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getBlock().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        BlockFace blockFace = event.getDirection();
        Intrinsics.checkNotNullExpressionValue(blockFace, "getDirection(...)");
        BlockFace dir = blockFace;
        for (Block moved : event.getBlocks()) {
            Location fromLoc;
            Location toLoc;
            Intrinsics.checkNotNullExpressionValue(moved.getLocation(), "getLocation(...)");
            Intrinsics.checkNotNullExpressionValue(moved.getRelative(dir).getLocation(), "getLocation(...)");
            if (!LocationUtilsKt.inBufferZone(toLoc) && !LocationUtilsKt.onDifferentSide(toLoc, fromLoc)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public final void onPistonRetract(@NotNull BlockPistonRetractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getBlock().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        BlockFace blockFace = event.getDirection().getOppositeFace();
        Intrinsics.checkNotNullExpressionValue(blockFace, "getOppositeFace(...)");
        BlockFace dir = blockFace;
        for (Block moved : event.getBlocks()) {
            Location fromLoc;
            Location toLoc;
            Intrinsics.checkNotNullExpressionValue(moved.getLocation(), "getLocation(...)");
            Intrinsics.checkNotNullExpressionValue(moved.getRelative(dir).getLocation(), "getLocation(...)");
            if (!LocationUtilsKt.inBufferZone(toLoc) && !LocationUtilsKt.onDifferentSide(toLoc, fromLoc)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public final void onBlockFromTo(@NotNull BlockFromToEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getBlock().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Location location = event.getToBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (LocationUtilsKt.inBufferZone(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        if (event.getClickedBlock() != null) {
            Block block = event.getClickedBlock();
            Intrinsics.checkNotNull(block);
            Location location = event.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (BlockUtilsKt.onDifferentSide(block, location)) {
                event.setCancelled(true);
            }
        }
        if (event.getInteractionPoint() != null) {
            Location location = event.getInteractionPoint();
            Intrinsics.checkNotNull(location);
            Location location2 = event.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            if (LocationUtilsKt.onDifferentSide(location, location2)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        if (event.getInventory().getLocation() != null) {
            Location location = event.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Location location2 = event.getInventory().getLocation();
            Intrinsics.checkNotNull(location2);
            if (LocationUtilsKt.onDifferentSide(location, location2)) {
                event.setCancelled(true);
            }
        }
        Location location = event.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (LocationUtilsKt.inBufferZone(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerDrop(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Location location = event.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (LocationUtilsKt.inBufferZone(location)) {
            event.setCancelled(true);
            return;
        }
        Item item = event.getItemDrop();
        Intrinsics.checkNotNullExpressionValue(item, "getItemDrop(...)");
        Location location2 = event.getItemDrop().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        GameMode gameMode = event.getPlayer().getGameMode();
        Intrinsics.checkNotNullExpressionValue(gameMode, "getGameMode(...)");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.droppedItems.add(new DroppedItem(item, location2, gameMode, player));
    }

    @EventHandler
    public final void onEntityPortal(@NotNull EntityPortalEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getFrom().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (WorldUtilsKt.isSplit(world)) {
            Location location = event.getFrom();
            Intrinsics.checkNotNullExpressionValue(location, "getFrom(...)");
            if (LocationUtilsKt.onCreativeSide(location)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void onPlayerFish(@NotNull PlayerFishEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Entity entity = event.getCaught();
        if (entity == null) {
            return;
        }
        Entity caught = entity;
        Location location = caught.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (!LocationUtilsKt.onDefaultSide(location)) {
            Location location2 = event.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            if (!LocationUtilsKt.onCreativeSide(location2)) {
                event.setCancelled(true);
            }
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (PlayerUtilsKt.getFirstFishAttempt(player)) {
            event.getPlayer().giveExp(100);
            Player player2 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
            PlayerUtilsKt.setFirstFishAttempt(player2, false);
        }
        event.getPlayer().sendMessage("Nice try.");
    }

    @EventHandler
    public final void onVehicleMove(@NotNull VehicleMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getVehicle().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Location location = event.getTo();
        Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
        if (LocationUtilsKt.inBufferZone(location, 1.0)) {
            double d;
            World world2 = event.getVehicle().getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            SplitWorldConfig config = WorldUtilsKt.splitConfig(world2);
            Location location2 = event.getFrom();
            Intrinsics.checkNotNullExpressionValue(location2, "getFrom(...)");
            boolean bl = LocationUtilsKt.onDefaultSide(location2);
            if (bl) {
                d = config.defaultSideModifier();
            } else if (!bl) {
                d = config.creativeSideModifier();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            double sideMod = d;
            Location location3 = event.getFrom().clone();
            Intrinsics.checkNotNullExpressionValue(location3, "clone(...)");
            Location tpLoc = LocationUtilsKt.setRelevantPos(location3, (config.borderWidth() + (double)2) * sideMod);
            List list = event.getVehicle().getPassengers();
            Intrinsics.checkNotNullExpressionValue(list, "getPassengers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity passenger = (Entity)element$iv;
                boolean bl2 = false;
                passenger.teleport(tpLoc);
            }
            event.getVehicle().teleport(tpLoc);
        }
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        block7: {
            double d;
            Intrinsics.checkNotNullParameter(event, "event");
            World world = event.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            if (!WorldUtilsKt.isSplit(world)) {
                return;
            }
            Location location = event.getTo();
            Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
            if (!LocationUtilsKt.inBufferZone(location, 1.0)) break block7;
            event.getPlayer().eject();
            Entity entity = event.getPlayer().getVehicle();
            if (entity != null) {
                entity.eject();
            }
            World world2 = event.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            SplitWorldConfig config = WorldUtilsKt.splitConfig(world2);
            Location location2 = event.getFrom();
            Intrinsics.checkNotNullExpressionValue(location2, "getFrom(...)");
            boolean bl = LocationUtilsKt.onDefaultSide(location2);
            if (bl) {
                d = config.defaultSideModifier();
            } else if (!bl) {
                d = config.creativeSideModifier();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            double sideMod = d;
            Location location3 = event.getFrom().clone();
            Intrinsics.checkNotNullExpressionValue(location3, "clone(...)");
            Location tpLoc = LocationUtilsKt.setRelevantPos(location3, (config.borderWidth() + (double)2) * sideMod);
            Entity entity2 = event.getPlayer().getVehicle();
            if (entity2 != null) {
                entity2.teleport(tpLoc);
            }
        }
    }
}

