/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.listener;

import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Ltech/snaco/split_world/listener/MonsterListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onCreatureSpawn", "", "event", "Lorg/bukkit/event/entity/CreatureSpawnEvent;", "onTarget", "Lorg/bukkit/event/entity/EntityTargetLivingEntityEvent;", "onEntityMove", "Lio/papermc/paper/event/entity/EntityMoveEvent;", "onEndermanEscape", "Lcom/destroystokyo/paper/event/entity/EndermanEscapeEvent;", "onSkeletonShoots", "Lorg/bukkit/event/entity/EntityShootBowEvent;", "SplitWorld-plugin"})
public final class MonsterListener
implements Listener {
    @EventHandler
    public final void onCreatureSpawn(@NotNull CreatureSpawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getLocation().getWorld();
        Intrinsics.checkNotNull(world);
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Location location = event.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (!LocationUtilsKt.onDefaultSide(location) && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL && WorldUtilsKt.splitConfig(world).noCreativeMonsters() && event.getEntity() instanceof Monster) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onTarget(@NotNull EntityTargetLivingEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        LivingEntity livingEntity = event.getTarget();
        Intrinsics.checkNotNull(livingEntity);
        Location location2 = livingEntity.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        if (LocationUtilsKt.onDifferentSide(location, location2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onEntityMove(@NotNull EntityMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        if (event.getEntity().getServer().getOnlinePlayers().isEmpty()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            return;
        }
        Location location = event.getTo();
        Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
        if (LocationUtilsKt.inBufferZone(location, 0.5)) {
            event.setCancelled(true);
        }
        if (event.getEntity() instanceof Monster) {
            Location location2 = event.getTo();
            Intrinsics.checkNotNullExpressionValue(location2, "getTo(...)");
            if (LocationUtilsKt.onCreativeSide(location2)) {
                World world2 = event.getEntity().getWorld();
                Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
                if (WorldUtilsKt.splitConfig(world2).noCreativeMonsters()) {
                    event.getEntity().remove();
                }
            }
        }
    }

    @EventHandler
    public final void onEndermanEscape(@NotNull EndermanEscapeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!WorldUtilsKt.isSplit(world)) {
            return;
        }
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (LocationUtilsKt.onCreativeSide(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onSkeletonShoots(@NotNull EntityShootBowEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity() instanceof Skeleton) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Skeleton");
            Skeleton skeleton = (Skeleton)livingEntity;
            if (skeleton.getTarget() != null) {
                LivingEntity livingEntity2 = skeleton.getTarget();
                Intrinsics.checkNotNull(livingEntity2);
                Location location = livingEntity2.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                if (!LocationUtilsKt.onDefaultSide(location)) {
                    event.setCancelled(true);
                }
            }
        }
    }
}

