/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.listener;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;
import tech.snaco.split_world.config.SplitWorldConfig;
import tech.snaco.split_world.utils.PlayerUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;
import tech.snaco.split_world.utils.WorldUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Ltech/snaco/split_world/listener/SpawnListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onSpawn", "Lorg/spigotmc/event/player/PlayerSpawnLocationEvent;", "SplitWorld-plugin"})
public final class SpawnListener
implements Listener {
    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().disableWelcomeMessage()) {
            return;
        }
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        SplitWorldConfig worldConfig = WorldUtilsKt.splitConfig(world);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!PlayerUtilsKt.getWelcomeMessageDisabled(player)) {
            event.getPlayer().sendMessage((Component)Component.text((String)StringsKt.trimIndent("\n                Hello " + event.getPlayer().getName() + "! \n                This is a split world! That means half of the world is creative, and half is survival.\n                There is a border at " + worldConfig.borderAxis() + "=" + worldConfig.borderLocation() + ".\n                Creative is on the " + worldConfig.creativeSide() + " side of the border.\n                You now have two inventories, one for each side of the border, which will be saved and restored automatically when you cross.\n                Have fun! (You can disable this message from showing using /understood) \n            ")));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().customRespawn() && !event.isAnchorSpawn() && !event.isBedSpawn()) {
            event.setRespawnLocation(ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().respawnLocation());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onSpawn(@NotNull PlayerSpawnLocationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().customRespawn()) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            if (PlayerUtilsKt.getFirstJoin(player)) {
                Player player2 = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                PlayerUtilsKt.setFirstJoin(player2, false);
                event.setSpawnLocation(ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().respawnLocation());
            }
        }
    }
}

