/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.snaco.split_world.config.SplitWorldConfig;
import tech.snaco.split_world.utils.LocationUtilsKt;
import tech.snaco.split_world.utils.PlayerUtilsKt;
import tech.snaco.split_world.utils.ServerUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00052\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Ltech/snaco/split_world/utils/CommandUtils;", "", "<init>", "()V", "onTabComplete", "", "", "command", "Lorg/bukkit/command/Command;", "args", "", "(Lorg/bukkit/command/Command;[Ljava/lang/String;)Ljava/util/List;", "preProcessCommand", "", "event", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;[Ljava/lang/String;)Z", "getCoordinates", "", "commandArgs", "([Ljava/lang/String;)Ljava/util/List;", "getLocations", "Lorg/bukkit/Location;", "coordinates", "player", "Lorg/bukkit/entity/Player;", "SplitWorld-plugin"})
@SourceDebugExtension(value={"SMAP\nCommandUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandUtils.kt\ntech/snaco/split_world/utils/CommandUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,179:1\n739#2,9:180\n37#3:189\n36#3,3:190\n536#4:193\n521#4,6:194\n*S KotlinDebug\n*F\n+ 1 CommandUtils.kt\ntech/snaco/split_world/utils/CommandUtils\n*L\n32#1:180,9\n33#1:189\n33#1:190,3\n55#1:193\n55#1:194,6\n*E\n"})
public final class CommandUtils {
    @Nullable
    public final List<String> onTabComplete(@NotNull Command command, @Nullable String[] args) {
        Intrinsics.checkNotNullParameter(command, "command");
        if (StringsKt.equals(command.getName(), "play-border-sound", true)) {
            Intrinsics.checkNotNull(args);
            if (args.length == 1) {
                String[] stringArray = new String[]{"true", "false"};
                return CollectionsKt.listOf(stringArray);
            }
        }
        if (StringsKt.equals(command.getName(), "play-border-sound", true)) {
            Intrinsics.checkNotNull(args);
            if (args.length > 1) {
                return new ArrayList();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void preProcessCommand(@NotNull PlayerCommandPreprocessEvent event) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().manageCreativeCommands() || event.getPlayer().isOp()) {
            return;
        }
        List<String> creativeCommands = ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().creativeCommands();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = event.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String commandStr = string;
        Object object = commandStr;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] commandArgs = thisCollection$iv.toArray(new String[0]);
        if (commandArgs.length < 3) {
            return;
        }
        if (!creativeCommands.contains(commandArgs[0])) {
            return;
        }
        if (player2.getGameMode() == GameMode.SURVIVAL) {
            player2.sendMessage("You cannot use the " + commandArgs[0] + " command in survival.");
            event.setCancelled(true);
            return;
        }
        List<Double> list2 = this.getCoordinates(commandArgs);
        if (list2 == null) {
            return;
        }
        List<Double> coordinates = list2;
        List<Location> list3 = this.getLocations(coordinates, player2);
        if (list3 == null) {
            return;
        }
        List<Location> locations = list3;
        for (Location location : locations) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            if (LocationUtilsKt.onCreativeSide(location)) continue;
            Map<World, SplitWorldConfig> bl = ServerUtilsKt.splitWorldPlugin().getSplitServerConfig().worldConfigs();
            boolean $i$f$filter = false;
            void var12_17 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!((SplitWorldConfig)it.getValue()).enabled()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            if (!(!destination$iv$iv.isEmpty())) continue;
            player2.sendMessage("The " + commandArgs[0] + " command cannot include blocks outside the creative side of this world");
            event.setCancelled(true);
            return;
        }
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @Nullable String[] args) {
        Player player;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        String string = sender.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        Player player2 = player = sender.getServer().getPlayer(playerName);
        Intrinsics.checkNotNull(player2);
        PersistentDataContainer persistentDataContainer = player2.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer playerPdc = persistentDataContainer;
        if (StringsKt.equals(command.getName(), "play-border-sound", true)) {
            Intrinsics.checkNotNull(args);
            if (args.length != 1) {
                return false;
            }
            if (StringsKt.equals(args[0], "true", true)) {
                PlayerUtilsKt.setShouldHearTheDing(player, true);
            } else if (StringsKt.equals(args[0], "false", true)) {
                PlayerUtilsKt.setShouldHearTheDing(player, false);
            } else {
                return false;
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "set-spawn-builder", true)) {
            Server server = player.getServer();
            Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
            Server server2 = server;
            Intrinsics.checkNotNull(args);
            if (args.length != 2) {
                return false;
            }
            Player player3 = server2.getPlayer(args[0]);
            if (player3 == null) {
                return false;
            }
            Player targetPlayer = player3;
            if (StringsKt.equals(args[1], "true", true)) {
                PlayerUtilsKt.setSpawnBuilder(player, true);
                System.out.println((Object)(targetPlayer.getName() + "is now a spawn builder."));
                targetPlayer.sendMessage("You now have permission to build in the spawn area.");
            } else if (StringsKt.equals(args[1], "false", true)) {
                PlayerUtilsKt.setSpawnBuilder(player, false);
                System.out.println((Object)(targetPlayer.getName() + "is no longer a spawn builder."));
                targetPlayer.sendMessage("You no longer have permission to build in the spawn area.");
            } else {
                return false;
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "understood", true)) {
            PlayerUtilsKt.setWelcomeMessageDisabled(player, true);
            player.sendMessage("You will no longer see the welcome message for split world.");
            return true;
        }
        if (StringsKt.equals(command.getName(), "disable-split-world", true)) {
            if (player.hasPermission("split-world.disable-split-world")) {
                PlayerUtilsKt.setSplitWorldDisabled(player, true);
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "enable-split-world", true)) {
            if (player.hasPermission("split-world.enable-split-world")) {
                PlayerUtilsKt.setSplitWorldDisabled(player, false);
            }
            PlayerUtilsKt.switchToConfiguredGameMode(player);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Double> getCoordinates(String[] commandArgs) {
        int n;
        ArrayList args = new ArrayList(CollectionsKt.listOf(Arrays.copyOf(commandArgs, commandArgs.length)));
        String command = (String)args.remove(0);
        if (args.isEmpty()) {
            return null;
        }
        String string = command;
        if (string == null) return null;
        int n2 = -1;
        switch (string.hashCode()) {
            case 46548530: {
                if (string.equals("/fill")) {
                    n2 = 1;
                }
                break;
            }
            case 1440326286: {
                if (string.equals("/clone")) {
                    n2 = 2;
                }
                break;
            }
            case -1927883110: {
                if (string.equals("/setblock")) {
                    n2 = 3;
                }
                break;
            }
        }
        switch (n2) {
            case 1: {
                n = 6;
                break;
            }
            case 2: {
                n = 9;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                return null;
            }
        }
        int coordinateCount = n;
        if (coordinateCount == -1) {
            return null;
        }
        if (args.size() < coordinateCount) {
            return null;
        }
        List coordinates = new ArrayList();
        int i = 0;
        while (i < coordinateCount) {
            if (Intrinsics.areEqual(args.get(i), "~")) {
                v1 = coordinates.add(null);
            } else {
                Object e = args.get(i);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                v1 = coordinates.add(Double.parseDouble((String)e));
            }
            ++i;
        }
        return CollectionsKt.toList(coordinates);
    }

    private final List<Location> getLocations(List<Double> coordinates, Player player) {
        int size = coordinates.size();
        if (size < 3 || size % 3 != 0) {
            return null;
        }
        List locations = new ArrayList();
        int n = size / 3;
        for (int i = 0; i < n; ++i) {
            double d;
            double y;
            double x;
            int index = i * 3;
            if (coordinates.get(index) == null) {
                v0 = player.getLocation().getX();
            } else {
                Double d2 = coordinates.get(index);
                Intrinsics.checkNotNull(d2);
                v0 = x = ((Number)d2).doubleValue();
            }
            if (coordinates.get(index + 1) == null) {
                v2 = player.getLocation().getY();
            } else {
                Double d3 = coordinates.get(index + 1);
                Intrinsics.checkNotNull(d3);
                v2 = y = ((Number)d3).doubleValue();
            }
            if (coordinates.get(index + 2) == null) {
                d = player.getLocation().getZ();
            } else {
                Double d4 = coordinates.get(index + 2);
                Intrinsics.checkNotNull(d4);
                d = ((Number)d4).doubleValue();
            }
            double z = d;
            locations.add(new Location(player.getWorld(), x, y, z));
        }
        return locations;
    }
}

