/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import tech.snaco.split_world.SplitWorldKeys;
import tech.snaco.split_world.Utils;
import tech.snaco.split_world.types.ItemStackArrayDataType;
import tech.snaco.split_world.types.PotionEffectArrayDataType;
import tech.snaco.split_world.types.WorldConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltech/snaco/split_world/PlayerUtils;", "", "utils", "Ltech/snaco/split_world/Utils;", "keys", "Ltech/snaco/split_world/SplitWorldKeys;", "defaultGameMode", "Lorg/bukkit/GameMode;", "<init>", "(Ltech/snaco/split_world/Utils;Ltech/snaco/split_world/SplitWorldKeys;Lorg/bukkit/GameMode;)V", "switchPlayerToConfiguredGameMode", "", "player", "Lorg/bukkit/entity/Player;", "switchPlayerGameMode", "gameMode", "savePlayerInventory", "loadPlayerInventory", "convertBufferZoneBlocksAroundPlayer", "warpPlayerToGround", "toLocation", "Lorg/bukkit/Location;", "getFacingVector", "Lorg/bukkit/util/Vector;", "playerInAir", "", "SplitWorld-plugin"})
@SourceDebugExtension(value={"SMAP\nPlayerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerUtils.kt\ntech/snaco/split_world/PlayerUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,192:1\n37#2:193\n36#2,3:194\n*S KotlinDebug\n*F\n+ 1 PlayerUtils.kt\ntech/snaco/split_world/PlayerUtils\n*L\n71#1:193\n71#1:194,3\n*E\n"})
public final class PlayerUtils {
    @NotNull
    private Utils utils;
    @NotNull
    private SplitWorldKeys keys;
    @NotNull
    private GameMode defaultGameMode;

    public PlayerUtils(@NotNull Utils utils, @NotNull SplitWorldKeys keys2, @NotNull GameMode defaultGameMode) {
        Intrinsics.checkNotNullParameter(utils, "utils");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        Intrinsics.checkNotNullParameter(defaultGameMode, "defaultGameMode");
        this.utils = utils;
        this.keys = keys2;
        this.defaultGameMode = defaultGameMode;
    }

    public final void switchPlayerToConfiguredGameMode(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            this.switchPlayerGameMode(player, this.defaultGameMode);
            return;
        }
        if (this.utils.playerInBufferZone(player)) {
            this.switchPlayerGameMode(player, GameMode.ADVENTURE);
            player.setAllowFlight(true);
            if (player.isGliding() || player.isFlying()) {
                player.setFlying(true);
            }
            player.setFoodLevel(player.getFoodLevel());
            player.setHealth(player.getHealth());
        } else if (this.utils.playerOnCreativeSide(player)) {
            this.switchPlayerGameMode(player, GameMode.CREATIVE);
        } else {
            this.switchPlayerGameMode(player, GameMode.SURVIVAL);
        }
    }

    public final void switchPlayerGameMode(@NotNull Player player, @NotNull GameMode gameMode) {
        block2: {
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter(player, "player");
                    Intrinsics.checkNotNullParameter(gameMode, "gameMode");
                    if (player.getGameMode() == gameMode) break block2;
                    Integer playSound = (Integer)player.getPersistentDataContainer().get(this.keys.getPlayBorderSound(), PersistentDataType.INTEGER);
                    if (playSound == null) break block3;
                    int n = 1;
                    if (playSound != n) break block4;
                }
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f);
            }
            Vector facingVector = this.getFacingVector(player);
            player.getWorld().spawnParticle(Particle.DRAGON_BREATH, player.getLocation().clone().add(facingVector), 20);
            this.savePlayerInventory(player);
            player.getInventory().clear();
            player.setGameMode(gameMode);
            this.loadPlayerInventory(player);
        }
    }

    public final void savePlayerInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.getPersistentDataContainer().set(this.keys.getPlayerInventoryKey(player), (PersistentDataType)new ItemStackArrayDataType(), (Object)player.getInventory().getContents());
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        NamespacedKey namespacedKey = this.keys.getPlayerEffectsKey(player);
        PersistentDataType persistentDataType = new PotionEffectArrayDataType();
        Collection collection = player.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        persistentDataContainer.set(namespacedKey, persistentDataType, (Object)thisCollection$iv.toArray(new PotionEffect[0]));
        player.getPersistentDataContainer().set(this.keys.getPlayerEnderChestContentsKey(player), (PersistentDataType)new ItemStackArrayDataType(), (Object)player.getEnderChest().getContents());
    }

    public final void loadPlayerInventory(@NotNull Player player) {
        ItemStack[] enderChestContents;
        PotionEffect[] effects;
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack[] inventoryContents = (ItemStack[])player.getPersistentDataContainer().get(this.keys.getPlayerInventoryKey(player), (PersistentDataType)new ItemStackArrayDataType());
        if (inventoryContents != null) {
            player.getInventory().setContents(inventoryContents);
        }
        if ((effects = (PotionEffect[])player.getPersistentDataContainer().get(this.keys.getPlayerEffectsKey(player), (PersistentDataType)new PotionEffectArrayDataType())) != null) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            Iterator<Object> iterator2 = ArrayIteratorKt.iterator(effects);
            while (iterator2.hasNext()) {
                PotionEffect effect;
                effect = (PotionEffect)iterator2.next();
                player.addPotionEffect(effect);
            }
        }
        if ((enderChestContents = (ItemStack[])player.getPersistentDataContainer().get(this.keys.getPlayerEnderChestContentsKey(player), (PersistentDataType)new ItemStackArrayDataType())) != null) {
            player.getEnderChest().setContents(enderChestContents);
        }
    }

    public final void convertBufferZoneBlocksAroundPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        WorldConfig worldConfig = this.utils.getWorldConfig(world2);
        Location location = player.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location playerLocation = location;
        int n = worldConfig.borderLocation + worldConfig.borderWidth / 2;
        for (int i = worldConfig.borderLocation - worldConfig.borderWidth / 2; i < n; ++i) {
            for (int j = -5; j < 5; ++j) {
                for (int y = -64; y < 319; ++y) {
                    Material blockType;
                    Location loc;
                    Intrinsics.checkNotNullExpressionValue(playerLocation.clone(), "clone(...)");
                    loc.setY((double)y);
                    if (Intrinsics.areEqual(worldConfig.borderAxis, "X")) {
                        loc.setX((double)i);
                        loc.setZ(loc.getZ() + (double)j);
                    } else {
                        loc.setZ((double)i);
                        loc.setX(loc.getX() + (double)j);
                    }
                    Intrinsics.checkNotNullExpressionValue(world2.getBlockAt(loc).getType(), "getType(...)");
                    if (blockType != Material.AIR && blockType != Material.WATER && blockType != Material.LAVA) {
                        world2.getBlockAt(loc).setType(Material.BEDROCK);
                        continue;
                    }
                    if (blockType != Material.WATER && blockType != Material.LAVA) continue;
                    world2.getBlockAt(loc).setType(Material.AIR);
                }
            }
        }
    }

    public final void warpPlayerToGround(@NotNull Player player, @NotNull Location toLocation) {
        Location location;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(toLocation, "toLocation");
        Location location2 = toLocation.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location location3 = location2;
        Block block = player.getWorld().getHighestBlockAt(location3.getBlockX(), location3.getBlockZ());
        Intrinsics.checkNotNullExpressionValue(block, "getHighestBlockAt(...)");
        Block top = block;
        float pitch = location3.getPitch();
        float yaw = location3.getYaw();
        if (location3.getBlock().getType() == Material.AIR && location3.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR) {
            location = this.utils.closestSolidBlockBelowLocation(this.utils.addToRelevantPos(location3, 0.5)).add(0.0, 1.0, 0.0);
        } else {
            Location location4 = top.getLocation();
            Intrinsics.checkNotNullExpressionValue(location4, "getLocation(...)");
            location = this.utils.addToRelevantPos(location4, 0.5).add(0.0, 1.0, 0.0);
        }
        Location location5 = location;
        Intrinsics.checkNotNull(location5);
        Location destination = location5;
        destination.setPitch(pitch);
        destination.setYaw(yaw);
        player.teleport(destination);
    }

    private final Vector getFacingVector(Player player) {
        double y = 1.5;
        return switch (WhenMappings.$EnumSwitchMapping$0[player.getFacing().ordinal()]) {
            case 1 -> new Vector(0.0, y, -1.0);
            case 2 -> new Vector(0.0, y, 1.0);
            case 3 -> new Vector(1.0, y, 0.0);
            case 4 -> new Vector(-1.0, y, 0.0);
            case 5 -> new Vector(0.0, y + 1.0, 0.0);
            case 6 -> new Vector(0.0, y - 1.0, 0.0);
            case 7 -> new Vector(1.0, y, -1.0);
            case 8 -> new Vector(-1.0, y, -1.0);
            case 9 -> new Vector(1.0, y, 1.0);
            case 10 -> new Vector(-1.0, y, 1.0);
            case 11 -> new Vector(-1.0, y, -0.5);
            case 12 -> new Vector(-0.5, y, -1.0);
            case 13 -> new Vector(0.5, y, -1.0);
            case 14 -> new Vector(1.0, y, -0.5);
            case 15 -> new Vector(1.0, y, 0.5);
            case 16 -> new Vector(0.5, y, 1.0);
            case 17 -> new Vector(-0.5, y, 1.0);
            case 18 -> new Vector(-1.0, y, 0.5);
            case 19 -> new Vector(0, 0, 0);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean playerInAir(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Location location = player.getLocation().clone().add(0.0, -1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location underFeet = location;
        return underFeet.getBlock().getType() == Material.AIR && player.getLocation().getBlock().getType() == Material.AIR;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockFace.values().length];
            try {
                nArray[BlockFace.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_EAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_WEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_EAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_WEST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST_NORTH_WEST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_NORTH_WEST.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH_NORTH_EAST.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST_NORTH_EAST.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST_SOUTH_EAST.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_SOUTH_EAST.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH_SOUTH_WEST.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST_SOUTH_WEST.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SELF.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

