/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world;

import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerBedFailEnterEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;
import tech.snaco.split_world.PlayerUtils;
import tech.snaco.split_world.SplitWorldCommands;
import tech.snaco.split_world.SplitWorldKeys;
import tech.snaco.split_world.Utils;
import tech.snaco.split_world.extras.easter_eggs.Messages;
import tech.snaco.split_world.types.WorldConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\"\u001a\u00020#H\u0016J3\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0+H\u0016\u00a2\u0006\u0002\u0010,J;\u0010-\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010.2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0+H\u0016\u00a2\u0006\u0002\u0010/J\u0012\u00100\u001a\u00020#2\b\u00101\u001a\u0004\u0018\u000102H\u0007J\u0010\u00103\u001a\u00020#2\u0006\u00101\u001a\u000204H\u0007J\u0010\u00105\u001a\u00020#2\u0006\u00101\u001a\u000206H\u0007J\u0010\u00107\u001a\u00020#2\u0006\u00101\u001a\u000208H\u0007J\u0010\u00109\u001a\u00020#2\u0006\u00101\u001a\u00020:H\u0007J\u0010\u0010;\u001a\u00020#2\u0006\u00101\u001a\u00020<H\u0007J\u0010\u0010=\u001a\u00020#2\u0006\u00101\u001a\u00020>H\u0007J\u0010\u0010?\u001a\u00020#2\u0006\u00101\u001a\u00020@H\u0007J\u0010\u0010A\u001a\u00020#2\u0006\u00101\u001a\u00020BH\u0007J\u0010\u0010C\u001a\u00020#2\u0006\u00101\u001a\u00020DH\u0007J\u0010\u0010E\u001a\u00020#2\u0006\u00101\u001a\u00020FH\u0007J\u0010\u0010G\u001a\u00020#2\u0006\u00101\u001a\u00020HH\u0007J\u0010\u0010I\u001a\u00020#2\u0006\u00101\u001a\u00020JH\u0007J\u0010\u0010K\u001a\u00020#2\u0006\u00101\u001a\u00020LH\u0007J\u0010\u0010M\u001a\u00020#2\u0006\u00101\u001a\u00020NH\u0007J\u0010\u0010O\u001a\u00020#2\u0006\u00101\u001a\u00020PH\u0007J\u0010\u0010Q\u001a\u00020#2\u0006\u00101\u001a\u00020RH\u0007J\u0010\u0010S\u001a\u00020#2\u0006\u00101\u001a\u00020TH\u0007J\u0010\u0010U\u001a\u00020#2\u0006\u00101\u001a\u00020VH\u0007J\u0010\u0010W\u001a\u00020#2\u0006\u00101\u001a\u00020XH\u0007J\u0010\u0010Y\u001a\u00020#2\u0006\u00101\u001a\u00020ZH\u0007J\u0010\u0010[\u001a\u00020#2\u0006\u00101\u001a\u00020\\H\u0007J\u0010\u0010]\u001a\u00020#2\u0006\u00101\u001a\u00020^H\u0007J\u0010\u0010_\u001a\u00020#2\u0006\u00101\u001a\u00020`H\u0007J\u0010\u0010a\u001a\u00020#2\u0006\u00101\u001a\u00020bH\u0007J\u0010\u0010c\u001a\u00020#2\u0006\u00101\u001a\u00020dH\u0007J\u0010\u0010e\u001a\u00020#2\u0006\u00101\u001a\u00020fH\u0007J)\u0010g\u001a\u00020#\"\f\b\u0000\u0010h*\u00020i*\u00020j2\u0006\u00101\u001a\u0002Hh2\u0006\u0010k\u001a\u00020\u001b\u00a2\u0006\u0002\u0010lR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Ltech/snaco/split_world/SplitWorld;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "defaultGameMode", "Lorg/bukkit/GameMode;", "worldConfigs", "", "", "Ltech/snaco/split_world/types/WorldConfig;", "keys", "Ltech/snaco/split_world/SplitWorldKeys;", "droppedItems", "Ljava/util/ArrayList;", "Lorg/bukkit/entity/Item;", "Lkotlin/collections/ArrayList;", "utils", "Ltech/snaco/split_world/Utils;", "playerUtils", "Ltech/snaco/split_world/PlayerUtils;", "commandHandler", "Ltech/snaco/split_world/SplitWorldCommands;", "playersSleepingInNether", "Ljava/util/HashSet;", "Lorg/bukkit/entity/Player;", "Lkotlin/collections/HashSet;", "easterEggsEnabled", "", "xpModEnabled", "xpLossPercentage", "", "onEnable", "", "onCommand", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "preProcessCommand", "event", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onHealthRegain", "Lorg/bukkit/event/entity/EntityRegainHealthEvent;", "onBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onPlayerRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onBlockFromTo", "Lorg/bukkit/event/block/BlockFromToEvent;", "onEntityPortal", "Lorg/bukkit/event/entity/EntityPortalEvent;", "onItemSpawn", "Lorg/bukkit/event/entity/ItemSpawnEvent;", "onEndermanEscape", "Lcom/destroystokyo/paper/event/entity/EndermanEscapeEvent;", "onEntityMove", "Lio/papermc/paper/event/entity/EntityMoveEvent;", "onTarget", "Lorg/bukkit/event/entity/EntityTargetLivingEntityEvent;", "onCreatureSpawn", "Lorg/bukkit/event/entity/CreatureSpawnEvent;", "onPickup", "Lorg/bukkit/event/player/PlayerAttemptPickupItemEvent;", "onSpawn", "Lorg/spigotmc/event/player/PlayerSpawnLocationEvent;", "onPlayerFish", "Lorg/bukkit/event/player/PlayerFishEvent;", "playerHunger", "Lorg/bukkit/event/entity/FoodLevelChangeEvent;", "onSkeletonShoots", "Lorg/bukkit/event/entity/EntityShootBowEvent;", "itemInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "enterBed", "Lorg/bukkit/event/player/PlayerBedEnterEvent;", "failEnterBed", "Lio/papermc/paper/event/player/PlayerBedFailEnterEvent;", "enterDeepSleep", "Lio/papermc/paper/event/player/PlayerDeepSleepEvent;", "leaveBed", "Lorg/bukkit/event/player/PlayerBedLeaveEvent;", "handleBlockEvent", "T", "Lorg/bukkit/event/block/BlockEvent;", "Lorg/bukkit/event/Cancellable;", "player", "(Lorg/bukkit/event/block/BlockEvent;Lorg/bukkit/entity/Player;)V", "SplitWorld-plugin"})
public final class SplitWorld
extends JavaPlugin
implements Listener {
    @NotNull
    private FileConfiguration config;
    @NotNull
    private GameMode defaultGameMode;
    @NotNull
    private Map<String, WorldConfig> worldConfigs;
    @NotNull
    private SplitWorldKeys keys;
    @NotNull
    private ArrayList<Item> droppedItems;
    @NotNull
    private Utils utils;
    @NotNull
    private PlayerUtils playerUtils;
    @NotNull
    private SplitWorldCommands commandHandler;
    @NotNull
    private HashSet<Player> playersSleepingInNether;
    private boolean easterEggsEnabled;
    private boolean xpModEnabled;
    private double xpLossPercentage;

    /*
     * Unable to fully structure code
     */
    public SplitWorld() {
        block8: {
            block6: {
                block7: {
                    super();
                    v0 = this.getConfig();
                    Intrinsics.checkNotNullExpressionValue(v0, "getConfig(...)");
                    this.config = v0;
                    var1_1 = this.config.getString("default_game_mode");
                    if (var1_1 == null) break block6;
                    switch (var1_1.hashCode()) {
                        case -694094064: {
                            if (var1_1.equals("adventure")) break;
                            ** break;
                        }
                        case -1684593425: {
                            if (!var1_1.equals("spectator")) {
                                ** break;
                            }
                            break block7;
                        }
                        case 1820422063: {
                            if (!var1_1.equals("creative")) ** break;
                            v1 = GameMode.CREATIVE;
                            break block8;
                        }
                    }
                    v1 = GameMode.ADVENTURE;
                    break block8;
                }
                v1 = GameMode.SPECTATOR;
                break block8;
            }
            v1 = GameMode.SURVIVAL;
        }
        this.defaultGameMode = v1;
        v2 = this.config.getList("world_configs");
        Intrinsics.checkNotNull(v2);
        var1_1 = v2.stream().map((Function<Object, WorldConfig>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, worldConfigs$lambda$0(java.lang.Object ), (Ljava/lang/Object;)Ltech/snaco/split_world/types/WorldConfig;)()).collect(Collectors.toMap((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, worldConfigs$lambda$2(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)((Function1<WorldConfig, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, worldConfigs$lambda$1(tech.snaco.split_world.types.WorldConfig ), (Ltech/snaco/split_world/types/WorldConfig;)Ljava/lang/String;)()), (Function<Object, WorldConfig>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, worldConfigs$lambda$4(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ltech/snaco/split_world/types/WorldConfig;)((Function1<WorldConfig, WorldConfig>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, worldConfigs$lambda$3(tech.snaco.split_world.types.WorldConfig ), (Ltech/snaco/split_world/types/WorldConfig;)Ltech/snaco/split_world/types/WorldConfig;)())));
        Intrinsics.checkNotNullExpressionValue(var1_1, "collect(...)");
        this.worldConfigs = (Map)var1_1;
        this.keys = new SplitWorldKeys(this);
        this.droppedItems = new ArrayList<E>();
        this.utils = new Utils(this.worldConfigs);
        this.playerUtils = new PlayerUtils(this.utils, this.keys, this.defaultGameMode);
        this.commandHandler = new SplitWorldCommands(this.keys, this.playerUtils, this.worldConfigs, this.config.getBoolean("manage_creative_commands", true));
        this.playersSleepingInNether = new HashSet<E>();
        this.easterEggsEnabled = this.config.getBoolean("easter_eggs_enabled", false);
        this.xpModEnabled = this.config.getBoolean("xp_mod_enabled", false);
        this.xpLossPercentage = this.config.getDouble("xp_loss_percentage", 25.0);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(this){
            final /* synthetic */ SplitWorld this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                if ((long)SplitWorld.access$getDroppedItems$p(this.this$0).size() > 0L) {
                    ArrayList<Item> itemsToRemove = new ArrayList<Item>();
                    Iterator<E> iterator2 = SplitWorld.access$getDroppedItems$p(this.this$0).iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                    Iterator<E> iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        E e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        Item item = (Item)e;
                        Utils utils = SplitWorld.access$getUtils$p(this.this$0);
                        World world = item.getWorld();
                        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
                        if (!utils.worldEnabled(world)) continue;
                        Utils utils2 = SplitWorld.access$getUtils$p(this.this$0);
                        Location location = item.getLocation();
                        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                        if (!utils2.locationInBufferZone(location)) continue;
                        item.remove();
                        itemsToRemove.add(item);
                    }
                    SplitWorld.access$getDroppedItems$p(this.this$0).removeAll((Collection)CollectionsKt.toSet((Iterable)itemsToRemove));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
        if (this.easterEggsEnabled) {
            new BukkitRunnable(this){
                final /* synthetic */ SplitWorld this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    Messages.INSTANCE.runNetherSleepTask(SplitWorld.access$getPlayersSleepingInNether$p(this.this$0), SplitWorld.access$getKeys$p(this.this$0));
                }
            }.runTaskTimer((Plugin)this, 20L, 1L);
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        return this.commandHandler.onCommand(sender, command, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        return this.commandHandler.onTabComplete(command, args);
    }

    @EventHandler
    public final void preProcessCommand(@Nullable PlayerCommandPreprocessEvent event) {
        PlayerCommandPreprocessEvent playerCommandPreprocessEvent = event;
        Intrinsics.checkNotNull(playerCommandPreprocessEvent);
        this.commandHandler.preProcessCommand(playerCommandPreprocessEvent);
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Integer noWelcome;
        Player player;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(event, "event");
                boolean welcomeMessageDisabled = this.config.getBoolean("disable_welcome_message");
                if (welcomeMessageDisabled) {
                    return;
                }
                Player player2 = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                player = player2;
                PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                PersistentDataContainer playerPdc = persistentDataContainer;
                String string = player.getWorld().getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                String worldName = string;
                noWelcome = (Integer)playerPdc.get(this.keys.getNoWelcome(), PersistentDataType.INTEGER);
                if (!this.worldConfigs.containsKey(worldName)) break block5;
                WorldConfig worldConfig = this.worldConfigs.get(worldName);
                Intrinsics.checkNotNull(worldConfig);
                if (worldConfig.enabled) break block6;
            }
            return;
        }
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.utils.getWorldConfig(world);
        if (noWelcome == null) {
            player.sendMessage((Component)Component.text((String)StringsKt.trimIndent("\n                Hello " + player.getName() + "! \n                This is a split world! That means half of the world is creative, and half is survival.\n                There is a border at " + worldConfig.borderAxis + "=" + worldConfig.borderLocation + ".\n                Creative is on the " + worldConfig.creativeSide + " side of the border.\n                You now have two inventories, one for each side of the border, which will be saved and restored automatically when you cross.\n                Have fun! (You can disable this message from showing using /understood) \n            ")));
        }
    }

    @EventHandler
    public final void onPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        BlockEvent blockEvent = (BlockEvent)event;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.handleBlockEvent(blockEvent, player);
    }

    @EventHandler
    public final void onDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.easterEggsEnabled) {
            this.playersSleepingInNether.remove(event.getPlayer());
        }
        if (this.xpModEnabled) {
            event.setDroppedExp(event.getPlayer().getTotalExperience() - (int)((double)event.getPlayer().getTotalExperience() * (this.xpLossPercentage / (double)100)));
        }
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.utils.locationInBufferZone(location)) {
            event.getPlayer().setHealth(0.1);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onHealthRegain(@NotNull EntityRegainHealthEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.utils.locationInBufferZone(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        BlockEvent blockEvent = (BlockEvent)event;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.handleBlockEvent(blockEvent, player);
    }

    @EventHandler
    public final void onTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Location location = event.getTo();
        Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
        Location destination = location;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = destination.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            this.playerUtils.switchPlayerGameMode(player2, this.defaultGameMode);
            return;
        }
        if (this.utils.locationInBufferZone(destination)) {
            this.playerUtils.switchPlayerGameMode(player2, GameMode.SPECTATOR);
            return;
        }
        if (this.utils.locationOnCreativeSide(destination)) {
            this.playerUtils.switchPlayerGameMode(player2, GameMode.CREATIVE);
            return;
        }
        boolean needsWarp = player2.getGameMode() != GameMode.SURVIVAL;
        this.playerUtils.switchPlayerGameMode(player2, GameMode.SURVIVAL);
        if (needsWarp) {
            Location location2 = player2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            this.playerUtils.warpPlayerToGround(player2, location2);
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        block10: {
            Intrinsics.checkNotNullParameter(event, "event");
            v0 = event.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue(v0, "getWorld(...)");
            if (!this.utils.worldEnabled(v0)) {
                return;
            }
            v1 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(v1, "getPlayer(...)");
            player = v1;
            v2 = player.getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v2, "getPersistentDataContainer(...)");
            playerPdc = v2;
            disabled = (Integer)playerPdc.get(this.keys.getSplitWorldDisabled(), PersistentDataType.INTEGER);
            if (disabled != null) {
                var5_5 = 1;
                if (disabled == var5_5) {
                    return;
                }
            }
            if (player.getGameMode() == GameMode.SURVIVAL) break block10;
            v3 = event.getTo();
            Intrinsics.checkNotNullExpressionValue(v3, "getTo(...)");
            if (!this.utils.locationOnSurvivalSide(v3)) break block10;
            v4 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(v4, "getLocation(...)");
            if (!this.utils.locationOnSurvivalSide(v4)) break block10;
            this.playerUtils.loadPlayerInventory(player);
            if (player.getInventory().getChestplate() == null) ** GOTO lbl-1000
            v5 = player.getInventory().getChestplate();
            Intrinsics.checkNotNull(v5);
            if (v5.getType() == Material.ELYTRA) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            playerHasElytraEquipped = v6;
            player.getInventory().clear();
            player.getEnderChest().getContents();
            if (playerHasElytraEquipped && player.getLocation().getBlock().getType() == Material.AIR) {
                player.setGliding(true);
            }
            if (!playerHasElytraEquipped) {
                v7 = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(v7, "getLocation(...)");
                if (this.utils.locationOnSurvivalSide(v7) && this.playerUtils.playerInAir(player)) {
                    player.setVelocity(new Vector(0, 0, 0));
                    v8 = player.getLocation();
                    Intrinsics.checkNotNullExpressionValue(v8, "getLocation(...)");
                    this.playerUtils.warpPlayerToGround(player, v8);
                }
            }
        }
        this.playerUtils.switchPlayerToConfiguredGameMode(player);
        if (this.utils.playerInBufferZone(player)) {
            player.getInventory().clear();
            v9 = event.getTo();
            Intrinsics.checkNotNullExpressionValue(v9, "getTo(...)");
            nextLocation = v9;
            if (!this.utils.locationIsTraversable(nextLocation)) {
                event.setCancelled(true);
            }
        }
        this.playerUtils.convertBufferZoneBlocksAroundPlayer(player);
    }

    @EventHandler
    public final void onPlayerWorldChange(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.playerUtils.switchPlayerToConfiguredGameMode(player);
    }

    @EventHandler
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        boolean customRespawn = this.config.getBoolean("custom_respawn", false);
        List<Double> coordinates = this.utils.getSpawnCoordinates(this.config);
        if (customRespawn && !event.isAnchorSpawn() && !event.isBedSpawn()) {
            event.setRespawnLocation(new Location(event.getRespawnLocation().getWorld(), ((Number)coordinates.get(0)).doubleValue(), ((Number)coordinates.get(1)).doubleValue(), ((Number)coordinates.get(2)).doubleValue(), -88.0f, 6.0f));
        }
        Location location = event.getRespawnLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getRespawnLocation(...)");
        if (this.utils.locationOnSurvivalSide(location)) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            this.playerUtils.switchPlayerGameMode(player, GameMode.SURVIVAL);
        } else {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            this.playerUtils.switchPlayerGameMode(player, GameMode.CREATIVE);
        }
    }

    @EventHandler
    public final void onBlockFromTo(@NotNull BlockFromToEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getBlock().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getToBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.utils.locationInBufferZone(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onEntityPortal(@NotNull EntityPortalEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getFrom().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getFrom();
        Intrinsics.checkNotNullExpressionValue(location, "getFrom(...)");
        if (this.utils.locationOnCreativeSide(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onItemSpawn(@NotNull ItemSpawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        this.droppedItems.add(event.getEntity());
    }

    @EventHandler
    public final void onEndermanEscape(@NotNull EndermanEscapeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.utils.locationOnCreativeSide(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onEntityMove(@NotNull EntityMoveEvent event) {
        Location entityNextLocation;
        LivingEntity entity;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter(event, "event");
                World world = event.getEntity().getWorld();
                Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
                if (!this.utils.worldEnabled(world)) {
                    return;
                }
                LivingEntity livingEntity = event.getEntity();
                Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
                entity = livingEntity;
                Location location = event.getTo();
                Intrinsics.checkNotNullExpressionValue(location, "getTo(...)");
                entityNextLocation = location;
                String string = entityNextLocation.getWorld().getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                String entityWorldName = string;
                if (entity.getServer().getOnlinePlayers().isEmpty()) {
                    return;
                }
                if (entity instanceof Player) {
                    return;
                }
                if (!this.worldConfigs.containsKey(entityWorldName)) break block9;
                WorldConfig worldConfig = this.worldConfigs.get(entityWorldName);
                Intrinsics.checkNotNull(worldConfig);
                if (worldConfig.enabled) break block10;
            }
            return;
        }
        if (this.utils.locationInBufferZone(entityNextLocation)) {
            event.setCancelled(true);
        }
        if (entity instanceof Monster && this.utils.locationOnCreativeSide(entityNextLocation)) {
            World world = ((Monster)entity).getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            if (this.utils.getWorldConfig((World)world).noCreativeMonsters) {
                entity.remove();
            }
        }
    }

    @EventHandler
    public final void onTarget(@NotNull EntityTargetLivingEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        if (event.getTarget() instanceof Player) {
            LivingEntity livingEntity = event.getTarget();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            Location location = ((Player)livingEntity).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (!this.utils.locationOnSurvivalSide(location)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void onCreatureSpawn(@NotNull CreatureSpawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getLocation().getWorld();
        Intrinsics.checkNotNull(world);
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (!this.utils.locationOnSurvivalSide(location) && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL && this.utils.getWorldConfig((World)world).noCreativeMonsters && event.getEntity() instanceof Monster) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPickup(@NotNull PlayerAttemptPickupItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.utils.locationInBufferZone(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onSpawn(@NotNull PlayerSpawnLocationEvent event) {
        block2: {
            PersistentDataContainer playerPdc;
            List<Double> coordinates;
            block3: {
                Intrinsics.checkNotNullParameter(event, "event");
                boolean customRespawn = this.config.getBoolean("custom_respawn", false);
                coordinates = this.utils.getSpawnCoordinates(this.config);
                PersistentDataContainer persistentDataContainer = event.getPlayer().getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                playerPdc = persistentDataContainer;
                Integer firstJoin = (Integer)playerPdc.get(this.keys.getFirstJoin(), PersistentDataType.INTEGER);
                if (!customRespawn) break block2;
                if (firstJoin == null) break block3;
                int n = 1;
                if (firstJoin == n) break block2;
            }
            playerPdc.set(this.keys.getFirstJoin(), PersistentDataType.INTEGER, (Object)1);
            event.setSpawnLocation(new Location(event.getPlayer().getWorld(), ((Number)coordinates.get(0)).doubleValue(), ((Number)coordinates.get(1)).doubleValue(), ((Number)coordinates.get(2)).doubleValue(), -88.0f, 6.0f));
        }
    }

    @EventHandler
    public final void onPlayerFish(@NotNull PlayerFishEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Entity entity = event.getCaught();
        if (entity == null) {
            return;
        }
        Entity caught = entity;
        Location location = caught.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (!this.utils.locationOnSurvivalSide(location)) {
            Location location2 = event.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            if (!this.utils.locationOnCreativeSide(location2)) {
                event.setCancelled(true);
            }
        }
        PersistentDataContainer persistentDataContainer = event.getPlayer().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer playerPdc = persistentDataContainer;
        Integer firstAttempt = (Integer)playerPdc.get(this.keys.getFirstFishAttempt(), PersistentDataType.INTEGER);
        if (firstAttempt == null) {
            event.getPlayer().giveExp(100);
            playerPdc.set(this.keys.getFirstFishAttempt(), PersistentDataType.INTEGER, (Object)1);
        }
        event.getPlayer().sendMessage("Nice try.");
    }

    @EventHandler
    public final void playerHunger(@NotNull FoodLevelChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Location location = event.getEntity().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (this.utils.locationInBufferZone(location)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void onSkeletonShoots(@NotNull EntityShootBowEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity() instanceof Skeleton) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Skeleton");
            Skeleton skeleton = (Skeleton)livingEntity;
            if (skeleton.getTarget() != null) {
                LivingEntity livingEntity2 = skeleton.getTarget();
                Intrinsics.checkNotNull(livingEntity2);
                Location location = livingEntity2.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                if (!this.utils.locationOnSurvivalSide(location)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public final void itemInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getItem() == null) {
            return;
        }
        if (this.easterEggsEnabled) {
            ItemStack itemStack = event.getItem();
            Intrinsics.checkNotNull(itemStack);
            if (itemStack.getType() == Material.DIAMOND) {
                event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f);
                PlayerInventory playerInventory = event.getPlayer().getInventory();
                PlayerInventory playerInventory2 = event.getPlayer().getInventory();
                Intrinsics.checkNotNullExpressionValue(playerInventory2, "getInventory(...)");
                Iterable iterable = (Iterable)playerInventory2;
                ItemStack itemStack2 = event.getItem();
                Intrinsics.checkNotNull(itemStack2);
                ItemStack itemStack3 = playerInventory.getItem(CollectionsKt.indexOf(iterable, itemStack2));
                Intrinsics.checkNotNull(itemStack3);
                itemStack3.subtract();
                event.getPlayer().giveExpLevels(2);
                event.getPlayer().sendMessage("You ate a diamond you absolute madlad!");
            }
        }
    }

    @EventHandler
    public final void enterBed(@NotNull PlayerBedEnterEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.easterEggsEnabled) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Integer netherEggComplete = Utils.Companion.getPdcInt(player, this.keys.getNetherEgg());
            if (netherEggComplete != null && netherEggComplete >= 1561) {
                return;
            }
            if (event.getBedEnterResult() == PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE) {
                event.setUseBed(Event.Result.ALLOW);
                event.getPlayer().sendMessage("Didn't expect that did you?");
            }
        }
    }

    @EventHandler
    public final void failEnterBed(@NotNull PlayerBedFailEnterEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.easterEggsEnabled) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Integer netherEggComplete = Utils.Companion.getPdcInt(player, this.keys.getNetherEgg());
            if (netherEggComplete != null && netherEggComplete >= 1561) {
                return;
            }
            if (event.getFailReason() == PlayerBedFailEnterEvent.FailReason.NOT_POSSIBLE_HERE) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void enterDeepSleep(@NotNull PlayerDeepSleepEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.easterEggsEnabled) {
            String string = event.getPlayer().getWorld().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (StringsKt.endsWith$default(string, "_nether", false, 2, null)) {
                this.playersSleepingInNether.add(event.getPlayer());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void leaveBed(@NotNull PlayerBedLeaveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.easterEggsEnabled) {
            String string = event.getPlayer().getWorld().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (StringsKt.endsWith$default(string, "_nether", false, 2, null)) {
                this.playersSleepingInNether.remove(event.getPlayer());
            }
        }
    }

    public final <T extends BlockEvent> void handleBlockEvent(@NotNull T event, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(player, "player");
        World world = event.getBlock().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!this.utils.worldEnabled(world)) {
            return;
        }
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.utils.locationInBufferZone(location)) {
            ((Cancellable)event).setCancelled(true);
        }
        Location location2 = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        if (this.utils.locationOnSurvivalSide(location2)) {
            Location location3 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
            if (this.utils.locationInBufferZone(location3)) {
                ((Cancellable)event).setCancelled(true);
            }
        }
    }

    private static final WorldConfig worldConfigs$lambda$0(Object item) {
        Intrinsics.checkNotNull(item, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        return new WorldConfig((Map)item);
    }

    private static final String worldConfigs$lambda$1(WorldConfig item) {
        Intrinsics.checkNotNullParameter(item, "item");
        return item.worldName;
    }

    private static final String worldConfigs$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final WorldConfig worldConfigs$lambda$3(WorldConfig item) {
        Intrinsics.checkNotNullParameter(item, "item");
        return item;
    }

    private static final WorldConfig worldConfigs$lambda$4(Function1 $tmp0, Object p0) {
        return (WorldConfig)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ArrayList access$getDroppedItems$p(SplitWorld $this) {
        return $this.droppedItems;
    }

    public static final /* synthetic */ Utils access$getUtils$p(SplitWorld $this) {
        return $this.utils;
    }

    public static final /* synthetic */ HashSet access$getPlayersSleepingInNether$p(SplitWorld $this) {
        return $this.playersSleepingInNether;
    }

    public static final /* synthetic */ SplitWorldKeys access$getKeys$p(SplitWorld $this) {
        return $this.keys;
    }
}

