/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.snaco.split_world.PlayerUtils;
import tech.snaco.split_world.SplitWorldKeys;
import tech.snaco.split_world.Utils;
import tech.snaco.split_world.types.WorldConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ-\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0017\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0002\u00a2\u0006\u0002\u0010$J(\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u00132\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u00132\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltech/snaco/split_world/SplitWorldCommands;", "", "keys", "Ltech/snaco/split_world/SplitWorldKeys;", "playerUtils", "Ltech/snaco/split_world/PlayerUtils;", "worldConfigs", "", "", "Ltech/snaco/split_world/types/WorldConfig;", "manageCreativeCommands", "", "<init>", "(Ltech/snaco/split_world/SplitWorldKeys;Ltech/snaco/split_world/PlayerUtils;Ljava/util/Map;Z)V", "utils", "Ltech/snaco/split_world/Utils;", "numberOfWorldsEnabled", "", "onTabComplete", "", "command", "Lorg/bukkit/command/Command;", "args", "", "(Lorg/bukkit/command/Command;[Ljava/lang/String;)Ljava/util/List;", "preProcessCommand", "", "event", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onCommand", "sender", "Lorg/bukkit/command/CommandSender;", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;[Ljava/lang/String;)Z", "getCoordinates", "", "commandArgs", "([Ljava/lang/String;)Ljava/util/List;", "getLocations", "Lorg/bukkit/Location;", "coordinates", "player", "Lorg/bukkit/entity/Player;", "SplitWorld-plugin"})
@SourceDebugExtension(value={"SMAP\nSplitWorldCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitWorldCommands.kt\ntech/snaco/split_world/SplitWorldCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,196:1\n739#2,9:197\n37#3:206\n36#3,3:207\n*S KotlinDebug\n*F\n+ 1 SplitWorldCommands.kt\ntech/snaco/split_world/SplitWorldCommands\n*L\n44#1:197,9\n45#1:206\n45#1:207,3\n*E\n"})
public final class SplitWorldCommands {
    @NotNull
    private SplitWorldKeys keys;
    @NotNull
    private PlayerUtils playerUtils;
    private boolean manageCreativeCommands;
    @NotNull
    private Utils utils;
    private int numberOfWorldsEnabled;

    public SplitWorldCommands(@NotNull SplitWorldKeys keys2, @NotNull PlayerUtils playerUtils, @NotNull Map<String, WorldConfig> worldConfigs, boolean manageCreativeCommands) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        Intrinsics.checkNotNullParameter(playerUtils, "playerUtils");
        Intrinsics.checkNotNullParameter(worldConfigs, "worldConfigs");
        this.keys = keys2;
        this.playerUtils = playerUtils;
        this.manageCreativeCommands = manageCreativeCommands;
        this.utils = new Utils(worldConfigs);
        this.numberOfWorldsEnabled = worldConfigs.values().stream().filter(arg_0 -> SplitWorldCommands.numberOfWorldsEnabled$lambda$1(SplitWorldCommands::numberOfWorldsEnabled$lambda$0, arg_0)).toList().size();
    }

    @Nullable
    public final List<String> onTabComplete(@NotNull Command command, @Nullable String[] args) {
        Intrinsics.checkNotNullParameter(command, "command");
        if (StringsKt.equals(command.getName(), "play-border-sound", true)) {
            Intrinsics.checkNotNull(args);
            if (args.length == 1) {
                String[] stringArray = new String[]{"true", "false"};
                return CollectionsKt.listOf(stringArray);
            }
        }
        if (StringsKt.equals(command.getName(), "play-border-sound", true)) {
            Intrinsics.checkNotNull(args);
            if (args.length > 1) {
                return new ArrayList();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void preProcessCommand(@NotNull PlayerCommandPreprocessEvent event) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.manageCreativeCommands || event.getPlayer().isOp()) {
            return;
        }
        String[] stringArray = new String[]{"/fill", "/clone", "/setblock"};
        List<String> creativeCommands = CollectionsKt.listOf(stringArray);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = event.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String commandStr = string;
        Object object = commandStr;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] commandArgs = thisCollection$iv.toArray(new String[0]);
        if (commandArgs.length < 3) {
            return;
        }
        if (!creativeCommands.contains(commandArgs[0])) {
            return;
        }
        if (player2.getGameMode() == GameMode.SURVIVAL) {
            player2.sendMessage("You cannot use the " + commandArgs[0] + " command in survival.");
            event.setCancelled(true);
            return;
        }
        List<Double> list2 = this.getCoordinates(commandArgs);
        if (list2 == null) {
            return;
        }
        List<Double> coordinates = list2;
        List<Location> list3 = this.getLocations(coordinates, player2);
        if (list3 == null) {
            return;
        }
        List<Location> locations = list3;
        for (Location location : locations) {
            if (this.utils.locationOnCreativeSide(location)) continue;
            if (this.numberOfWorldsEnabled > 1) {
                player2.sendMessage("The " + commandArgs[0] + " command cannot include blocks outside the creative sides of split worlds");
                event.setCancelled(true);
            } else if (this.numberOfWorldsEnabled == 1) {
                player2.sendMessage("The " + commandArgs[0] + " command cannot include blocks outside the creative side of the split world");
                event.setCancelled(true);
            }
            return;
        }
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @Nullable String[] args) {
        Player player;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        String string = sender.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        Player player2 = player = sender.getServer().getPlayer(playerName);
        Intrinsics.checkNotNull(player2);
        PersistentDataContainer persistentDataContainer = player2.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer playerPdc = persistentDataContainer;
        if (StringsKt.equals(command.getName(), "play-border-sound", true)) {
            Intrinsics.checkNotNull(args);
            if (args.length != 1) {
                return false;
            }
            if (StringsKt.equals(args[0], "true", true)) {
                playerPdc.set(this.keys.getPlayBorderSound(), PersistentDataType.INTEGER, (Object)1);
            } else if (StringsKt.equals(args[0], "false", true)) {
                playerPdc.set(this.keys.getPlayBorderSound(), PersistentDataType.INTEGER, (Object)0);
            } else {
                return false;
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "set-spawn-builder", true)) {
            Server server = player.getServer();
            Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
            Server server2 = server;
            Intrinsics.checkNotNull(args);
            if (args.length != 2) {
                return false;
            }
            Player player3 = server2.getPlayer(args[0]);
            if (player3 == null) {
                return false;
            }
            Player targetPlayer = player3;
            PersistentDataContainer persistentDataContainer2 = targetPlayer.getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer2, "getPersistentDataContainer(...)");
            PersistentDataContainer targetPlayerPdc = persistentDataContainer2;
            if (StringsKt.equals(args[1], "true", true)) {
                targetPlayerPdc.set(this.keys.getSpawnBuilder(), PersistentDataType.INTEGER, (Object)1);
                System.out.println((Object)(targetPlayer.getName() + "is now a spawn builder."));
                targetPlayer.sendMessage("You now have permission to build in the spawn area.");
            } else if (StringsKt.equals(args[1], "false", true)) {
                targetPlayerPdc.set(this.keys.getSpawnBuilder(), PersistentDataType.INTEGER, (Object)0);
                System.out.println((Object)(targetPlayer.getName() + "is no longer a spawn builder."));
                targetPlayer.sendMessage("You no longer have permission to build in the spawn area.");
            } else {
                return false;
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "understood", true)) {
            playerPdc.set(this.keys.getNoWelcome(), PersistentDataType.INTEGER, (Object)1);
            player.sendMessage("You will no longer see the welcome message for split world.");
            return true;
        }
        if (StringsKt.equals(command.getName(), "disable-split-world", true)) {
            if (player.hasPermission("split-world.disable-split-world")) {
                playerPdc.set(this.keys.getSplitWorldDisabled(), PersistentDataType.INTEGER, (Object)1);
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "enable-split-world", true)) {
            if (player.hasPermission("split-world.enable-split-world")) {
                playerPdc.set(this.keys.getSplitWorldDisabled(), PersistentDataType.INTEGER, (Object)0);
            }
            this.playerUtils.switchPlayerToConfiguredGameMode(player);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Double> getCoordinates(String[] commandArgs) {
        int n;
        ArrayList args = new ArrayList(CollectionsKt.listOf(Arrays.copyOf(commandArgs, commandArgs.length)));
        String command = (String)args.remove(0);
        if (args.isEmpty()) {
            return null;
        }
        String string = command;
        if (string == null) return null;
        int n2 = -1;
        switch (string.hashCode()) {
            case 46548530: {
                if (string.equals("/fill")) {
                    n2 = 1;
                }
                break;
            }
            case 1440326286: {
                if (string.equals("/clone")) {
                    n2 = 2;
                }
                break;
            }
            case -1927883110: {
                if (string.equals("/setblock")) {
                    n2 = 3;
                }
                break;
            }
        }
        switch (n2) {
            case 1: {
                n = 6;
                break;
            }
            case 2: {
                n = 9;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                return null;
            }
        }
        int coordinateCount = n;
        if (coordinateCount == -1) {
            return null;
        }
        if (args.size() < coordinateCount) {
            return null;
        }
        List coordinates = new ArrayList();
        int i = 0;
        while (i < coordinateCount) {
            if (Intrinsics.areEqual(args.get(i), "~")) {
                v1 = coordinates.add(null);
            } else {
                Object e = args.get(i);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                v1 = coordinates.add(Double.parseDouble((String)e));
            }
            ++i;
        }
        return CollectionsKt.toList(coordinates);
    }

    private final List<Location> getLocations(List<Double> coordinates, Player player) {
        int size = coordinates.size();
        if (size < 3 || size % 3 != 0) {
            return null;
        }
        List locations = new ArrayList();
        int n = size / 3;
        for (int i = 0; i < n; ++i) {
            double d;
            double y;
            double x;
            int index = i * 3;
            if (coordinates.get(index) == null) {
                v0 = player.getLocation().getX();
            } else {
                Double d2 = coordinates.get(index);
                Intrinsics.checkNotNull(d2);
                v0 = x = ((Number)d2).doubleValue();
            }
            if (coordinates.get(index + 1) == null) {
                v2 = player.getLocation().getY();
            } else {
                Double d3 = coordinates.get(index + 1);
                Intrinsics.checkNotNull(d3);
                v2 = y = ((Number)d3).doubleValue();
            }
            if (coordinates.get(index + 2) == null) {
                d = player.getLocation().getZ();
            } else {
                Double d4 = coordinates.get(index + 2);
                Intrinsics.checkNotNull(d4);
                d = ((Number)d4).doubleValue();
            }
            double z = d;
            locations.add(new Location(player.getWorld(), x, y, z));
        }
        return locations;
    }

    private static final boolean numberOfWorldsEnabled$lambda$0(WorldConfig world) {
        WorldConfig worldConfig = world;
        return worldConfig != null ? worldConfig.enabled : false;
    }

    private static final boolean numberOfWorldsEnabled$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

