/*
 * Decompiled with CFR 0.152.
 */
package tech.snaco.split_world;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.snaco.split_world.types.WorldConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010 \u001a\u00020!R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ltech/snaco/split_world/Utils;", "", "worldConfigs", "", "", "Ltech/snaco/split_world/types/WorldConfig;", "<init>", "(Ljava/util/Map;)V", "playerOnCreativeSide", "", "player", "Lorg/bukkit/entity/Player;", "locationOnCreativeSide", "location", "Lorg/bukkit/Location;", "locationOnSurvivalSide", "playerInBufferZone", "locationInBufferZone", "locationOnPositiveSideOfBuffer", "locationOnNegativeSideOfBuffer", "locationIsTraversable", "getRelevantPos", "", "addToRelevantPos", "value", "getWorldConfig", "world", "Lorg/bukkit/World;", "worldEnabled", "closestSolidBlockBelowLocation", "getSpawnCoordinates", "", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "Companion", "SplitWorld-plugin"})
public final class Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, WorldConfig> worldConfigs;

    public Utils(@NotNull Map<String, WorldConfig> worldConfigs) {
        Intrinsics.checkNotNullParameter(worldConfigs, "worldConfigs");
        this.worldConfigs = worldConfigs;
    }

    public final boolean playerOnCreativeSide(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        return this.locationOnCreativeSide(location);
    }

    public final boolean locationOnCreativeSide(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        return Intrinsics.areEqual(worldConfig.creativeSide, "negative") && this.locationOnNegativeSideOfBuffer(location) ? true : Intrinsics.areEqual(worldConfig.creativeSide, "positive") && this.locationOnPositiveSideOfBuffer(location);
    }

    public final boolean locationOnSurvivalSide(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        return Intrinsics.areEqual(worldConfig.creativeSide, "negative") && this.locationOnPositiveSideOfBuffer(location) ? true : Intrinsics.areEqual(worldConfig.creativeSide, "positive") && this.locationOnNegativeSideOfBuffer(location);
    }

    public final boolean playerInBufferZone(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        return this.locationInBufferZone(location);
    }

    public final boolean locationInBufferZone(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        double pos = this.getRelevantPos(location);
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        return pos >= (double)worldConfig.borderLocation - (double)worldConfig.borderWidth / 2.0 && pos < (double)worldConfig.borderLocation + (double)worldConfig.borderWidth / 2.0;
    }

    private final boolean locationOnPositiveSideOfBuffer(Location location) {
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        double pos = this.getRelevantPos(location);
        return pos >= (double)worldConfig.borderLocation + (double)worldConfig.borderWidth / 2.0;
    }

    private final boolean locationOnNegativeSideOfBuffer(Location location) {
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        double pos = this.getRelevantPos(location);
        return pos < (double)worldConfig.borderLocation - (double)worldConfig.borderWidth / 2.0;
    }

    public final boolean locationIsTraversable(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Material material = world.getBlockAt(location).getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material blockType = material;
        return !blockType.isSolid();
    }

    public final double getRelevantPos(@NotNull Location location) {
        String string;
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        String string2 = worldConfig.borderAxis;
        if (string2 != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string4 = string3.toUpperCase(locale);
            v4 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
        } else {
            v4 = string = null;
        }
        return Intrinsics.areEqual(string, "Y") ? location.getY() : (Intrinsics.areEqual(string, "Z") ? location.getZ() : location.getX());
    }

    @NotNull
    public final Location addToRelevantPos(@NotNull Location location, double value) {
        Location location2;
        String string;
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldConfig worldConfig = this.getWorldConfig(world);
        String string2 = worldConfig.borderAxis;
        if (string2 != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string4 = string3.toUpperCase(locale);
            v4 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
        } else {
            v4 = string = null;
        }
        if (Intrinsics.areEqual(string, "Y")) {
            Location location3 = location.add(0.0, value, 0.0);
            location2 = location3;
            Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
        } else if (Intrinsics.areEqual(string, "Z")) {
            Location location4 = location.add(0.0, 0.0, value);
            location2 = location4;
            Intrinsics.checkNotNullExpressionValue(location4, "add(...)");
        } else {
            Location location5 = location.add(value, 0.0, 0.0);
            location2 = location5;
            Intrinsics.checkNotNullExpressionValue(location5, "add(...)");
        }
        return location2;
    }

    @NotNull
    public final WorldConfig getWorldConfig(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        WorldConfig worldConfig = this.worldConfigs.get(world.getName());
        Intrinsics.checkNotNull(worldConfig);
        return worldConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean worldEnabled(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        String string = world.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String worldName = string;
        if (!this.worldConfigs.containsKey(worldName)) return false;
        WorldConfig worldConfig = this.worldConfigs.get(worldName);
        Intrinsics.checkNotNull(worldConfig);
        if (!worldConfig.enabled) return false;
        return true;
    }

    @NotNull
    public final Location closestSolidBlockBelowLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location loc = location2;
        boolean blockFound = false;
        while (!blockFound) {
            loc.add(0.0, -1.0, 0.0);
            if (loc.getBlock().isSolid()) {
                blockFound = true;
            }
            if (!(loc.getY() <= -64.0)) continue;
            break;
        }
        return loc;
    }

    @NotNull
    public final List<Double> getSpawnCoordinates(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        List list = config.getDoubleList("respawn_coordinates");
        Intrinsics.checkNotNullExpressionValue(list, "getDoubleList(...)");
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001d\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Ltech/snaco/split_world/Utils$Companion;", "", "<init>", "()V", "setPdcInt", "", "player", "Lorg/bukkit/entity/Player;", "key", "Lorg/bukkit/NamespacedKey;", "value", "", "getPdcInt", "(Lorg/bukkit/entity/Player;Lorg/bukkit/NamespacedKey;)Ljava/lang/Integer;", "SplitWorld-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void setPdcInt(@NotNull Player player, @NotNull NamespacedKey key, int value) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(key, "key");
            player.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
        }

        @Nullable
        public final Integer getPdcInt(@NotNull Player player, @NotNull NamespacedKey key) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(key, "key");
            return (Integer)player.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

