/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.command.admin;

import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.lib.command.IHandyCommandEvent;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.db.Db;
import cn.handyplus.intensify.lib.db.DbTypeEnum;
import cn.handyplus.intensify.lib.db.SqlManagerUtil;
import cn.handyplus.intensify.lib.util.AssertUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.HandyConfigUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.service.PlayerIntensifyService;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ConvertCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "convert";
    }

    @Override
    public String permission() {
        return "playerIntensify.convert";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getLangMsg("paramFailureMsg"));
        String storageMethod = args[1];
        if (!DbTypeEnum.MySQL.getType().equalsIgnoreCase(storageMethod) && !DbTypeEnum.SQLite.getType().equalsIgnoreCase(storageMethod)) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("paramFailureMsg"));
            return;
        }
        if (storageMethod.equalsIgnoreCase(BaseConstants.STORAGE_CONFIG.getString("storage-method"))) {
            MessageUtil.sendMessage(sender, "&4\u7981\u6b62\u8f6c\u6362\uff01\u539f\u56e0\uff0c\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u5b58\u50a8\u65b9\u5f0f\u5df2\u7ecf\u4e3a\uff1a" + storageMethod);
            return;
        }
        List<PlayerIntensifyEntity> all = PlayerIntensifyService.getInstance().findAll();
        HandyConfigUtil.setPath(BaseConstants.STORAGE_CONFIG, "storage-method", storageMethod, Collections.singletonList("\u5b58\u50a8\u65b9\u6cd5(MySQL,SQLite)\u8bf7\u590d\u5236\u62ec\u53f7\u5185\u7684\u7c7b\u578b,\u4e0d\u8981\u81ea\u5df1\u5199"), "storage.yml");
        SqlManagerUtil.getInstance().enableSql();
        Db.use(PlayerIntensifyEntity.class).createTable();
        Db.use(PlayerIntensifyEntity.class).execution().insertBatch(all);
        MessageUtil.sendMessage(sender, "&4\u8f6c\u6362\u6570\u636e\u5b8c\u6210\uff0c\u8bf7\u52a1\u5fc5\u91cd\u542f\u670d\u52a1\u5668\uff0c\u4e0d\u7136\u6709\u53ef\u80fd\u4f1a\u51fa\u73b0\u672a\u77e5bug");
    }
}

