/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.command.admin;

import cn.handyplus.intensify.PlayerIntensify;
import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.lib.command.IHandyCommandEvent;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.hologram.HdUtil;
import cn.handyplus.intensify.lib.util.AssertUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.service.PlayerIntensifyService;
import cn.handyplus.intensify.util.ConfigUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.io.File;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateHdCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "createHd";
    }

    @Override
    public String permission() {
        return "playerIntensify.createHd";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(!PlayerIntensify.USE_HD, BaseUtil.getMsgNotColor("hdFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        List<PlayerIntensifyEntity> ranking = PlayerIntensifyService.getInstance().findRanking();
        if (CollUtil.isEmpty(ranking)) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("noRanking"));
            return;
        }
        HdUtil.deleteAll();
        HdUtil.create(IntensifyUtil.getTextLineList(ranking), player.getLocation(), ranking.get(0).getMaterialName(), 0);
        ConfigUtil.HOLOGRAM_CONFIG.set("hdLocation.enable", (Object)true);
        ConfigUtil.HOLOGRAM_CONFIG.set("hdLocation.world", (Object)player.getWorld().getName());
        ConfigUtil.HOLOGRAM_CONFIG.set("hdLocation.x", (Object)player.getLocation().getX());
        ConfigUtil.HOLOGRAM_CONFIG.set("hdLocation.y", (Object)player.getLocation().getY());
        ConfigUtil.HOLOGRAM_CONFIG.set("hdLocation.z", (Object)player.getLocation().getZ());
        ConfigUtil.HOLOGRAM_CONFIG.save(new File(PlayerIntensify.INSTANCE.getDataFolder(), "hologram.yml"));
    }
}

