/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.command.admin;

import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.lib.command.IHandyCommandEvent;
import cn.handyplus.intensify.lib.util.AssertUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCokesCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "giveCokes";
    }

    @Override
    public String permission() {
        return "playerIntensify.giveCokes";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getLangMsg("paramFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[1], BaseUtil.getLangMsg("amountFailureMsg"));
        CokesTypeEnum cokesTypeEnum = CokesTypeEnum.RYAN_COKES;
        if (args.length > 2) {
            cokesTypeEnum = CokesTypeEnum.getEnumThrow(args[2]);
        }
        Player player = BaseUtil.getOnlinePlayer(sender, args.length > 3 ? args[3] : null, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        ItemStack ryanCokes = IntensifyUtil.getCokes(cokesTypeEnum);
        ItemStackUtil.addItem(player, ryanCokes, (int)amount);
        MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("succeedMsg"));
    }
}

