/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.command.admin;

import cn.handyplus.intensify.constants.IntensifyCardEnum;
import cn.handyplus.intensify.lib.command.IHandyCommandEvent;
import cn.handyplus.intensify.lib.util.AssertUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveIntensifyCardCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "giveIntensifyCard";
    }

    @Override
    public String permission() {
        return "playerIntensify.giveIntensifyCard";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 4, BaseUtil.getLangMsg("paramFailureMsg"));
        IntensifyCardEnum intensifyCardEnum = IntensifyCardEnum.getEnum(args[1]);
        AssertUtil.notNull((Object)intensifyCardEnum, BaseUtil.getLangMsg("typeFailureMsg"));
        Integer level = AssertUtil.isNumericToInt(args[2], BaseUtil.getLangMsg("amountFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[3], BaseUtil.getLangMsg("amountFailureMsg"));
        Player player = BaseUtil.getOnlinePlayer(sender, args.length > 4 ? args[4] : null, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        String name = IntensifyCardEnum.getName(level, intensifyCardEnum.getType());
        ItemStack itemStack = IntensifyUtil.getIntensifyCard(name, intensifyCardEnum.getProbability(), level);
        ItemStackUtil.addItem(player, itemStack, (int)amount);
        MessageUtil.sendMessage(player, BaseUtil.getLangMsg("succeedMsg"));
    }
}

