/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.constants;

import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public enum IntensifyCardEnum {
    IRON_INGOT("iron_ingot", 1),
    BRONZE("bronze", 5),
    BAI_YIN("bai_yin", 10),
    GOLD_INGOT("gold_ingot", 30),
    PLATINUM("platinum", 50),
    EMERALD("emerald", 70),
    DIAMOND("diamond", 90),
    INTENSIFY_CARD("intensify_card", 100);

    private final String type;
    private final Integer probability;

    public static List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (IntensifyCardEnum value : IntensifyCardEnum.values()) {
            types.add(value.getType());
        }
        return types;
    }

    public static IntensifyCardEnum getEnum(String type) {
        for (IntensifyCardEnum intensifyCardEnum : IntensifyCardEnum.values()) {
            if (!intensifyCardEnum.getType().equalsIgnoreCase(type)) continue;
            return intensifyCardEnum;
        }
        return null;
    }

    public static String getName(Integer level, String type) {
        boolean intensifyCardLevelShow = BaseConstants.CONFIG.getBoolean("intensifyCardLevelShow");
        if (intensifyCardLevelShow) {
            return "&5+" + level + " " + BaseUtil.getLangMsg("intensifyCardType." + type);
        }
        return BaseUtil.getLangMsg("intensifyCardType." + type);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getProbability() {
        return this.probability;
    }

    @Generated
    private IntensifyCardEnum(String type, Integer probability) {
        this.type = type;
        this.probability = probability;
    }
}

