/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.intensify;

import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.IntensifyResultTypeEnum;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.intensify.IntensifyService;
import cn.handyplus.intensify.intensify.impl.ArmorIntensifyServiceImpl;
import cn.handyplus.intensify.intensify.impl.BowIntensifyServiceImpl;
import cn.handyplus.intensify.intensify.impl.CrossBowIntensifyServiceImpl;
import cn.handyplus.intensify.intensify.impl.CustomIntensifyServiceImpl;
import cn.handyplus.intensify.intensify.impl.ShieldIntensifyServiceImpl;
import cn.handyplus.intensify.intensify.impl.WeaponIntensifyServiceImpl;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.NumberUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.ItemMetaUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.param.Intensify;
import cn.handyplus.intensify.param.IntensifyResult;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class IntensifyStrategy {
    private static final IntensifyStrategy INSTANCE = new IntensifyStrategy();

    private IntensifyStrategy() {
    }

    public static IntensifyStrategy getInstance() {
        return INSTANCE;
    }

    public IntensifyResult intensify(OfflinePlayer offlinePlayer, ItemStack itemStack, CokesTypeEnum cokesTypeEnum) {
        return this.intensify(offlinePlayer, itemStack, cokesTypeEnum, null, null, false);
    }

    public IntensifyResult intensify(OfflinePlayer offlinePlayer, ItemStack itemStack, CokesTypeEnum cokesTypeEnum, Boolean isSuccess, Integer newLevel) {
        return this.intensify(offlinePlayer, itemStack, cokesTypeEnum, isSuccess, newLevel, false);
    }

    public IntensifyResult intensify(OfflinePlayer offlinePlayer, ItemStack itemStack, CokesTypeEnum cokesTypeEnum, Boolean isSuccess, Integer newLevel, boolean isCard) {
        boolean rst;
        IntensifyResult intensifyResult = new IntensifyResult();
        intensifyResult.setOfflinePlayer(offlinePlayer);
        Player player = offlinePlayer.getPlayer();
        intensifyResult.setPlayer(player);
        SwordEnum swordEnum = SwordEnum.getEnum(itemStack.getType());
        if (swordEnum == null) {
            intensifyResult.setResult(IntensifyResultTypeEnum.ERROR);
            return intensifyResult;
        }
        intensifyResult.setSwordEnum(swordEnum);
        intensifyResult.setDisplayName(BaseUtil.getDisplayName(itemStack));
        intensifyResult.setMaterialName(itemStack.getType().name());
        int level = this.setLevelAndAmount(newLevel, intensifyResult, itemStack);
        if (level > BaseConstants.CONFIG.getInt("maxLevel", 20)) {
            intensifyResult.setResult(IntensifyResultTypeEnum.LIMIT);
            return intensifyResult;
        }
        boolean bl = rst = isSuccess != null ? isSuccess : IntensifyUtil.randomIndex(player, level, cokesTypeEnum);
        if (!rst) {
            Intensify intensify = IntensifyConstants.RYAN_COKES_MAP.get(level);
            if (intensify == null) {
                intensifyResult.setResult(IntensifyResultTypeEnum.LIMIT);
                return intensifyResult;
            }
            if (isCard) {
                intensifyResult.setResult(IntensifyResultTypeEnum.FAILED_NO_CHANGE);
                intensifyResult.setLevel(level);
                return intensifyResult;
            }
            if (intensify.getIsVanish().booleanValue()) {
                boolean removeItemRst = ItemStackUtil.removeItem(player, IntensifyUtil.getProtectionCard(), 1, false);
                if (removeItemRst) {
                    intensifyResult.setResult(IntensifyResultTypeEnum.FAILED_PROTECTION_CARD);
                } else {
                    intensifyResult.setResult(IntensifyResultTypeEnum.FAILED_DISAPPEARED);
                }
                return intensifyResult;
            }
            if (intensify.getIsLevel().booleanValue()) {
                boolean removeItemRst = ItemStackUtil.removeItem(player, IntensifyUtil.getProtectionAmulet(), 1, false);
                if (removeItemRst) {
                    intensifyResult.setResult(IntensifyResultTypeEnum.FAILED_PROTECTION_AMULET);
                    return intensifyResult;
                }
                List<Integer> levelOff = intensify.getLevelOff();
                Collections.shuffle(levelOff);
                level = levelOff.get(0);
                this.setAmount(intensifyResult, level);
                intensifyResult.setResult(IntensifyResultTypeEnum.FAILED_DOWNGRADED);
            } else {
                intensifyResult.setResult(IntensifyResultTypeEnum.FAILED);
                intensifyResult.setLevel(level);
                return intensifyResult;
            }
        }
        intensifyResult.setLevel(intensifyResult.getLevel() + 1);
        IntensifyResult result = this.startIntensify(itemStack, intensifyResult, level);
        if (result != null) {
            return result;
        }
        return intensifyResult;
    }

    private IntensifyResult startIntensify(ItemStack itemStack, IntensifyResult intensifyResult, int level) {
        IntensifyService intensifyService;
        SwordEnum swordEnum = intensifyResult.getSwordEnum();
        switch (swordEnum.getType()) {
            case WEAPON: {
                intensifyService = new WeaponIntensifyServiceImpl();
                break;
            }
            case ARMOR: {
                intensifyService = new ArmorIntensifyServiceImpl();
                break;
            }
            case BOW: {
                intensifyService = new BowIntensifyServiceImpl();
                break;
            }
            case CROSSBOW: {
                intensifyService = new CrossBowIntensifyServiceImpl();
                break;
            }
            case SHIELD: {
                intensifyService = new ShieldIntensifyServiceImpl();
                break;
            }
            case CUSTOM: {
                intensifyService = new CustomIntensifyServiceImpl();
                break;
            }
            default: {
                intensifyResult.setResult(IntensifyResultTypeEnum.ERROR);
                return intensifyResult;
            }
        }
        intensifyService.intensify(itemStack, level, intensifyResult.getAmount(), swordEnum);
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.setDisplayName(ChatColor.RESET + IntensifyUtil.delIntensifyLevel(intensifyResult.getDisplayName()).trim() + " \u00a7f[+\u00a7a" + level + "\u00a7f]");
        ItemMetaUtil.setPersistentData(itemMeta, level + "", "level");
        itemStack.setItemMeta(itemMeta);
        intensifyResult.setDisplayName(itemMeta.getDisplayName());
        return null;
    }

    private int setLevelAndAmount(Integer newLevel, IntensifyResult intensifyResult, ItemStack itemStack) {
        int level = 1;
        if (newLevel != null) {
            level = newLevel;
        } else {
            Optional<String> oldLevelOpt = ItemStackUtil.getPersistentData(itemStack, "level");
            if (oldLevelOpt.isPresent()) {
                level = NumberUtil.isNumericToInt(oldLevelOpt.get()) + 1;
            }
        }
        intensifyResult.setLevel(level - 1);
        this.setAmount(intensifyResult, level);
        return level;
    }

    private void setAmount(IntensifyResult intensifyResult, int level) {
        SwordEnum swordEnum = intensifyResult.getSwordEnum();
        double amount = BaseConstants.CONFIG.getDouble("amount." + swordEnum.getTypeStr(), 1.0);
        double newAmount = intensifyResult.getSwordEnum().getAmount() + (double)level * amount;
        newAmount = this.getLevelBonusAmount(level, swordEnum, newAmount);
        intensifyResult.setAmount(newAmount);
    }

    private double getLevelBonusAmount(int level, SwordEnum swordEnum, double newAmount) {
        boolean levelBonusEnable = BaseConstants.CONFIG.getBoolean("levelBonus.enable");
        if (!levelBonusEnable) {
            return newAmount;
        }
        String levelBonusStr = BaseConstants.CONFIG.getString("levelBonus." + swordEnum.getTypeStr() + "." + level);
        if (StrUtil.isNotEmpty(levelBonusStr)) {
            if (!levelBonusStr.contains("~")) {
                Double levelBonusAmount = NumberUtil.isNumericToDouble(levelBonusStr, 0.0);
                MessageUtil.sendConsoleDebugMessage("\u5f53\u524d\u7b49\u7ea7:" + level + " \u5f53\u524d\u5c5e\u6027:" + newAmount + "\u672c\u6b21\u7b49\u7ea7\u52a0\u6210:" + levelBonusAmount + " \u6700\u7ec8\u5c5e\u6027:" + (newAmount + levelBonusAmount));
                newAmount += levelBonusAmount.doubleValue();
            } else {
                List<String> levelBonusStrList = StrUtil.strToStrList(levelBonusStr, "~");
                Double one = NumberUtil.isNumericToDouble(levelBonusStrList.get(0));
                Double two = NumberUtil.isNumericToDouble(levelBonusStrList.get(levelBonusStrList.size() - 1));
                double levelBonusAmount = one + (two - one) * new Random().nextDouble();
                MessageUtil.sendConsoleDebugMessage("\u5f53\u524d\u7b49\u7ea7:" + level + " \u5f53\u524d\u5c5e\u6027:" + newAmount + "\u672c\u6b21\u7b49\u7ea7\u52a0\u6210:" + levelBonusAmount + " \u6700\u7ec8\u5c5e\u6027:" + (newAmount + levelBonusAmount));
                newAmount += levelBonusAmount;
            }
        }
        newAmount = new BigDecimal(newAmount).setScale(2, RoundingMode.HALF_UP).doubleValue();
        return newAmount;
    }
}

