/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.intensify.impl;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.intensify.IntensifyService;
import cn.handyplus.intensify.lib.constants.AttributeCompatEnum;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.LegacyUtil;
import java.math.BigDecimal;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ArmorIntensifyServiceImpl
implements IntensifyService {
    @Override
    public void intensifyAttribute(ItemStack itemStack, int level, double amount, SwordEnum swordEnum) {
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.removeAttributeModifier(AttributeCompatEnum.ARMOR.resolve());
        itemMeta.removeAttributeModifier(AttributeCompatEnum.ARMOR_TOUGHNESS.resolve());
        itemMeta.removeAttributeModifier(AttributeCompatEnum.KNOCKBACK_RESISTANCE.resolve());
        AttributeModifier genericArmor = LegacyUtil.getAttributeModifier("generic.armor", amount, AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
        itemMeta.addAttributeModifier(AttributeCompatEnum.ARMOR.resolve(), genericArmor);
        if (swordEnum.getArmorToughness() > 0.0) {
            AttributeModifier genericArmorToughness = LegacyUtil.getAttributeModifier("generic.armor_toughness", swordEnum.getArmorToughness(), AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
            itemMeta.addAttributeModifier(AttributeCompatEnum.ARMOR_TOUGHNESS.resolve(), genericArmorToughness);
        }
        if (swordEnum.getKnockbackResistance() > 0.0) {
            AttributeModifier genericKnockBackResistance = LegacyUtil.getAttributeModifier("generic.knockback_resistance", swordEnum.getKnockbackResistance(), AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
            itemMeta.addAttributeModifier(AttributeCompatEnum.KNOCKBACK_RESISTANCE.resolve(), genericKnockBackResistance);
        }
        if (level > IntensifyConstants.EXTRA_ATTR_LEVEL && this.isEnable(swordEnum.getTypeStr())) {
            itemMeta.removeAttributeModifier(AttributeCompatEnum.MAX_HEALTH.resolve());
            BigDecimal armor = this.getLevelAttr(level, swordEnum.getTypeStr());
            AttributeModifier genericMaxHealth = LegacyUtil.getAttributeModifier("generic.max_health", armor.doubleValue(), AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
            itemMeta.addAttributeModifier(AttributeCompatEnum.MAX_HEALTH.resolve(), genericMaxHealth);
        }
        itemStack.setItemMeta(itemMeta);
    }
}

