/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.intensify.impl;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.intensify.IntensifyService;
import cn.handyplus.intensify.lib.constants.AttributeCompatEnum;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.LegacyUtil;
import java.math.BigDecimal;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WeaponIntensifyServiceImpl
implements IntensifyService {
    @Override
    public void intensifyAttribute(ItemStack itemStack, int level, double amount, SwordEnum swordEnum) {
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.removeAttributeModifier(AttributeCompatEnum.ATTACK_DAMAGE.resolve());
        itemMeta.removeAttributeModifier(AttributeCompatEnum.ATTACK_SPEED.resolve());
        AttributeModifier attackDamageModifier = LegacyUtil.getAttributeModifier("generic.attack_damage", amount, AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
        itemMeta.addAttributeModifier(AttributeCompatEnum.ATTACK_DAMAGE.resolve(), attackDamageModifier);
        BigDecimal baseAttackSpeed = new BigDecimal(BaseConstants.CONFIG.getString("baseAttackSpeed." + swordEnum.getMaterial(), "4"));
        BigDecimal attackSpeed = BigDecimal.valueOf(swordEnum.getAttackSpeed()).subtract(baseAttackSpeed);
        if (level > IntensifyConstants.EXTRA_ATTR_LEVEL && this.isEnable(swordEnum.getTypeStr())) {
            itemMeta.removeAttributeModifier(AttributeCompatEnum.ATTACK_SPEED.resolve());
            attackSpeed = attackSpeed.add(this.getLevelAttr(level, swordEnum.getTypeStr()));
        }
        AttributeModifier attackSpeedModifier = LegacyUtil.getAttributeModifier("generic.attack_speed", attackSpeed.doubleValue(), AttributeModifier.Operation.ADD_NUMBER, swordEnum.getEquipmentSlot());
        itemMeta.addAttributeModifier(AttributeCompatEnum.ATTACK_SPEED.resolve(), attackSpeedModifier);
        itemStack.setItemMeta(itemMeta);
    }
}

