/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.db;

import cn.handyplus.intensify.lib.db.DbTypeEnum;
import cn.handyplus.intensify.lib.db.SqlManagerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class SqlService {
    private SqlService() {
    }

    public static SqlService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executionSql(String sql, String storageMethod) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = SqlManagerUtil.getInstance().getConnection(storageMethod);
            ps = conn.prepareStatement(sql);
            ps.executeUpdate();
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "executionSql \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(conn, ps, null);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getTableInfo(String sql, String storageMethod) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        ArrayList<String> fieldNameList = new ArrayList<String>();
        try {
            conn = SqlManagerUtil.getInstance().getConnection(storageMethod);
            ps = conn.prepareStatement(sql);
            rst = ps.executeQuery();
            while (rst.next()) {
                String fieId = DbTypeEnum.SQLite.getType().equalsIgnoreCase(storageMethod) ? rst.getString("name") : rst.getString("column_name");
                fieldNameList.add(fieId);
            }
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "getTableInfo \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
                throw throwable;
            }
        }
        return fieldNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getMysqlTableIndex(String sql, String storageMethod) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        ArrayList<String> columnNameList = new ArrayList<String>();
        try {
            conn = SqlManagerUtil.getInstance().getConnection(storageMethod);
            ps = conn.prepareStatement(sql);
            rst = ps.executeQuery();
            while (rst.next()) {
                String columnName = rst.getString("Column_name");
                columnNameList.add(columnName);
            }
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "getMysqlTableIndex \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
                throw throwable;
            }
        }
        return columnNameList;
    }

    public Map<String, Object> selectMap(String sql) {
        return this.selectMap(sql, SqlManagerUtil.getInstance().getStorageMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> selectMap(String sql, String storageMethod) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            conn = SqlManagerUtil.getInstance().getConnection(storageMethod);
            ps = conn.prepareStatement(sql);
            rst = ps.executeQuery();
            ResultSetMetaData rstMetaData = rst.getMetaData();
            if (rst.next()) {
                for (int i = 1; i <= rstMetaData.getColumnCount(); ++i) {
                    map.put(rstMetaData.getColumnLabel(i), rst.getObject(i));
                }
            }
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "selectMap \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
                throw throwable;
            }
        }
        return map;
    }

    public List<Map<String, Object>> selectListMap(String sql) {
        return this.selectListMap(sql, SqlManagerUtil.getInstance().getStorageMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectListMap(String sql, String storageMethod) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            conn = SqlManagerUtil.getInstance().getConnection(storageMethod);
            ps = conn.prepareStatement(sql);
            rst = ps.executeQuery();
            ResultSetMetaData rstMetaData = rst.getMetaData();
            while (rst.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= rstMetaData.getColumnCount(); ++i) {
                    map.put(rstMetaData.getColumnName(i), rst.getObject(i));
                }
                list.add(map);
            }
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "selectListMap \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
                throw throwable;
            }
        }
        return list;
    }

    private static class SingletonHolder {
        private static final SqlService INSTANCE = new SqlService();

        private SingletonHolder() {
        }
    }
}

