/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.hologram;

import cn.handyplus.intensify.lib.constants.HookPluginEnum;
import cn.handyplus.intensify.lib.hologram.CmiUtil;
import cn.handyplus.intensify.lib.hologram.DecentHologramsUtil;
import cn.handyplus.intensify.lib.hologram.FancyHologramsUtil;
import cn.handyplus.intensify.lib.hologram.HolographicDisplaysUtil;
import cn.handyplus.intensify.lib.util.HookPluginUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import java.util.List;
import org.bukkit.Location;

public class HdUtil {
    private static boolean USE_HOLOGRAPHIC_DISPLAYS;
    private static boolean USE_DECENT_HOLOGRAMS;
    private static boolean USE_CMI;
    private static boolean USE_FANCY_HOLOGRAMS;

    private HdUtil() {
    }

    public static boolean init() {
        USE_DECENT_HOLOGRAMS = HookPluginUtil.hook(HookPluginEnum.DECENT_HOLOGRAMS, null, false);
        if (USE_DECENT_HOLOGRAMS) {
            MessageUtil.sendConsoleMessage("hook DecentHolograms success");
            return true;
        }
        USE_HOLOGRAPHIC_DISPLAYS = HookPluginUtil.hook(HookPluginEnum.HOLOGRAPHIC_DISPLAYS, null, false);
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            MessageUtil.sendConsoleMessage("hook HolographicDisplays success");
            return true;
        }
        USE_CMI = HookPluginUtil.hook(HookPluginEnum.CMI, null, false);
        if (USE_CMI) {
            MessageUtil.sendConsoleMessage("hook cmi success");
            return true;
        }
        USE_FANCY_HOLOGRAMS = HookPluginUtil.hook(HookPluginEnum.FANCY_HOLOGRAMS, null, false);
        if (USE_FANCY_HOLOGRAMS) {
            MessageUtil.sendConsoleMessage("hook FancyHolograms success");
            return true;
        }
        MessageUtil.sendConsoleMessage("hook Holograms error");
        return false;
    }

    public static void create(List<String> textLineList, Location location, String material, int customModelData) {
        if (location == null) {
            return;
        }
        if (USE_DECENT_HOLOGRAMS) {
            DecentHologramsUtil.create(textLineList, location);
            return;
        }
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            HolographicDisplaysUtil.create(textLineList, location, material, customModelData);
            return;
        }
        if (USE_CMI) {
            CmiUtil.create(textLineList, location);
            return;
        }
        if (USE_FANCY_HOLOGRAMS) {
            FancyHologramsUtil.create(textLineList, location);
        }
    }

    public static void deleteAll() {
        if (USE_DECENT_HOLOGRAMS) {
            DecentHologramsUtil.deleteAll();
            return;
        }
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            HolographicDisplaysUtil.deleteAll();
            return;
        }
        if (USE_CMI) {
            CmiUtil.deleteAll();
            return;
        }
        if (USE_FANCY_HOLOGRAMS) {
            FancyHologramsUtil.deleteAll();
        }
    }

    public static void delete(Location location) {
        if (location == null) {
            return;
        }
        if (USE_DECENT_HOLOGRAMS) {
            DecentHologramsUtil.delete(location);
            return;
        }
        if (USE_HOLOGRAPHIC_DISPLAYS) {
            HolographicDisplaysUtil.delete(location);
            return;
        }
        if (USE_CMI) {
            CmiUtil.delete(location);
            return;
        }
        if (USE_FANCY_HOLOGRAMS) {
            FancyHologramsUtil.delete(location);
        }
    }
}

