/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.util;

import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.NumberUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import java.math.BigDecimal;
import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class AssertUtil {
    private AssertUtil() {
    }

    public static void isTrue(boolean expression, String message) {
        AssertUtil.notTrue(!expression, message);
    }

    public static void notTrue(boolean expression, String message) {
        if (expression) {
            throw new RuntimeException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new RuntimeException(message);
        }
    }

    public static void notEmpty(String str, String message) {
        if (StrUtil.isEmpty(str)) {
            throw new RuntimeException(message);
        }
    }

    public static <T> void notNull(Collection<T> collection, String message) {
        if (CollUtil.isEmpty(collection)) {
            throw new RuntimeException(message);
        }
    }

    public static Player notPlayer(CommandSender sender, String message) {
        if (BaseUtil.isNotPlayer(sender).booleanValue()) {
            throw new RuntimeException(message);
        }
        return (Player)sender;
    }

    public static Integer isNumericToInt(String str, String message) {
        return NumberUtil.isNumericToBigDecimal(str).orElseThrow(() -> new RuntimeException(message)).intValue();
    }

    public static Long isNumericToLong(String str, String message) {
        return NumberUtil.isNumericToBigDecimal(str).orElseThrow(() -> new RuntimeException(message)).longValue();
    }

    public static BigDecimal isNumericToBigDecimal(String str, String message) {
        return NumberUtil.isNumericToBigDecimal(str).orElseThrow(() -> new RuntimeException(message));
    }
}

