/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.lib.util;

import cn.handyplus.intensify.lib.constants.HookPluginEnum;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookPluginUtil {
    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum) {
        return HookPluginUtil.hook(hookPluginEnum, null);
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum, @Nullable Integer version) {
        return HookPluginUtil.hook(hookPluginEnum, version, true);
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum, @Nullable Integer version, boolean isMsg) {
        return HookPluginUtil.hookToPlugin(hookPluginEnum, version, isMsg).isPresent();
    }

    public static Optional<Plugin> hookToPlugin(@NotNull HookPluginEnum hookPluginEnum) {
        return HookPluginUtil.hookToPlugin(hookPluginEnum, null, true);
    }

    public static Optional<Plugin> hookToPlugin(@NotNull HookPluginEnum hookPluginEnum, @Nullable Integer version) {
        return HookPluginUtil.hookToPlugin(hookPluginEnum, version, true);
    }

    public static Optional<Plugin> hookToPlugin(@NotNull HookPluginEnum hookPluginEnum, @Nullable Integer version, boolean isMsg) {
        int firstPluginVersion;
        Optional<Object> pluginOpt;
        Plugin plugin = Bukkit.getPluginManager().getPlugin(hookPluginEnum.getName());
        Optional<Plugin> optional = pluginOpt = plugin != null && plugin.isEnabled() ? Optional.of(plugin) : Optional.empty();
        if (pluginOpt.isPresent() && version != null && (firstPluginVersion = BaseUtil.getFirstPluginVersion((Plugin)pluginOpt.get())) < version) {
            pluginOpt = Optional.empty();
        }
        if (isMsg) {
            MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(pluginOpt.isPresent() ? hookPluginEnum.getSuccessMsg() : hookPluginEnum.getFailMsg()));
        }
        return pluginOpt;
    }
}

