/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.MapUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.LotteryUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

@HandyListener
public class EntityDeathEventListener
implements Listener {
    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LotteryUtil lotteryUtil;
        LivingEntity entity = event.getEntity();
        Player player = entity.getKiller();
        if (player == null) {
            return;
        }
        if (!(entity instanceof Monster)) {
            return;
        }
        List killWorldList = BaseConstants.CONFIG.getStringList("killWorld");
        if (CollUtil.isEmpty(killWorldList)) {
            return;
        }
        if (!CollUtil.contains(killWorldList, player.getWorld().getName()) && !CollUtil.contains(killWorldList, "ALL")) {
            return;
        }
        double probability = BaseConstants.CONFIG.getDouble("kill." + entity.getType().name().toLowerCase(), 0.0);
        if (Double.compare(probability, 0.0) >= 0 ? (lotteryUtil = new LotteryUtil(Arrays.asList(probability, 1.0 - probability))).randomIndex() != 0 : (lotteryUtil = IntensifyConstants.MONSTER_LOTTERY_MAP) == null || lotteryUtil.randomIndex() != 0) {
            return;
        }
        Location location = player.getLocation();
        boolean isChunkLimit = BaseConstants.CONFIG.getBoolean("isChunkLimit", true);
        if (isChunkLimit) {
            Chunk chunk = location.getChunk();
            Set<Chunk> chunkSet = IntensifyConstants.CHUNK_SET;
            if (chunkSet.contains(location.getChunk())) {
                return;
            }
            IntensifyConstants.CHUNK_SET.add(chunk);
        }
        player.getWorld().dropItem(location, IntensifyUtil.getRyanCokes());
        String blockBreakMag = BaseUtil.getMsgNotColor("blockBreakMag", MapUtil.of("${name}", BaseUtil.getMsgNotColor("ryanCokes.name")));
        MessageUtil.sendMessage(player, blockBreakMag);
    }
}

