/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class FurnaceBurnEventListener
implements Listener {
    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        BlockState state = event.getBlock().getState();
        if (!(state instanceof Furnace)) {
            return;
        }
        Furnace furnace = (Furnace)state;
        ItemStack smelting = furnace.getInventory().getSmelting();
        if (smelting == null || Material.AIR.equals((Object)smelting.getType())) {
            return;
        }
        if (!BaseConstants.CONFIG.getBoolean("furnaceBurn", true)) {
            return;
        }
        ItemStack fuel = event.getFuel().clone();
        if (SwordEnum.getEnum(smelting.getType()) == null) {
            return;
        }
        if (CokesTypeEnum.isSimilar(fuel) == null) {
            event.setCancelled(true);
            return;
        }
        if (!event.getBlock().hasMetadata("intensifyPlayer")) {
            event.setCancelled(true);
            return;
        }
        UUID playerUuid = IntensifyUtil.getBlockPlayerUuid(event.getBlock());
        if (playerUuid == null) {
            event.setCancelled(true);
            return;
        }
        boolean check = FurnaceBurnEventListener.check(smelting);
        if (!check) {
            event.setCancelled(true);
            return;
        }
        event.setBurnTime(120);
        int hashCode = event.getBlock().hashCode();
        IntensifyConstants.FUEL_ITEM.put(hashCode, fuel);
    }

    public static boolean check(ItemStack smelting) {
        if (FurnaceBurnEventListener.filterLore(smelting)) {
            return false;
        }
        if (FurnaceBurnEventListener.whitelist(smelting)) {
            return false;
        }
        return smelting.getAmount() == 1;
    }

    private static boolean filterLore(ItemStack smelting) {
        if (smelting.getItemMeta() == null) {
            return false;
        }
        List loreList = smelting.getItemMeta().getLore();
        if (CollUtil.isEmpty(loreList)) {
            return false;
        }
        List filters = BaseConstants.CONFIG.getStringList("filter");
        if (CollUtil.isEmpty(filters)) {
            return false;
        }
        for (String lore : loreList) {
            for (String filter : filters) {
                if (!StrUtil.isNotEmpty(filter) || !lore.contains(filter)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean whitelist(ItemStack smelting) {
        if (smelting.getItemMeta() == null) {
            return false;
        }
        boolean enable = BaseConstants.CONFIG.getBoolean("whitelist.enable");
        if (!enable) {
            return false;
        }
        List loreList = smelting.getItemMeta().getLore();
        if (CollUtil.isEmpty(loreList)) {
            return true;
        }
        List whitelist = BaseConstants.CONFIG.getStringList("whitelist.lore");
        if (CollUtil.isEmpty(whitelist)) {
            return true;
        }
        for (String lore : loreList) {
            for (String filter : whitelist) {
                if (!StrUtil.isNotEmpty(filter) || !lore.contains(filter)) continue;
                return false;
            }
        }
        return true;
    }
}

