/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.listener;

import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.IntensifyResultTypeEnum;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.event.PlayerIntensifyEvent;
import cn.handyplus.intensify.intensify.IntensifyStrategy;
import cn.handyplus.intensify.lib.annotation.HandyListener;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.param.IntensifyResult;
import cn.handyplus.intensify.util.IntensifyUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class FurnaceSmeltEventListener
implements Listener {
    @EventHandler
    public void onFurnaceSmelt(FurnaceSmeltEvent event) {
        if (!BaseConstants.CONFIG.getBoolean("furnaceBurn", true)) {
            return;
        }
        int hashCode = event.getBlock().hashCode();
        ItemStack itemStack = IntensifyConstants.FUEL_ITEM.get(hashCode);
        if (itemStack == null) {
            if (SwordEnum.getEnum(event.getSource().getType()) != null) {
                event.setResult(event.getSource());
            }
            return;
        }
        CokesTypeEnum cokesTypeEnum = CokesTypeEnum.isSimilar(itemStack);
        if (cokesTypeEnum == null) {
            if (SwordEnum.getEnum(event.getSource().getType()) != null) {
                event.setResult(event.getSource());
            }
            return;
        }
        ItemStack source = event.getSource();
        ItemMeta itemMeta = source.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        SwordEnum swordEnum = SwordEnum.getEnum(source.getType());
        if (swordEnum == null) {
            return;
        }
        if (!event.getBlock().hasMetadata("intensifyPlayer")) {
            return;
        }
        UUID playerUuid = IntensifyUtil.getBlockPlayerUuid(event.getBlock());
        if (playerUuid == null) {
            return;
        }
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerUuid);
        IntensifyResult intensifyResult = IntensifyStrategy.getInstance().intensify(offlinePlayer, source, cokesTypeEnum);
        if (IntensifyResultTypeEnum.ERROR.equals((Object)intensifyResult.getResult())) {
            return;
        }
        if (IntensifyResultTypeEnum.FAILED_DISAPPEARED.equals((Object)intensifyResult.getResult())) {
            source.setAmount(0);
            event.setResult(new ItemStack(Material.AIR));
        } else if (IntensifyResultTypeEnum.FAILED_PROTECTION_CARD.equals((Object)intensifyResult.getResult())) {
            event.setResult(event.getSource());
        } else {
            event.setResult(source);
        }
        IntensifyConstants.FUEL_ITEM.remove(hashCode);
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerIntensifyEvent(intensifyResult));
    }
}

