/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.intensify.util;

import cn.handyplus.intensify.api.IntensifyApi;
import cn.handyplus.intensify.constants.CokesTypeEnum;
import cn.handyplus.intensify.constants.IntensifyConstants;
import cn.handyplus.intensify.constants.SwordEnum;
import cn.handyplus.intensify.entity.PlayerIntensifyEntity;
import cn.handyplus.intensify.lib.constants.BaseConstants;
import cn.handyplus.intensify.lib.core.CollUtil;
import cn.handyplus.intensify.lib.core.JsonUtil;
import cn.handyplus.intensify.lib.core.StrUtil;
import cn.handyplus.intensify.lib.util.BaseUtil;
import cn.handyplus.intensify.lib.util.HandyConfigUtil;
import cn.handyplus.intensify.lib.util.ItemStackUtil;
import cn.handyplus.intensify.lib.util.LotteryUtil;
import cn.handyplus.intensify.lib.util.MessageUtil;
import cn.handyplus.intensify.lib.util.ProbabilityUtil;
import cn.handyplus.intensify.param.Intensify;
import cn.handyplus.intensify.param.IntensifyCardParam;
import cn.handyplus.intensify.param.IntensifyResult;
import cn.handyplus.intensify.param.PlayerParticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class IntensifyUtil {
    public static ItemStack getRyanCokes() {
        return IntensifyUtil.getCokes(CokesTypeEnum.RYAN_COKES);
    }

    public static ItemStack getEnchantedCokes() {
        return IntensifyUtil.getCokes(CokesTypeEnum.ENCHANTED_COKES);
    }

    public static ItemStack getCokes(CokesTypeEnum cokesTypeEnum) {
        String name = BaseConstants.LANG_CONFIG.getString(cokesTypeEnum.getType() + ".name");
        List loreList = BaseConstants.LANG_CONFIG.getStringList(cokesTypeEnum.getType() + ".lore");
        int customModelData = BaseConstants.LANG_CONFIG.getInt(cokesTypeEnum.getType() + ".custom-model-data");
        return ItemStackUtil.getItemStack(Material.COAL.name(), name, loreList, true, customModelData);
    }

    public static ItemStack getProtectionAmulet() {
        String name = BaseConstants.LANG_CONFIG.getString("protectionAmulet.name");
        List loreList = BaseConstants.LANG_CONFIG.getStringList("protectionAmulet.lore");
        int customModelData = BaseConstants.LANG_CONFIG.getInt("protectionAmulet.custom-model-data");
        return ItemStackUtil.getItemStack(Material.BOOK.name(), name, loreList, true, customModelData);
    }

    public static ItemStack getProtectionCard() {
        String name = BaseConstants.LANG_CONFIG.getString("protectionCard.name");
        List loreList = BaseConstants.LANG_CONFIG.getStringList("protectionCard.lore");
        int customModelData = BaseConstants.LANG_CONFIG.getInt("protectionCard.custom-model-data");
        return ItemStackUtil.getItemStack(Material.ENCHANTED_BOOK.name(), name, loreList, true, customModelData);
    }

    public static ItemStack getSecretMedicines() {
        String name = BaseUtil.getLangMsg("secretMedicines.name");
        List loreList = BaseConstants.LANG_CONFIG.getStringList("secretMedicines.lore");
        int customModelData = BaseConstants.LANG_CONFIG.getInt("secretMedicines.custom-model-data");
        return ItemStackUtil.getItemStack(Material.POTION.name(), name, loreList, true, customModelData);
    }

    public static ItemStack getIntensifyCard(String cardName, Integer probability, Integer level) {
        ArrayList<String> newLoreList = new ArrayList<String>();
        List loreList = BaseConstants.LANG_CONFIG.getStringList("intensifyCard.lore");
        for (String lore : loreList) {
            if (lore.contains("${probability}")) {
                newLoreList.add(lore.replace("${probability}", probability.toString()));
                continue;
            }
            if (lore.contains("${level}")) {
                newLoreList.add(lore.replace("${level}", level.toString()));
                continue;
            }
            newLoreList.add(lore);
        }
        int customModelData = BaseConstants.LANG_CONFIG.getInt("intensifyCard.custom-model-data");
        ItemStack itemStack = ItemStackUtil.getItemStack(BaseUtil.getLangMsg("intensifyCard.material"), BaseUtil.replaceChatColor(cardName), BaseUtil.replaceChatColor(newLoreList), true, customModelData);
        IntensifyCardParam intensifyCardParam = IntensifyCardParam.builder().probability(probability).level(level).build();
        ItemStackUtil.setPersistentData(itemStack, JsonUtil.toJson(intensifyCardParam), "card");
        return itemStack;
    }

    public static void addRecipe(Plugin plugin) {
        IntensifyConstants.RECIPE_LIST.clear();
        if (BaseConstants.CONFIG.getBoolean("furnaceBurn", true)) {
            List<String> materialList = SwordEnum.getMaterialList();
            for (String materialStr : materialList) {
                Material material = ItemStackUtil.getMaterial(materialStr);
                NamespacedKey namespacedKey = new NamespacedKey(plugin, plugin.getName() + "." + material);
                FurnaceRecipe furnaceRecipe = new FurnaceRecipe(namespacedKey, new ItemStack(material), Material.COAL, 0.0f, 120);
                furnaceRecipe.setInput(material);
                Bukkit.addRecipe((Recipe)furnaceRecipe);
                IntensifyConstants.RECIPE_LIST.add(namespacedKey);
            }
        }
        IntensifyUtil.setRyanCokesLottery();
        IntensifyUtil.setBlockLottery();
        IntensifyUtil.setFishLottery();
        IntensifyUtil.setMobLottery();
    }

    public static boolean randomIndex(Player player, int level, CokesTypeEnum cokesTypeEnum) {
        int number = BaseConstants.CONFIG.getInt("ryanCokes." + level);
        if (number < 1) {
            return false;
        }
        number = cokesTypeEnum.getProbability(number);
        if (player != null) {
            number += IntensifyApi.getInstance().get(player.getUniqueId());
        }
        if (number < 1) {
            return false;
        }
        return ProbabilityUtil.getInstance().pickIndex(number, BaseConstants.CONFIG.getInt("maxNum"));
    }

    public static void setRyanCokesLottery() {
        IntensifyConstants.RYAN_COKES_MAP.clear();
        Map<String, String> ryanCokesMap = HandyConfigUtil.getStringMapChild(BaseConstants.CONFIG, "ryanCokes");
        Map<String, List<String>> failMap = HandyConfigUtil.getStringListMapChild(BaseConstants.CONFIG, "fail");
        for (String key : ryanCokesMap.keySet()) {
            int keyInt = Integer.parseInt(key);
            boolean isVanish = false;
            boolean isLevel = false;
            ArrayList<Integer> levelOff = new ArrayList();
            List<String> failList = failMap.get(key);
            if (CollUtil.isNotEmpty(failList)) {
                isLevel = true;
                levelOff = failList.stream().map(Integer::parseInt).collect(Collectors.toList());
            } else if (keyInt > 10) {
                isVanish = true;
                levelOff = Collections.singletonList(1);
            }
            IntensifyConstants.RYAN_COKES_MAP.put(keyInt, new Intensify(isVanish, isLevel, levelOff));
        }
    }

    public static void setBlockLottery() {
        Map<String, String> blockMap = HandyConfigUtil.getStringMapChild(BaseConstants.CONFIG, "block");
        for (String key : blockMap.keySet()) {
            double probability = Double.parseDouble(blockMap.get(key));
            LotteryUtil lotteryUtil = new LotteryUtil(Arrays.asList(probability, 1.0 - probability));
            IntensifyConstants.BLOCK_LOTTERY_MAP.put(key, lotteryUtil);
        }
    }

    public static void setFishLottery() {
        Map<String, String> fishMap = HandyConfigUtil.getStringMapChild(BaseConstants.CONFIG, "fish");
        for (String key : fishMap.keySet()) {
            double probability = Double.parseDouble(fishMap.get(key));
            LotteryUtil lotteryUtil = new LotteryUtil(Arrays.asList(probability, 1.0 - probability));
            IntensifyConstants.FISH_LOTTERY_MAP.put(key, lotteryUtil);
        }
    }

    public static void setMobLottery() {
        double probability = BaseConstants.CONFIG.getDouble("kill.monster");
        IntensifyConstants.MONSTER_LOTTERY_MAP = new LotteryUtil(Arrays.asList(probability, 1.0 - probability));
    }

    public static void sendAllMsg(IntensifyResult intensifyResult) {
        Player player = intensifyResult.getPlayer();
        OfflinePlayer offlinePlayer = intensifyResult.getOfflinePlayer();
        if (player != null && (GameMode.CREATIVE.equals((Object)player.getGameMode()) || player.isOp())) {
            return;
        }
        if (offlinePlayer.isOp()) {
            return;
        }
        int sendLevelAllMsg = BaseConstants.CONFIG.getInt("sendLevelAllMsg", 8);
        if (intensifyResult.getLevel() < sendLevelAllMsg) {
            return;
        }
        String playerName = intensifyResult.getOfflinePlayer().getName() != null ? intensifyResult.getOfflinePlayer().getName() : "";
        String displayName = intensifyResult.getDisplayName();
        switch (intensifyResult.getResult()) {
            case SUCCESS: {
                MessageUtil.sendAllMessage(BaseUtil.getLangMsg("allIntensifySucceedMsg").replace("${player}", playerName).replace("${displayName}", displayName));
                break;
            }
            case FAILED_DOWNGRADED: {
                MessageUtil.sendAllMessage(BaseUtil.getLangMsg("allIntensifyFailureLevelOffMsg").replace("${player}", playerName).replace("${displayName}", displayName));
                break;
            }
            case FAILED_DISAPPEARED: {
                MessageUtil.sendAllMessage(BaseUtil.getLangMsg("allIntensifyFailureMsg").replace("${player}", playerName).replace("${displayName}", displayName));
                break;
            }
            case FAILED_PROTECTION_CARD: 
            case FAILED_NO_CHANGE: 
            case FAILED: 
            case FAILED_PROTECTION_AMULET: {
                MessageUtil.sendAllMessage(BaseUtil.getLangMsg("allIntensifyProtectionCardMsg").replace("${player}", playerName).replace("${displayName}", displayName));
                break;
            }
        }
    }

    public static void setParticle(Player player, ItemStack item) {
        SwordEnum swordEnum = SwordEnum.getEnum(item.getType());
        if (swordEnum == null || item.getItemMeta() == null || !SwordEnum.isParticleEnable(swordEnum)) {
            return;
        }
        int intensifyLevel = IntensifyUtil.getIntensifyLevel(item.getItemMeta().getDisplayName());
        Map<Integer, String> particleMap = SwordEnum.getParticleMap(swordEnum);
        if (particleMap.get(intensifyLevel) == null) {
            return;
        }
        IntensifyConstants.PLAYER_PARTICLE_MAP.put(player.getName(), new PlayerParticle(true, intensifyLevel, particleMap.get(intensifyLevel)));
    }

    public static UUID getBlockPlayerUuid(Block block) {
        List intensifyName = block.getMetadata("intensifyPlayer");
        MetadataValue metadataValue = (MetadataValue)intensifyName.get(0);
        Object value = metadataValue.value();
        if (!(value instanceof UUID)) {
            return null;
        }
        return (UUID)value;
    }

    public static List<String> getTextLineList(List<PlayerIntensifyEntity> ranking) {
        ArrayList<String> textLineList = new ArrayList<String>();
        textLineList.add("\u00a7e======\u5168\u670d\u5f3a\u5316\u6392\u884c\u699c======");
        for (PlayerIntensifyEntity playerIntensifyEntity : ranking) {
            textLineList.add("\u00a7f\u73a9\u5bb6:\u00a7e" + playerIntensifyEntity.getPlayerName() + " \u00a7f\u5f3a\u5316\u6b21\u6570:\u00a7e" + playerIntensifyEntity.getSum() + " \u00a7f\u6210\u529f\u6b21\u6570:\u00a7e" + playerIntensifyEntity.getSucceedNum() + " \u00a7f\u5931\u8d25\u6b21\u6570:\u00a7e" + playerIntensifyEntity.getFailureNum());
        }
        return textLineList;
    }

    public static String delIntensifyLevel(String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        Matcher matcher = IntensifyConstants.INTENSIFY_PATTERN.matcher(str);
        ArrayList<String> matchStrList = new ArrayList<String>();
        while (matcher.find()) {
            matchStrList.add(matcher.group());
        }
        if (CollUtil.isEmpty(matchStrList)) {
            return str;
        }
        String levelStr = (String)matchStrList.get(matchStrList.size() - 1);
        return str.replace(levelStr, "");
    }

    public static Map<String, List<String>> getCustomMaterialMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        boolean enableCustom = BaseConstants.CONFIG.getBoolean("enable.custom");
        if (!enableCustom) {
            return map;
        }
        Set<String> customMaterial = HandyConfigUtil.getKey(BaseConstants.CONFIG, "customMaterial");
        if (CollUtil.isNotEmpty(customMaterial)) {
            for (String key : customMaterial) {
                List customMaterialList = BaseConstants.CONFIG.getStringList("customMaterial." + key);
                map.put(key, customMaterialList);
            }
        }
        return map;
    }

    private static int getIntensifyLevel(String str) {
        if (StrUtil.isEmpty(str)) {
            return 0;
        }
        Matcher matcher = IntensifyConstants.INTENSIFY_PATTERN.matcher(str);
        ArrayList<String> matchStrList = new ArrayList<String>();
        while (matcher.find()) {
            matchStrList.add(matcher.group());
        }
        if (CollUtil.isEmpty(matchStrList)) {
            return 0;
        }
        String levelStr = (String)matchStrList.get(matchStrList.size() - 1);
        String replace = levelStr.replace("\u00a7f[+\u00a7a", "").replace("\u00a7f]", "");
        return Integer.parseInt(replace);
    }
}

